/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.HideDockButtonHandler;

public class GraphQueryWherePanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphQueryWherePanel.class);
    JButton btnAddNewAndFolder;
    JButton btnAddNewOrFolder;
    JButton btnDeleteFolder;
    JSplitPane split;
    JTree treeWhere;

    public GraphQueryWherePanel(HideDockButtonHandler hideDockButtonHandler, JComponent editor, GraphPluginResources rsrc) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createButtonPanel(hideDockButtonHandler, rsrc), "North");
        this.split = new JSplitPane(1);
        this.treeWhere = new JTree();
        this.split.setLeftComponent(new JScrollPane(this.treeWhere));
        this.split.setRightComponent(this.createEditorPanel(editor));
        this.split.setOneTouchExpandable(true);
        this.add(this.split);
    }

    private JPanel createEditorPanel(JComponent editor) {
        JPanel ret = new JPanel(new BorderLayout(0, 5));
        JLabel lbl = new JLabel(s_stringMgr.getString("graph.GraphQueryWherePanel.wherePreview"));
        ret.add((Component)lbl, "North");
        JPanel editorPanel = new JPanel(new GridLayout(1, 1));
        editorPanel.setBorder(BorderFactory.createEtchedBorder());
        editorPanel.add(editor);
        ret.add(editorPanel);
        ret.setMinimumSize(new Dimension(25, ret.getMinimumSize().height));
        return ret;
    }

    private JPanel createButtonPanel(HideDockButtonHandler hideDockButtonHandler, GraphPluginResources rsrc) {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0);
        ret.add((Component)hideDockButtonHandler.getHideButton(), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0);
        this.btnAddNewAndFolder = new JButton(s_stringMgr.getString("graph.GraphQueryWherePanel.addNewAndFolder"));
        this.btnAddNewAndFolder.setIcon(rsrc.getIcon("newandfolder"));
        ret.add((Component)this.btnAddNewAndFolder, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0);
        this.btnAddNewOrFolder = new JButton(s_stringMgr.getString("graph.GraphQueryWherePanel.addNewOrFolder"));
        this.btnAddNewOrFolder.setIcon(rsrc.getIcon("neworfolder"));
        ret.add((Component)this.btnAddNewOrFolder, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0);
        this.btnDeleteFolder = new JButton(s_stringMgr.getString("graph.GraphQueryWherePanel.deleteFolder"));
        this.btnDeleteFolder.setToolTipText(s_stringMgr.getString("graph.GraphQueryWherePanel.willMoveFiltersToUpper"));
        this.btnDeleteFolder.setIcon(rsrc.getIcon("deletefolder"));
        ret.add((Component)this.btnDeleteFolder, gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0);
        JLabel lblFiltered = new JLabel(s_stringMgr.getString("graph.GraphQueryWherePanel.onlyFiltered"));
        lblFiltered.setForeground(Color.red);
        lblFiltered.setFont(lblFiltered.getFont().deriveFont(1));
        ret.add((Component)lblFiltered, gbc);
        gbc = new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }
}

