//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package managementpartner

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/managementpartner/mgmt/2018-02-01/managementpartner"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type Code = original.Code

const (
	BadRequest Code = original.BadRequest
	Conflict   Code = original.Conflict
	NotFound   Code = original.NotFound
)

type State = original.State

const (
	Active  State = original.Active
	Deleted State = original.Deleted
)

type BaseClient = original.BaseClient
type Error = original.Error
type ExtendedErrorInfo = original.ExtendedErrorInfo
type OperationClient = original.OperationClient
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationListIterator = original.OperationListIterator
type OperationListPage = original.OperationListPage
type OperationResponse = original.OperationResponse
type PartnerClient = original.PartnerClient
type PartnerProperties = original.PartnerProperties
type PartnerResponse = original.PartnerResponse
type PartnersClient = original.PartnersClient

func New() BaseClient {
	return original.New()
}
func NewOperationClient() OperationClient {
	return original.NewOperationClient()
}
func NewOperationClientWithBaseURI(baseURI string) OperationClient {
	return original.NewOperationClientWithBaseURI(baseURI)
}
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return original.NewOperationListIterator(page)
}
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return original.NewOperationListPage(cur, getNextPage)
}
func NewPartnerClient() PartnerClient {
	return original.NewPartnerClient()
}
func NewPartnerClientWithBaseURI(baseURI string) PartnerClient {
	return original.NewPartnerClientWithBaseURI(baseURI)
}
func NewPartnersClient() PartnersClient {
	return original.NewPartnersClient()
}
func NewPartnersClientWithBaseURI(baseURI string) PartnersClient {
	return original.NewPartnersClientWithBaseURI(baseURI)
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func PossibleCodeValues() []Code {
	return original.PossibleCodeValues()
}
func PossibleStateValues() []State {
	return original.PossibleStateValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
