/*
   DISKCOPY.EXE, floppy diskette duplicator similar to MSDOS Diskcopy.
   Copyright (C) 1998, Matthew Stanford.
   Copyright (C) 1999, 2000, 2001 Imre Leber.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have recieved a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   If you have any questions, comments, suggestions, or fixes please
   email me at: imre.leber@worldonline.be

 */

#ifndef DRVTYPES_H_
#define DRVTYPES_H_

#define dtError     0x00	/* Invalid drive, letter not assigned         */
#define dtFixed     0x01	/* Fixed drive                                */
#define dtRemovable 0x02	/* Removable (floppy, etc.) drive             */
#define dtRemote    0x03	/* Remote (network) drive                     */
#define dtCDROM     0x04	/* MSCDEX V2.00+ driven CD-ROM drive          */
#define dtDblSpace  0x05	/* DoubleSpace compressed drive               */
#define dtSUBST     0x06	/* SUBST'ed drive                             */
/* dudes, where are Stacker 1,2,3 check-routines?                        */
#define dtStacker4  0x08	/* Stacker 4 compressed drive                 */
#define dtRAMDrive  0x09	/* RAM drive                                  */
#define dtDublDisk  0x0a	/* Vertisoft DoubleDisk 2.6 compressed drive  */
#define dtBernoully 0x0b	/* IOmega Bernoully drive                     */
#define dtDiskreet  0x0c	/* Norton Diskreet drive                      */
#define dtSuperStor 0x0d	/* SuperStor compressed drive                 */

int CheckStacker4 (char drive);
int CheckDiskreet (char drive);
int CheckSuperStor (char drive);
int GetDriveType (char drive);
int CountValidDrives (void);
int FloppyDrives (void);

#endif
