/*
// Module:  DETDL2.C
// Module Description:  Module to assign drive letters.
// Module Written By:  Takeshi Hamasaki
// Integrated into Free FDISK by:  Brian E. Reifsnyder
// Module Version:  1.0
// Copyright:  2002 under the terms of the GNU GPL, Version 2
*/


#define HARD_DRIVES 8
#define PRI_PARTS 4
#define EXT_PARTS 27
#define ACTIVATED 0x80


#include "pdiskio.h"
#include "main.h"

typedef int bool;


bool Is_DOS_Partition(int index, int sub_index);
bool Is_Win_Partition(int index, int sub_index);

/* Determine drive letters */
/* Normally returns a 0, returns a 1 if current_letter>='Z' */
int Determine_Drive_Letters()
{
  int current_letter='C';
  int non_dos_partition_counter;
  int index=0;
  int sub_index=0;

  Load_Brief_Partition_Table();

  /* Clear drive_lettering_buffer[8] [27] */
    for (index=0; index < HARD_DRIVES; index++)
	for (sub_index=0; sub_index< EXT_PARTS; sub_index++)
	    drive_lettering_buffer[index] [sub_index]=0;

    /* Begin placement of drive letters */
    /* First, Active DOS/Win Partition(s) each Drive */
    for (index=0; index < HARD_DRIVES; index++){
	for (sub_index=0; sub_index< PRI_PARTS; sub_index++){
	    if ( part_table[index].active_status[sub_index] == ACTIVATED){
                if ( Is_DOS_Partition(index, sub_index) ==TRUE
                   ||Is_Win_Partition(index, sub_index) ==TRUE){
                    drive_lettering_buffer[index] [sub_index]=current_letter;
                    current_letter++;
                } 
            }
        }
    }

    /* Next, non-Active Primary DOS/Win Partition(s) */
    for (index=0; index < HARD_DRIVES; index++){
        for (sub_index=0; sub_index< PRI_PARTS; sub_index++){
            if ( part_table[index].active_status[sub_index] != ACTIVATED){
                if ( Is_DOS_Partition(index, sub_index) ==TRUE
                   ||Is_Win_Partition(index, sub_index) ==TRUE){
                    drive_lettering_buffer[index] [sub_index]=current_letter;
                    current_letter++;
                } 
	    }
	}
    }

    /* At last, DOS/Win Extended DOS/Win Partition(s) */
    for (index=0; index < HARD_DRIVES; index++){
        for (sub_index=PRI_PARTS; sub_index< EXT_PARTS; sub_index++){
            if ( Is_DOS_Partition(index, sub_index) ==TRUE
               ||Is_Win_Partition(index, sub_index) ==TRUE){
                drive_lettering_buffer[index] [sub_index]=current_letter;
                current_letter++;
            } 
	}
    }

    /* Find the Non-DOS Logical Drives in the Extended Partition Table */
    for (index=0; index < HARD_DRIVES; index++){
	non_dos_partition_counter='1';
	part_table[index].num_of_non_dos_log_drives=0;
	for (sub_index=PRI_PARTS; sub_index< EXT_PARTS; sub_index++){
	    if ( brief_partition_table[index] [sub_index] >0
	       && (drive_lettering_buffer[index] [sub_index] == 0)
	       && (non_dos_partition_counter <= '9') ){
		  drive_lettering_buffer[index] [sub_index]=non_dos_partition_counter;
		  part_table[index].num_of_non_dos_log_drives++;
		  non_dos_partition_counter++;

	    }
	}
    }

    if(current_letter>'Z') return(1); else return(0);
}

bool Is_DOS_Partition(int index, int sub_index)
{
    int p_type = brief_partition_table[index] [sub_index];

      if( p_type==1
       || p_type==4
       || p_type==6) 
        return TRUE;
      else
        return FALSE;
}

bool Is_Win_Partition(int index, int sub_index)
{
    int p_type = brief_partition_table[index] [sub_index];

      if( ( p_type==0x0e
	    && ( (flags.version==W95)
	      || (flags.version==W95B)
	      || (flags.version==W98) ) )
       || ( p_type==0x0b || p_type==0x0c)
	    && ( (flags.version==W95B)
	      || (flags.version==W98) ) )
	return TRUE;
      else
	return FALSE;
}

