; A part of FRM.COM package...this is released to the Public Domain
[BITS 16]
[ORG 0x100]

_main:
   ; Save our current Data Segment
   PUSH DS

   ; We want to initialize VGA Mode 0x13
   MOV AX, 0x13

   ; Call the Video Interrupt
   INT 0x10

   ; The DS should be set to 0
   XOR AX, AX
   ; Put zero in DS
   MOV DS, AX

   ; Just some weird pattern we write to VGA buffer
   MOV EAX, 0x01020304

   ; There 64000 (0xFA00) bytes in VGA Mode 0x13
   MOV ECX, 0xFA00

   ; The VGA Mode 0x13 segment starts at 0xA000 or a 32-bit linear
   ;    address 0xA0000
   ; 0xA0000 + ECX = Yields the address we want to write to
   MOV EBX, ECX
   ADD EBX, 0xA0000

   looper:
      ; Write the pattern to the VGA buffer (DWORD)
      MOV [ EBX ], EAX

      ; Adjust the pattern
      ADD EAX, 0x04040404

      ; We written a DWORD, so we have to subtract by four the next
      ;    address
      SUB EBX, 4

      ; The loop looks kinda like this in C/C++
      ;    for( i = 0xFA00; i > 0; i -= 4 )
      ; The LOOP instruction only decrements by one, so we subtract three
      ;    before we get there
      SUB CX, 3
      LOOP looper
   
   ; Wait until a key is pressed   
   _getKey:
      ; BIOS Keyboard wait for keypress function
      XOR AH, AH
      ; Call the BIOS Keyboard Interrupt
      INT 0x16

   ; Restore normal text mode
   MOV AX, 0x03
   ; Call Video Interrupt
   INT 0x10

   ; Restore original DS
   POP DS

   ; Return to DOS w/error code 0
   MOV AX, 0x4C00
   ; Call DOS
   INT 0x21
