/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include "FILLTBL.H"
#include "ISHRDDRV.H"
#include "HDTBL.H"
#include "GLOBALS.H"


/* This will initialize the table of valid drives, if list was
   previously initialized (list != NULL) then it frees the old list
   and reinitializes.
*/
void filltable ( void )
{
	BYTE i;
	register BYTE drv_type;
	int resetsel = 0;
	BYTE oldcursor = cursor; // currently selected drive index (1 based) in list
	BYTE oldbase = base;     // display base, offset (0 based) in list to start display

	if (list != NULL)
	{
		resetsel = 1;
		clearlist();
	}

	for (i=('Z'-'A'+1); i>=3; i--)  /* stop at 3==C:, ie ignore A: & B: */
	{
#ifndef TEST_ALLDRVS
		drv_type = isHardDrive(i);
#else
		drv_type = DRV_EXISTS;
#endif
		if (drv_type)	// could alter to runtime tests for removable,etc
			hdadd(i, drv_type);
	}

	if (resetsel)
	{
		cursor = oldcursor;
		base = oldbase;
	}
}
