/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
   "Choose a partition" section of INSTALL
*/

#include <stdlib.h>
#include <stdio.h>
#include <conIO.h>
#include <string.h>

#include "FMTSYS.H"
#include "GLOBALS.H"
#include "BOX.H"


/* displays user with a choice of valid drives and comands
   such as fdisk, format & sys then returns user's choice.
   This should be called in a loop, so user can select a drive,
   run fdisk (which may reboot or may cancel out without changes),
   run format, sys, etc, in any order.  Once user is done with
   these options the CONTINUE command is returned, or ABORT if
   user wishes to end install.
*/
void fmtsys ( /*void*/ char *s )
{
/*	char s[80]; */
	int key;
/*	BYTE cursor; */

/****************** PAINT THE SCREEN  ****************/
	/*** TO DO: ADD HERE THE INSTALL FEATURES: outer box, check colors...*/
	textcolor(14);
	textbackground (1);
	clrscr();
      box (1, 2, 80, 24);


	/* Painting the screen */
/*	filltable(); */
	gotoxy (2, 1); textcolor(15);
	cputs ("FREEDOS Partition Management");
	gotoxy (4,5); textcolor(14);
	cputs ("Please, choose the destination drive for FreeDOS:");
	drawalltable();

	/** ARROW KEYS **/
	strcpy (s, "^ v  Move the cursor up and down"); s[0]=24; s[2]=25;
	gotoxy (9,11+((maxhd<MAXHDSHOW)?maxhd:MAXHDSHOW)); cputs(s);

	/*the options column */
	/** TB of the Box **/
	strrep (s,'',24);
	s[0]=''; s[23]='';
	gotoxy (50,7);
	cputs (s);
	strrep (s,'',24);
	s[0]=''; s[23]='';
	gotoxy (50,18);
	cputs (s);

	/** Buttons **/
      if (list!=NULL) textcolor (14); else textcolor (8); /* disable continue if no hd's found */
	gotoxy (50,8); strcpy (s," Continue install ( )"); s[20]=17; cputs(s);
	textcolor (14); gotoxy (50,8); cputs(""); gotoxy (73,8); cputs("");
	if (list!=NULL) { textcolor(12); gotoxy (52,8); cputs("C"); }

      textcolor (14);
	gotoxy (50,9); cputs("  Abort install (ESC) ");
	textcolor(12); gotoxy (53,9); cputs("A");
      
      textcolor (14);
	strrep (s,196,22);
	gotoxy (50,10); cputs("");cputs(s);cputs("");

      if (aflg_qformat) textcolor (14); else textcolor (8);
	gotoxy (50,11); cputs(" Quick format (FAT16) ");
	textcolor (14); gotoxy (50,11); cputs(""); gotoxy (73,11); cputs("");
	if (aflg_qformat) { textcolor(12); gotoxy (52,11); cputs("Q"); }
      if (aflg_format) textcolor (14); else textcolor (8);
	gotoxy (50,12); cputs(" Total format (FAT16) ");
	textcolor (14); gotoxy (50,12); cputs(""); gotoxy (73,12); cputs("");
	if (aflg_format) { textcolor(12); gotoxy (52,12); cputs("T"); }
      if (aflg_sys) textcolor (14); else textcolor (8);
	gotoxy (50,13); cputs(" Make bootable (SYS)  ");
	textcolor (14); gotoxy (50,13); cputs(""); gotoxy (73,13); cputs("");
	if (aflg_sys) { textcolor(12); gotoxy (52,13); cputs("M"); }

      textcolor (14);
	strrep (s,196,22);
	gotoxy (50,14); cputs("");cputs(s);cputs("");

      if (aflg_fdisk) textcolor (14); else textcolor (8);
	gotoxy (50,15); cputs(" Partition with FDISK ");
	textcolor (14); gotoxy (50,15); cputs(""); gotoxy (73,15); cputs("");
	if (aflg_fdisk) { textcolor(12); gotoxy (67,15); cputs("F"); }
      if (aflg_ranishpm) textcolor (14); else textcolor (8);
	gotoxy (50,16); cputs(" Ranish Part.Manager  ");
	textcolor (14); gotoxy (50,16); cputs(""); gotoxy (73,16); cputs("");
	if (aflg_ranishpm) { textcolor(12); gotoxy (52,16); cputs("R"); }
      if (aflg_fips) textcolor (14); else textcolor (8);
	gotoxy (50,17); cputs("   Split with FIPS    ");
	textcolor (14); gotoxy (50,17); cputs(""); gotoxy (73,17); cputs("");
	if (aflg_fips) { textcolor(12); gotoxy (54,17); cputs("S"); }
      
      textcolor (14);

	/** Tips **/
	gotoxy (5,19); cputs("Notes:");
	gotoxy (5,20); cputs("Formatting a drive will remove all the data on that drive.");
      gotoxy (5,21); cputs("Backup your data before proceeding!  Not responsible for loss of data.");
      gotoxy (5,22); cputs("FreeDOS is a trademark of Jim Hall (http://www.freedos.org)");



/****************** CATCH THE KEYS  ************************/

/*	cursor = 1; */
	do {
		key = getch();
		switch (key)  {
			case 0:
				key = getch();
				if ((key !=72) && (key !=80))
					break;
				hddraw (FALSE, cursor);
				if (key==72)
				{
					if ( !--cursor)
					{
						cursor = maxhd;
						if ((maxhd-MAXHDSHOW)>=cursor) base = cursor-1;
						else base = (maxhd>=MAXHDSHOW)?(maxhd-MAXHDSHOW):0;
					}
					else
						if (cursor <= base) base--;
				}
				if (key==80)
				{
					if ((++cursor)>maxhd)
					{
						cursor = 1;
						if (cursor>MAXHDSHOW) base = cursor-MAXHDSHOW;
						else base = 0;
					}
					else
						if (cursor-base > MAXHDSHOW) base++;
				}
				/* hddraw (TRUE, cursor); */
				drawalltable();
		}
		/*** TODO/WISH: if SYS, then check that destination drive
			has enough room for KERNEL/COMMAND  ***/
	} while (!(  (key == 27) ||  /* ESC */
			 (key == 'a') || (key == 'A') ||
			 ( (list != NULL) &&
			 ((key == 13) ||  /* Enter */
			  (key == 'c') || (key == 'C')) ) ||
			 (aflg_qformat && ((key == 'q') || (key == 'Q')) ) ||
			 (aflg_format && ((key == 't') || (key == 'T')) ) ||
			 (aflg_sys && ((key == 'm') || (key == 'M')) ) ||
			 (aflg_fdisk && ((key == 'f') || (key == 'F')) ) ||
			 (aflg_ranishpm && ((key == 'r') || (key == 'R')) ) ||
			 (aflg_fips && ((key == 's') || (key == 'S')) )
	));


/**************** Interpretate user's command ***************/
	/** we assume the caller will really execute the S */
	textcolor(0);
	gotoxy (20,25); cputs ("Executing");
	gotoxy (30,25); 

	switch (key)  {
		case 'C': case 'c': case 13:
			strcpy (s, CONTINUE_COMMAND);
			cputs(CONTINUE_COMMAND);
		break;
		case 'A': case 'a': case 27:
			strcpy (s, ABORT_COMMAND);
			cputs(ABORT_COMMAND);
		break;
		case 'Q': case 'q':
			strcpy (s, cmd_qformat);
			cputs(QFORMAT_COMMAND);
		break;
		case 'T': case 't':
			strcpy (s, cmd_format);
			cputs(FORMAT_COMMAND);
		break;
		case 'M': case 'm':
			strcpy (s, cmd_sys);
			cputs(SYS_COMMAND);
		break;
		case 'F': case 'f':
			strcpy (s, cmd_fdisk);
			cputs(FDISK_COMMAND);
		break;
		case 'R': case 'r':
			strcpy (s, cmd_ranishpm);
			cputs(PMANAGER_COMMAND);
		break;
		case 'S': case 's':
			strcpy (s, cmd_fips);
			cputs(FIPS_COMMAND);
		break;
	}

	strrepl (s, '?', (gethd(cursor)->letter) +'A'-1);
}
