/* Copyright (C) 2002 kjd */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <dos.h>
#include "ISCDDRV.H"

/* Returns 0 if no CD drives, otherwise nonzero == # of drive letters used */
int areCDROMsInstalled (void)
{
	union REGS regs;

	regs.x.ax = 0x1500; // AH=0x15, MSCDEX id on 0x2F chain
	                    // AL=0x00, # of drive letters used
	regs.x.bx = 0x0000; // BX=0x00 on entry, nonzero on exit
                          //         if CD drives available
                          //         still 0x0 if MSCDEX not installed
	int86 (0x2F, &regs, &regs);
	// regs.x.cx == starting drive letter (0=A,1=B,2=C,...)
	return regs.x.bx;
}

/* Returns version, high byte is major, low byte minor.
   Prior to MSCDEX version 2.0 this is not implemented and returns
   0x00.  E.g. version 2.10 would be 0x020a
*/
WORD getCDEXVersion (void)
{
	union REGS regs;

	regs.x.ax = 0x150C; // AH=0x15, MSCDEX id on 0x2F chain
	                    // AL=0x0C, get version
	regs.x.bx = 0x0000; // BX=0x00 on entry, version on exit
                          //         still 0x0 if MSCDEX not installed
	                    //         or version prior to v2.0
	int86 (0x2F, &regs, &regs);
	// regs.x.bh == major, regs.x.bl == minor
	return regs.x.bx;
}

static int numCDDrvLetters = -1;  // -1 means uninitialized

/* returns non zero if drive is reported as CDROM by MSCDEX or
   equivalent, FALSE otherwise.  
   Note: This requires MSCDEX v2.0 or higher to work correctly,
   and may return FALSE for lower versions when it should be TRUE.
   drivenum is 1=A:,2=B:,3=C:,...
   Note: this will call areCDROMsInstalled, so there is no
   need to test for CDROMs 1st before calling this function.
*/
BOOL isCDRomDrive (BYTE drivenum)
{
	union REGS regs;

	// make sure MSCDEX installed & we have count of drives letters used
	if (numCDDrvLetters < 0)
		numCDDrvLetters = areCDROMsInstalled();

	if (numCDDrvLetters)
	{
		regs.x.ax = 0x150B; // AH=0x15, MSCDEX id on 0x2F chain
		                    // AL=0x0B, CDROM drive check
		regs.x.bx = 0x0000; // BX=0x00 on entry, 0xADAD on exit
      	                    //         if MSCDEX handled request
		regs.x.cx = drivenum-1; // drive letter to check
		int86 (0x2F, &regs, &regs);
		// check is only valid if MSCDEX handled request
		if (regs.x.ax == 0xADAD)
			return regs.x.ax;
	}

	return FALSE;
}
