/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.Nodes;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import iaik.xml.filter.impl.dsig.CanonInputStream;
import iaik.xml.filter.impl.dsig.Canonicalizer;
import iaik.xml.filter.impl.dsig.SequenceTraverser;
import iaik.xml.filter.impl.enc.WrapInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AlgorithmMethodImpl
extends DOMStructure
implements AlgorithmMethod {
    protected AlgorithmParameters params_;
    protected AlgorithmParameterSpec spec_;
    protected URI algorithm_;

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (this.containsElements(nodeList)) {
            try {
                this.params_ = AlgorithmParameters.getInstance(this.algorithm_.toString());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MarshalException(new InvalidAlgorithmParameterException(String.valueOf(this.algorithm_.toString()) + " does not support algorithm parameter."));
            }
            List list = DOMUtils.distributeNSDeclarations((Element)this.getNode());
            SequenceTraverser sequenceTraverser = new SequenceTraverser(Nodes.iterator(nodeList), true, true);
            CanonInputStream canonInputStream = new CanonInputStream(new Canonicalizer(sequenceTraverser, true, false, null));
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n = canonInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                this.params_.init(byteArrayOutputStream.toByteArray(), "XML");
            }
            catch (IOException iOException) {
                throw new MarshalException(new InvalidAlgorithmParameterException(iOException.getMessage()));
            }
            DOMUtils.withdrawDistributedNSDeclarations((Element)this.getNode(), list);
        }
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "Algorithm");
        if (attr != null) {
            String string = attr.getValue();
            try {
                this.algorithm_ = new URI(string);
            }
            catch (URIException uRIException) {
                throw new MarshalException("The algorithm URI '" + string + "' is not RFC 2396 compliant.");
            }
        }
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument(element);
        Attr attr = document.createAttributeNS("", "Algorithm");
        attr.setValue(this.algorithm_.toString());
        element.setAttributeNodeNS(attr);
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        super.marshal(dOMCryptoContext, node, node2);
        if (this.params_ != null) {
            Document document;
            byte[] byArray;
            try {
                byArray = this.params_.getEncoded("XML");
            }
            catch (IOException iOException) {
                throw new MarshalException(iOException);
            }
            WrapInputStream wrapInputStream = new WrapInputStream(new ByteArrayInputStream(byArray), null);
            try {
                document = DOMUtils.parse(wrapInputStream, new Boolean(true), new Boolean(true), new Boolean(false), null, null);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new MarshalException("Failed to marshal algorithm parameter.", parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new MarshalException("Failed to marshal algorithm parameter.", sAXException);
            }
            catch (IOException iOException) {
                throw new MarshalException("Failed to marshal algorithm parameter.", iOException);
            }
            Element element = document.getDocumentElement();
            if (element != null) {
                Document document2 = DOMUtils.getOwnerDocument(node);
                NodeList nodeList = element.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node3 = nodeList.item(n);
                    this.getNode().appendChild(document2.importNode(node3, true));
                    ++n;
                }
            }
        }
        return this.getNode();
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.spec_;
    }

    public String getAlgorithm() {
        return this.algorithm_.toString();
    }

    protected boolean containsElements(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() == 0) {
            return false;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected AlgorithmMethodImpl(Node node) {
        super(node);
    }

    protected AlgorithmMethodImpl(String string, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException("Argument 'algorithm' must not be null.");
        }
        try {
            this.algorithm_ = new URI(string);
        }
        catch (URIException uRIException) {
            throw new NoSuchAlgorithmException("Algorithm URI '" + string + "' is not RFC 2396 compliant.");
        }
        if (algorithmParameterSpec != null) {
            this.spec_ = algorithmParameterSpec;
            try {
                String string2 = XSecProvider.getDelegationProvider("AlgorithmParameters." + this.algorithm_.toString());
                this.params_ = string2 != null ? AlgorithmParameters.getInstance(this.algorithm_.toString(), string2) : AlgorithmParameters.getInstance(this.algorithm_.toString());
                this.params_.init(this.spec_);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new InvalidAlgorithmParameterException(noSuchProviderException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException(noSuchAlgorithmException.getMessage());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
            }
        }
    }
}

