/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.jrockit.jfr.RepositoryChunk;

@Deprecated
class ChunksChannel
implements ReadableByteChannel {
    private final Iterator<RepositoryChunk> chunks;
    private RepositoryChunk current;
    private ReadableByteChannel channel;

    public ChunksChannel(List<RepositoryChunk> list) throws IOException {
        if (list.isEmpty()) {
            throw new FileNotFoundException("No chunks");
        }
        ArrayList<RepositoryChunk> arrayList = new ArrayList<RepositoryChunk>(list.size());
        for (RepositoryChunk repositoryChunk : list) {
            repositoryChunk.use();
            arrayList.add(repositoryChunk);
        }
        this.chunks = arrayList.iterator();
        this.nextChannel();
    }

    private boolean nextChunk() {
        if (!this.chunks.hasNext()) {
            return false;
        }
        this.current = this.chunks.next();
        return true;
    }

    private boolean nextChannel() throws IOException {
        if (!this.nextChunk()) {
            return false;
        }
        this.channel = Channels.newChannel(this.current.newInputStream());
        return true;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        do {
            if (this.channel == null) continue;
            assert (this.current != null);
            int n = this.channel.read(byteBuffer);
            if (n != -1) {
                return n;
            }
            this.channel.close();
            this.current.release();
            this.channel = null;
            this.current = null;
        } while (this.nextChannel());
        return -1;
    }

    public void transferTo(FileChannel fileChannel) throws IOException {
        long l = 0L;
        do {
            long l2;
            if (this.channel == null) continue;
            assert (this.current != null);
            for (long i = this.current.getSize(); i > 0L; i -= l2) {
                long l3 = Math.min(i, 0x100000L);
                l2 = fileChannel.transferFrom(this.channel, l, l3);
                l += l2;
            }
            this.channel.close();
            this.current.release();
            this.channel = null;
            this.current = null;
        } while (this.nextChannel());
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        while (this.current != null) {
            this.current.release();
            if (this.nextChunk()) continue;
            return;
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel != null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

