/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.AuthenticatedData;
import iaik.cms.AuthenticatedDataStream;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.Content;
import iaik.cms.ContentInfo;
import iaik.cms.ContentInfoStream;
import iaik.cms.ContentStream;
import iaik.cms.Data;
import iaik.cms.DataStream;
import iaik.cms.DigestedData;
import iaik.cms.DigestedDataStream;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.EncryptedData;
import iaik.cms.EncryptedDataStream;
import iaik.cms.EnvelopedData;
import iaik.cms.EnvelopedDataStream;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SignedData;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.SigningTime;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.spec.InvalidParameterSpecException;

public class TestContentInfo {
    SecureRandom random;
    X509Certificate[] certificates;
    PrivateKey user2_crypt_pk;
    X509Certificate user2_crypt;
    PrivateKey user1_crypt_pk;
    X509Certificate user1_crypt;
    PrivateKey user2_sign_pk;
    X509Certificate user2_sign;
    PrivateKey user1_sign_pk;
    X509Certificate user1_sign;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nDataStream demo [create]:\n");
            byte[] byArray3 = this.createDataStream(byArray);
            System.out.println("\nDataStream demo [parse]:\n");
            byArray2 = this.getDataStream(byArray3);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nEnvelopedDataStream demo [create]:\n");
            byArray3 = this.createEnvelopedDataStream(byArray);
            System.out.println("\nEnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_crypt_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nImplicit SignedDataStream demo [create]:\n");
            byArray3 = this.createSignedDataStream(byArray, 1);
            System.out.println("\nImplicit SignedDataStream demo [parse]:\n");
            byArray2 = this.getSignedDataStream(byArray3, null);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit SignedDataStream demo [create]:\n");
            byArray3 = this.createSignedDataStream(byArray, 2);
            System.out.println("\nExplicit SignedDataStream demo [parse]:\n");
            byArray2 = this.getSignedDataStream(byArray3, byArray);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nSignedAndEncryptedDataStream demo [create]:\n");
            byArray3 = this.createSignedAndEncryptedDataStream(byArray);
            System.out.println("\nSignedAndEncryptedDataStream demo [parse]:\n");
            byArray2 = this.getSignedAndEncryptedDataStream(byArray3);
            System.out.print("\nSignedAndEncrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nImplicit DigestedDataStream demo [create]:\n");
            byArray3 = this.createDigestedDataStream(byArray, 1);
            System.out.println("\nImplicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getDigestedDataStream(byArray3, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit DigestedDataStream demo [create]:\n");
            byArray3 = this.createDigestedDataStream(byArray, 2);
            System.out.println("\nExplicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getDigestedDataStream(byArray3, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nEncryptedDataStream demo [create]:\n");
            byArray3 = this.createEncryptedDataStream(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nEncryptedDataStream demo [parse]:\n");
            byArray2 = this.getEncryptedDataStream(byArray3, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nImplicit AuthenticatedDataStream demo with auth attributes [create]:\n");
            byArray3 = this.createAuthenticatedDataStream(byArray, true, 1);
            System.out.println("\nImplicit AuthenticatedDataStream demo with auth attributes [parse]:\n");
            byArray2 = this.getAuthenticatedDataStream(byArray3, null, this.user1_crypt_pk, 0);
            System.out.print("\nVerified content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nImplicit AuthenticatedDataStream demo without auth attributes [create]:\n");
            byArray3 = this.createAuthenticatedDataStream(byArray, false, 1);
            System.out.println("\nImplicit AuthenticatedDataStream demo without auth attributes [parse]:\n");
            byArray2 = this.getAuthenticatedDataStream(byArray3, null, this.user1_crypt_pk, 0);
            System.out.print("\nVerified content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit AuthenticatedDataStream demo with auth attributes [create]:\n");
            byArray3 = this.createAuthenticatedDataStream(byArray, true, 2);
            System.out.println("\nExplicit AuthenticatedDataStream demo with auth attributes [parse]:\n");
            byArray2 = this.getAuthenticatedDataStream(byArray3, byArray, this.user1_crypt_pk, 0);
            System.out.print("\nVerified content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit AuthenticatedDataStream demo without auth attributes [create]:\n");
            byArray3 = this.createAuthenticatedDataStream(byArray, false, 2);
            System.out.println("\nExplicit AuthenticatedDataStream demo with auth attributes [parse]:\n");
            byArray2 = this.getAuthenticatedDataStream(byArray3, byArray, this.user1_crypt_pk, 0);
            System.out.print("\nVerified content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            System.out.println("\nData demo [create]:\n");
            byArray3 = this.createData(byArray);
            System.out.println("\nData demo [parse]:\n");
            byArray2 = this.getData(byArray3);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nEnvelopedData demo [create]:\n");
            byArray3 = this.createEnvelopedData(byArray);
            System.out.println("\nEnvelopedData demo [parse]:\n");
            byArray2 = this.getEnvelopedData(byArray3, this.user1_crypt_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nImplicit SignedData demo [create]:\n");
            byArray3 = this.createSignedData(byArray, 1);
            System.out.println("\nImplicit SignedData demo [parse]:\n");
            byArray2 = this.getSignedData(byArray3, null);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit SignedData demo [create]:\n");
            byArray3 = this.createSignedData(byArray, 2);
            System.out.println("\nExplicit SignedData demo [parse]:\n");
            byArray2 = this.getSignedData(byArray3, byArray);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nSignedAndEncryptedData demo [create]:\n");
            byArray3 = this.createSignedAndEncryptedData(byArray);
            System.out.println("\nSignedAndEncryptedData demo [parse]:\n");
            byArray2 = this.getSignedAndEncryptedData(byArray3);
            System.out.print("\nSignedAndEncrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nImplicit DigestedData demo [create]:\n");
            byArray3 = this.createDigestedData(byArray, 1);
            System.out.println("\nImplicit DigestedData demo [parse]:\n");
            byArray2 = this.getDigestedData(byArray3, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit DigestedData demo [create]:\n");
            byArray3 = this.createDigestedData(byArray, 2);
            System.out.println("\nExplicit DigestedData demo [parse]:\n");
            byArray2 = this.getDigestedData(byArray3, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nEncryptedData demo [create]:\n");
            byArray3 = this.createEncryptedData(byArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "password".toCharArray());
            System.out.println("\nEncryptedData demo [parse]:\n");
            byArray2 = this.getEncryptedData(byArray3, "password".toCharArray());
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nImplicit AuthenticatedData demo with auth attributes [create]:\n");
            byArray3 = this.createAuthenticatedData(byArray, true, 1);
            System.out.println("\nImplicit AuthenticatedData demo with auth attributes [parse]:\n");
            byArray2 = this.getAuthenticatedData(byArray3, null, this.user1_crypt_pk, 0);
            System.out.print("\nVerified content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nImplicit AuthenticatedData demo without auth attributes [create]:\n");
            byArray3 = this.createAuthenticatedData(byArray, false, 1);
            System.out.println("\nImplicit AuthenticatedData demo without auth attributes [parse]:\n");
            byArray2 = this.getAuthenticatedData(byArray3, null, this.user1_crypt_pk, 0);
            System.out.print("\nVerified content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit AuthenticatedData demo with auth attributes [create]:\n");
            byArray3 = this.createAuthenticatedData(byArray, true, 2);
            System.out.println("\nExplicit AuthenticatedData demo with auth attributes [parse]:\n");
            byArray2 = this.getAuthenticatedData(byArray3, byArray, this.user1_crypt_pk, 0);
            System.out.print("\nVerified content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit AuthenticatedData demo without auth attributes [create]:\n");
            byArray3 = this.createAuthenticatedData(byArray, false, 2);
            System.out.println("\nExplicit AuthenticatedData demo with auth attributes [parse]:\n");
            byArray2 = this.getAuthenticatedData(byArray3, byArray, this.user1_crypt_pk, 0);
            System.out.print("\nVerified content: ");
            System.out.println(new String(byArray2));
            System.out.println("Ready!");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new TestContentInfo().start();
        System.in.read();
    }

    public byte[] getSignedDataStream(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        X509Certificate x509Certificate;
        AlgorithmID[] algorithmIDArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfoStream contentInfoStream = new ContentInfoStream((InputStream)byteArrayInputStream);
        System.out.println("This ContentInfo holds content of type " + contentInfoStream.getContentType().getName());
        SignedDataStream signedDataStream = null;
        if (byArray2 == null) {
            signedDataStream = (SignedDataStream)contentInfoStream.getContent();
        } else {
            algorithmIDArray = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
            signedDataStream = new SignedDataStream((InputStream)new ByteArrayInputStream(byArray2), algorithmIDArray);
        }
        algorithmIDArray = signedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier((InputStream)algorithmIDArray, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray2 != null) {
            signedDataStream.decode(contentInfoStream.getContentInputStream());
        }
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                CMSContentType cMSContentType;
                x509Certificate = signedDataStream.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                if (signingTime != null) {
                    System.out.println("This message has been signed at " + signingTime.get());
                }
                if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                    System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedDataStream.verify(this.user1_sign);
            System.out.println("Signature OK from signer: " + signedDataStream.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1_sign.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        try {
            x509Certificate = signedDataStream.verify(this.user2_sign);
            System.out.println("Signature OK from signer: " + signedDataStream.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user2_sign.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getSignedData(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        X509Certificate x509Certificate;
        SignerInfo[] signerInfoArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfo contentInfo = new ContentInfo((InputStream)byteArrayInputStream);
        System.out.println("This ContentInfo holds content of type " + contentInfo.getContentType().getName());
        SignedData signedData = null;
        if (byArray2 == null) {
            signedData = (SignedData)contentInfo.getContent();
        } else {
            signerInfoArray = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
            try {
                signedData = new SignedData(byArray2, (AlgorithmID[])signerInfoArray);
                signedData.decode(contentInfo.getContentInputStream());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException(noSuchAlgorithmException.toString());
            }
        }
        System.out.println("SignedData contains the following signer information:");
        signerInfoArray = signedData.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                CMSContentType cMSContentType;
                x509Certificate = signedData.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                if (signingTime != null) {
                    System.out.println("This message has been signed at " + signingTime.get());
                }
                if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                    System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedData.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedData.verify(this.user1_sign);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1_sign.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        try {
            x509Certificate = signedData.verify(this.user2_sign);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user2_sign.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return signedData.getContent();
    }

    public byte[] getSignedAndEncryptedDataStream(byte[] byArray) throws IOException, CMSException {
        byte[] byArray2 = this.getEnvelopedDataStream(byArray, this.user2_crypt_pk, 1);
        return this.getSignedDataStream(byArray2, null);
    }

    public byte[] getSignedAndEncryptedData(byte[] byArray) throws IOException, CMSException {
        byte[] byArray2 = this.getEnvelopedData(byArray, this.user2_crypt_pk, 1);
        return this.getSignedData(byArray2, null);
    }

    public byte[] getEnvelopedDataStream(byte[] byArray, PrivateKey privateKey, int n) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfoStream contentInfoStream = new ContentInfoStream((InputStream)byteArrayInputStream);
        EnvelopedDataStream envelopedDataStream = (EnvelopedDataStream)contentInfoStream.getContent();
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        try {
            envelopedDataStream.setupCipher((Key)privateKey, n);
            InputStream inputStream = envelopedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.toString());
        }
    }

    public byte[] getEnvelopedData(byte[] byArray, PrivateKey privateKey, int n) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfo contentInfo = new ContentInfo((InputStream)byteArrayInputStream);
        EnvelopedData envelopedData = (EnvelopedData)contentInfo.getContent();
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)envelopedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        RecipientInfo[] recipientInfoArray = envelopedData.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        try {
            envelopedData.setupCipher((Key)privateKey, n);
            return envelopedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] getEncryptedDataStream(byte[] byArray, char[] cArray) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfoStream contentInfoStream = new ContentInfoStream((InputStream)byteArrayInputStream);
        EncryptedDataStream encryptedDataStream = (EncryptedDataStream)contentInfoStream.getContent();
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = encryptedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        try {
            encryptedDataStream.setupCipher(cArray);
            InputStream inputStream = encryptedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("Invalid Parameters: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("Invalid Parameters: " + invalidParameterSpecException.getMessage());
        }
    }

    public byte[] getEncryptedData(byte[] byArray, char[] cArray) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfo contentInfo = new ContentInfo((InputStream)byteArrayInputStream);
        System.out.println("This ContentInfo holds content of type " + contentInfo.getContentType().getName());
        EncryptedData encryptedData = (EncryptedData)contentInfo.getContent();
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)encryptedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        try {
            encryptedData.setupCipher(cArray);
            return encryptedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("Invalid Parameters: " + invalidAlgorithmParameterException.toString());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("Invalid Parameters: " + invalidParameterSpecException.toString());
        }
    }

    public byte[] getDigestedDataStream(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DigestedDataStream digestedDataStream = null;
        ContentInfoStream contentInfoStream = new ContentInfoStream((InputStream)byteArrayInputStream);
        digestedDataStream = byArray2 == null ? (DigestedDataStream)contentInfoStream.getContent() : new DigestedDataStream((InputStream)new ByteArrayInputStream(byArray2), AlgorithmID.sha1);
        InputStream inputStream = digestedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray2 != null) {
            digestedDataStream.decode(contentInfoStream.getContentInputStream());
        }
        if (digestedDataStream.verify()) {
            System.out.println("Hash ok!");
        } else {
            System.out.println("Hash verification failed!");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getDigestedData(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfo contentInfo = new ContentInfo((InputStream)byteArrayInputStream);
        System.out.println("This ContentInfo holds content of type " + contentInfo.getContentType().getName());
        DigestedData digestedData = null;
        if (byArray2 == null) {
            digestedData = (DigestedData)contentInfo.getContent();
        } else {
            try {
                digestedData = new DigestedData(byArray2, AlgorithmID.sha);
                digestedData.decode(contentInfo.getContentInputStream());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException(noSuchAlgorithmException.toString());
            }
        }
        if (digestedData.verify()) {
            System.out.println("Hash ok!");
        } else {
            System.out.println("Hash verification failed!");
        }
        return digestedData.getContent();
    }

    public byte[] getDataStream(byte[] byArray) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfoStream contentInfoStream = new ContentInfoStream((InputStream)byteArrayInputStream);
        System.out.println("This ContentInfo holds content of type " + contentInfoStream.getContentType().getName());
        DataStream dataStream = (DataStream)contentInfoStream.getContent();
        InputStream inputStream = dataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getData(byte[] byArray) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfo contentInfo = new ContentInfo((InputStream)byteArrayInputStream);
        System.out.println("This ContentInfo holds content of type " + contentInfo.getContentType().getName());
        Data data = (Data)contentInfo.getContent();
        return data.getData();
    }

    public byte[] getAuthenticatedDataStream(byte[] byArray, byte[] byArray2, PrivateKey privateKey, int n) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfoStream contentInfoStream = new ContentInfoStream((InputStream)byteArrayInputStream);
        System.out.println("This ContentInfo holds content of type " + contentInfoStream.getContentType().getName());
        AuthenticatedDataStream authenticatedDataStream = (AuthenticatedDataStream)contentInfoStream.getContent();
        if (authenticatedDataStream.getMode() == 2) {
            authenticatedDataStream.setInputStream((InputStream)new ByteArrayInputStream(byArray2));
        }
        System.out.println("\nThis message can be verified by the following recipients:");
        RecipientInfo[] recipientInfoArray = authenticatedDataStream.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        try {
            authenticatedDataStream.setupMac((Key)privateKey, n);
            InputStream inputStream = authenticatedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            if (!authenticatedDataStream.verifyMac()) {
                throw new CMSException("Mac verification error!");
            }
            System.out.println("Mac successfully verified!");
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
    }

    public byte[] getAuthenticatedData(byte[] byArray, byte[] byArray2, PrivateKey privateKey, int n) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfo contentInfo = new ContentInfo((InputStream)byteArrayInputStream);
        System.out.println("This ContentInfo holds content of type " + contentInfo.getContentType().getName());
        AuthenticatedData authenticatedData = (AuthenticatedData)contentInfo.getContent();
        if (authenticatedData.getMode() == 2) {
            authenticatedData.setContent(byArray2);
        }
        System.out.println("\nThis message can be verified by the following recipients:");
        RecipientInfo[] recipientInfoArray = authenticatedData.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        try {
            authenticatedData.setupMac((Key)privateKey, n);
            if (!authenticatedData.verifyMac()) {
                throw new CMSException("Mac verification error!");
            }
            System.out.println("Mac successfully verified!");
            return authenticatedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
    }

    public byte[] createSignedDataStream(byte[] byArray, int n) throws IOException, CMSException {
        Object object;
        Object object2;
        System.out.println("Create a new message signed by user 1:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream, n);
        signedDataStream.setCertificates((Certificate[])this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1_sign);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, this.user1_sign_pk);
        Attribute[] attributeArray = new Attribute[2];
        try {
            object2 = new CMSContentType(ObjectID.cms_data);
            attributeArray[0] = new Attribute((AttributeValue)object2);
            object = new SigningTime();
            attributeArray[1] = new Attribute((AttributeValue)object);
        }
        catch (Exception exception) {
            throw new CMSException("Error creating attribute: " + exception.toString());
        }
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedDataStream.addSignerInfo(signerInfo);
            signerInfo = new SignerInfo((CertificateIdentifier)new IssuerAndSerialNumber(this.user2_sign), AlgorithmID.md5, this.user2_sign_pk);
            signedDataStream.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        signedDataStream.setBlockSize(2048);
        if (n == 2) {
            int n2;
            object2 = signedDataStream.getInputStream();
            object = new byte[1024];
            while ((n2 = ((InputStream)object2).read((byte[])object)) > 0) {
            }
        }
        object2 = new ContentInfoStream((ContentStream)signedDataStream);
        object = new ByteArrayOutputStream();
        object2.writeTo((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public byte[] createSignedData(byte[] byArray, int n) throws CMSException {
        CMSContentType cMSContentType;
        System.out.println("Create a new message signed by user 1:");
        SignedData signedData = new SignedData(byArray, n);
        signedData.setCertificates((Certificate[])this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1_sign);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, this.user1_sign_pk);
        Attribute[] attributeArray = new Attribute[2];
        try {
            cMSContentType = new CMSContentType(ObjectID.cms_data);
            attributeArray[0] = new Attribute((AttributeValue)cMSContentType);
            SigningTime signingTime = new SigningTime();
            attributeArray[1] = new Attribute((AttributeValue)signingTime);
        }
        catch (Exception exception) {
            throw new CMSException("Error creating attribute: " + exception.toString());
        }
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedData.addSignerInfo(signerInfo);
            signerInfo = new SignerInfo((CertificateIdentifier)new IssuerAndSerialNumber(this.user2_sign), AlgorithmID.md5, this.user2_sign_pk);
            signedData.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        cMSContentType = new ContentInfo((Content)signedData);
        return cMSContentType.toByteArray();
    }

    public byte[] createSignedAndEncryptedDataStream(byte[] byArray) throws IOException, CMSException {
        System.out.println("Create a new message signed by user1 encrypted for user2:");
        byte[] byArray2 = this.createSignedDataStream(byArray, 1);
        return this.createEnvelopedDataStream(byArray2);
    }

    public byte[] createSignedAndEncryptedData(byte[] byArray) throws CMSException {
        System.out.println("Create a new message signed by user1 encrypted for user2:");
        byte[] byArray2 = this.createSignedData(byArray, 1);
        return this.createEnvelopedData(byArray2);
    }

    public byte[] createEnvelopedDataStream(byte[] byArray) throws IOException, CMSException {
        EnvelopedDataStream envelopedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[]{new KeyTransRecipientInfo(this.user1_crypt, AlgorithmID.rsaEncryption), new KeyTransRecipientInfo(this.user2_crypt, AlgorithmID.rsaEncryption)};
        envelopedDataStream.setRecipientInfos(recipientInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        envelopedDataStream.setBlockSize(2048);
        ContentInfoStream contentInfoStream = new ContentInfoStream((ContentStream)envelopedDataStream);
        contentInfoStream.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createEnvelopedData(byte[] byArray) throws CMSException {
        EnvelopedData envelopedData;
        try {
            envelopedData = new EnvelopedData(byArray, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[]{new KeyTransRecipientInfo(this.user1_crypt, AlgorithmID.rsaEncryption), new KeyTransRecipientInfo(this.user2_crypt, AlgorithmID.rsaEncryption)};
        envelopedData.setRecipientInfos(recipientInfoArray);
        ContentInfo contentInfo = new ContentInfo((Content)envelopedData);
        return contentInfo.toByteArray();
    }

    public byte[] createEncryptedDataStream(byte[] byArray, AlgorithmID algorithmID, char[] cArray) throws IOException, CMSException {
        EncryptedDataStream encryptedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            encryptedDataStream = new EncryptedDataStream((InputStream)byteArrayInputStream, 2048);
            encryptedDataStream.setupCipher(algorithmID, cArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.toString());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ContentInfoStream contentInfoStream = new ContentInfoStream((ContentStream)encryptedDataStream);
        contentInfoStream.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createEncryptedData(byte[] byArray, AlgorithmID algorithmID, char[] cArray) throws CMSException {
        EncryptedData encryptedData;
        try {
            encryptedData = new EncryptedData(byArray);
            encryptedData.setupCipher(algorithmID, cArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
        ContentInfo contentInfo = new ContentInfo((Content)encryptedData);
        return contentInfo.toByteArray();
    }

    public byte[] createDigestedDataStream(byte[] byArray, int n) throws IOException, CMSException {
        Object object;
        Closeable closeable;
        System.out.println("Create a new message to be digested:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DigestedDataStream digestedDataStream = null;
        digestedDataStream = new DigestedDataStream((InputStream)byteArrayInputStream, AlgorithmID.sha1, n);
        digestedDataStream.setBlockSize(2048);
        if (n == 2) {
            int n2;
            closeable = digestedDataStream.getInputStream();
            object = new byte[1024];
            while ((n2 = ((InputStream)closeable).read((byte[])object)) > 0) {
            }
        }
        closeable = new ByteArrayOutputStream();
        object = new ContentInfoStream((ContentStream)digestedDataStream);
        object.writeTo((OutputStream)closeable);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public byte[] createDigestedData(byte[] byArray, int n) throws CMSException {
        System.out.println("Create a new digested message:");
        DigestedData digestedData = new DigestedData(byArray, AlgorithmID.sha, n);
        ContentInfo contentInfo = new ContentInfo((Content)digestedData);
        return contentInfo.toByteArray();
    }

    public byte[] createDataStream(byte[] byArray) throws IOException, CMSException {
        System.out.println("Create a new Data message:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataStream dataStream = new DataStream((InputStream)byteArrayInputStream, 2048);
        ContentInfoStream contentInfoStream = new ContentInfoStream((ContentStream)dataStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        contentInfoStream.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createData(byte[] byArray) throws CMSException {
        System.out.println("Create a new Data message:");
        Data data = new Data(byArray);
        ContentInfo contentInfo = new ContentInfo((Content)data);
        return contentInfo.toByteArray();
    }

    public byte[] createAuthenticatedDataStream(byte[] byArray, boolean bl, int n) throws IOException, CMSException {
        Object object;
        Attribute[] attributeArray;
        AuthenticatedDataStream authenticatedDataStream;
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.hMAC_SHA1.clone();
        int n2 = 64;
        AlgorithmID algorithmID2 = null;
        if (bl) {
            algorithmID2 = (AlgorithmID)AlgorithmID.sha1.clone();
        }
        ObjectID objectID = ObjectID.cms_data;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            authenticatedDataStream = new AuthenticatedDataStream(objectID, (InputStream)byteArrayInputStream, algorithmID, n2, null, algorithmID2, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[]{new KeyTransRecipientInfo(this.user1_crypt, AlgorithmID.rsaEncryption), new KeyTransRecipientInfo(this.user2_crypt, AlgorithmID.rsaEncryption)};
        authenticatedDataStream.setRecipientInfos(recipientInfoArray);
        if (bl) {
            try {
                attributeArray = new Attribute[]{new Attribute((AttributeValue)new CMSContentType(objectID))};
                authenticatedDataStream.setAuthenticatedAttributes(attributeArray);
            }
            catch (Exception exception) {
                throw new CMSException("Error creating attribute: " + exception.toString());
            }
        }
        if (n == 2) {
            int n3;
            attributeArray = authenticatedDataStream.getInputStream();
            object = new byte[1024];
            while ((n3 = attributeArray.read((byte[])object)) > 0) {
            }
        }
        attributeArray = new ContentInfoStream((ContentStream)authenticatedDataStream);
        object = new ByteArrayOutputStream();
        attributeArray.writeTo((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public byte[] createAuthenticatedData(byte[] byArray, boolean bl, int n) throws IOException, CMSException {
        Attribute[] attributeArray;
        AuthenticatedData authenticatedData;
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.hMAC_SHA1.clone();
        int n2 = 64;
        AlgorithmID algorithmID2 = null;
        if (bl) {
            algorithmID2 = (AlgorithmID)AlgorithmID.sha1.clone();
        }
        ObjectID objectID = ObjectID.cms_data;
        try {
            authenticatedData = new AuthenticatedData(objectID, byArray, algorithmID, n2, null, algorithmID2, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[]{new KeyTransRecipientInfo(this.user1_crypt, AlgorithmID.rsaEncryption), new KeyTransRecipientInfo(this.user2_crypt, AlgorithmID.rsaEncryption)};
        authenticatedData.setRecipientInfos(recipientInfoArray);
        if (bl) {
            try {
                attributeArray = new Attribute[]{new Attribute((AttributeValue)new CMSContentType(objectID))};
                authenticatedData.setAuthenticatedAttributes(attributeArray);
            }
            catch (Exception exception) {
                throw new CMSException("Error creating attribute: " + exception.toString());
            }
        }
        attributeArray = new ContentInfo((Content)authenticatedData);
        return attributeArray.toByteArray();
    }

    public TestContentInfo() throws IOException {
        System.out.println();
        System.out.println("***************************************************************************************");
        System.out.println("*                               TestContentInfo demo                                  *");
        System.out.println("*        (shows the usage of the several CMS content type implementations)            *");
        System.out.println("***************************************************************************************");
        System.out.println();
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, 1);
        this.user1_sign = x509CertificateArray[0];
        this.user1_sign_pk = CMSKeyStore.getPrivateKey(0, 1);
        this.user2_sign = CMSKeyStore.getCertificateChain(0, 2)[0];
        this.user2_sign_pk = CMSKeyStore.getPrivateKey(0, 2);
        this.certificates = new X509Certificate[x509CertificateArray.length + 1];
        System.arraycopy(x509CertificateArray, 0, this.certificates, 0, x509CertificateArray.length);
        this.certificates[x509CertificateArray.length] = this.user2_sign;
        this.user1_crypt = CMSKeyStore.getCertificateChain(0, 4)[0];
        this.user1_crypt_pk = CMSKeyStore.getPrivateKey(0, 4);
        this.user2_crypt = CMSKeyStore.getCertificateChain(0, 6)[0];
        this.user2_crypt_pk = CMSKeyStore.getPrivateKey(0, 6);
        this.random = SecRandom.getDefault();
    }
}

