/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.DynamicMBean2;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.PerInterface;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import sun.reflect.misc.ReflectUtil;

public abstract class MBeanSupport<M>
implements DynamicMBean2,
MBeanRegistration {
    private final MBeanInfo mbeanInfo;
    private final Object resource;
    private final PerInterface<M> perInterface;

    <T> MBeanSupport(T t, Class<T> clazz) throws NotCompliantMBeanException {
        if (clazz == null) {
            throw new NotCompliantMBeanException("Null MBean interface");
        }
        if (!clazz.isInstance(t)) {
            String string = "Resource class " + t.getClass().getName() + " is not an instance of " + clazz.getName();
            throw new NotCompliantMBeanException(string);
        }
        ReflectUtil.checkPackageAccess(clazz);
        this.resource = t;
        MBeanIntrospector<M> mBeanIntrospector = this.getMBeanIntrospector();
        this.perInterface = mBeanIntrospector.getPerInterface(clazz);
        this.mbeanInfo = mBeanIntrospector.getMBeanInfo(t, this.perInterface);
    }

    abstract MBeanIntrospector<M> getMBeanIntrospector();

    abstract Object getCookie();

    public final boolean isMXBean() {
        return this.perInterface.isMXBean();
    }

    public abstract void register(MBeanServer var1, ObjectName var2) throws Exception;

    public abstract void unregister();

    @Override
    public final ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            objectName = ((MBeanRegistration)this.resource).preRegister(mBeanServer, objectName);
        }
        return objectName;
    }

    @Override
    public final void preRegister2(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.register(mBeanServer, objectName);
    }

    @Override
    public final void registerFailed() {
        this.unregister();
    }

    @Override
    public final void postRegister(Boolean bl) {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postRegister(bl);
        }
    }

    @Override
    public final void preDeregister() throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).preDeregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void postDeregister() {
        try {
            this.unregister();
        }
        finally {
            if (this.resource instanceof MBeanRegistration) {
                ((MBeanRegistration)this.resource).postDeregister();
            }
        }
    }

    @Override
    public final Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.perInterface.getAttribute(this.resource, string, this.getCookie());
    }

    @Override
    public final AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList(stringArray.length);
        for (String string : stringArray) {
            try {
                Object object = this.getAttribute(string);
                attributeList.add(new Attribute(string, object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attributeList;
    }

    @Override
    public final void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String string = attribute.getName();
        Object object = attribute.getValue();
        this.perInterface.setAttribute(this.resource, string, object, this.getCookie());
    }

    @Override
    public final AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList(attributeList.size());
        for (Object e : attributeList) {
            Attribute attribute = (Attribute)e;
            try {
                this.setAttribute(attribute);
                attributeList2.add(new Attribute(attribute.getName(), attribute.getValue()));
            }
            catch (Exception exception) {}
        }
        return attributeList2;
    }

    @Override
    public final Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        return this.perInterface.invoke(this.resource, string, objectArray, stringArray, this.getCookie());
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public final String getClassName() {
        return this.resource.getClass().getName();
    }

    @Override
    public final Object getResource() {
        return this.resource;
    }

    public final Class<?> getMBeanInterface() {
        return this.perInterface.getMBeanInterface();
    }
}

