/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelConnectionBlock;
import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelIdentifier;
import com.sun.media.sound.ModelOscillator;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ModelSource;
import com.sun.media.sound.ModelStandardTransform;
import com.sun.media.sound.ModelTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SoftPerformer {
    static ModelConnectionBlock[] defaultconnections = new ModelConnectionBlock[42];
    public int keyFrom = 0;
    public int keyTo = 127;
    public int velFrom = 0;
    public int velTo = 127;
    public int exclusiveClass = 0;
    public boolean selfNonExclusive = false;
    public boolean forcedVelocity = false;
    public boolean forcedKeynumber = false;
    public ModelPerformer performer;
    public ModelConnectionBlock[] connections;
    public ModelOscillator[] oscillators;
    public Map<Integer, int[]> midi_rpn_connections = new HashMap<Integer, int[]>();
    public Map<Integer, int[]> midi_nrpn_connections = new HashMap<Integer, int[]>();
    public int[][] midi_ctrl_connections;
    public int[][] midi_connections;
    public int[] ctrl_connections;
    private List<Integer> ctrl_connections_list = new ArrayList<Integer>();
    private static KeySortComparator keySortComparator;

    private String extractKeys(ModelConnectionBlock modelConnectionBlock) {
        StringBuffer stringBuffer = new StringBuffer();
        if (modelConnectionBlock.getSources() != null) {
            int n;
            stringBuffer.append("[");
            ModelSource[] modelSourceArray = modelConnectionBlock.getSources();
            ModelSource[] modelSourceArray2 = new ModelSource[modelSourceArray.length];
            for (n = 0; n < modelSourceArray.length; ++n) {
                modelSourceArray2[n] = modelSourceArray[n];
            }
            Arrays.sort(modelSourceArray2, keySortComparator);
            for (n = 0; n < modelSourceArray.length; ++n) {
                stringBuffer.append(modelSourceArray[n].getIdentifier());
                stringBuffer.append(";");
            }
            stringBuffer.append("]");
        }
        stringBuffer.append(";");
        if (modelConnectionBlock.getDestination() != null) {
            stringBuffer.append(modelConnectionBlock.getDestination().getIdentifier());
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private void processSource(ModelSource modelSource, int n) {
        ModelIdentifier modelIdentifier = modelSource.getIdentifier();
        String string = modelIdentifier.getObject();
        if (string.equals("midi_cc")) {
            this.processMidiControlSource(modelSource, n);
        } else if (string.equals("midi_rpn")) {
            this.processMidiRpnSource(modelSource, n);
        } else if (string.equals("midi_nrpn")) {
            this.processMidiNrpnSource(modelSource, n);
        } else if (string.equals("midi")) {
            this.processMidiSource(modelSource, n);
        } else if (string.equals("noteon")) {
            this.processNoteOnSource(modelSource, n);
        } else {
            if (string.equals("osc")) {
                return;
            }
            if (string.equals("mixer")) {
                return;
            }
            this.ctrl_connections_list.add(n);
        }
    }

    private void processMidiControlSource(ModelSource modelSource, int n) {
        String string = modelSource.getIdentifier().getVariable();
        if (string == null) {
            return;
        }
        int n2 = Integer.parseInt(string);
        if (this.midi_ctrl_connections[n2] == null) {
            this.midi_ctrl_connections[n2] = new int[]{n};
        } else {
            int[] nArray = this.midi_ctrl_connections[n2];
            int[] nArray2 = new int[nArray.length + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray2[nArray2.length - 1] = n;
            this.midi_ctrl_connections[n2] = nArray2;
        }
    }

    private void processNoteOnSource(ModelSource modelSource, int n) {
        String string = modelSource.getIdentifier().getVariable();
        int n2 = -1;
        if (string.equals("on")) {
            n2 = 3;
        }
        if (string.equals("keynumber")) {
            n2 = 4;
        }
        if (n2 == -1) {
            return;
        }
        if (this.midi_connections[n2] == null) {
            this.midi_connections[n2] = new int[]{n};
        } else {
            int[] nArray = this.midi_connections[n2];
            int[] nArray2 = new int[nArray.length + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray2[nArray2.length - 1] = n;
            this.midi_connections[n2] = nArray2;
        }
    }

    private void processMidiSource(ModelSource modelSource, int n) {
        String string = modelSource.getIdentifier().getVariable();
        int n2 = -1;
        if (string.equals("pitch")) {
            n2 = 0;
        }
        if (string.equals("channel_pressure")) {
            n2 = 1;
        }
        if (string.equals("poly_pressure")) {
            n2 = 2;
        }
        if (n2 == -1) {
            return;
        }
        if (this.midi_connections[n2] == null) {
            this.midi_connections[n2] = new int[]{n};
        } else {
            int[] nArray = this.midi_connections[n2];
            int[] nArray2 = new int[nArray.length + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray2[nArray2.length - 1] = n;
            this.midi_connections[n2] = nArray2;
        }
    }

    private void processMidiRpnSource(ModelSource modelSource, int n) {
        String string = modelSource.getIdentifier().getVariable();
        if (string == null) {
            return;
        }
        int n2 = Integer.parseInt(string);
        if (this.midi_rpn_connections.get(n2) == null) {
            this.midi_rpn_connections.put(n2, new int[]{n});
        } else {
            int[] nArray = this.midi_rpn_connections.get(n2);
            int[] nArray2 = new int[nArray.length + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray2[nArray2.length - 1] = n;
            this.midi_rpn_connections.put(n2, nArray2);
        }
    }

    private void processMidiNrpnSource(ModelSource modelSource, int n) {
        String string = modelSource.getIdentifier().getVariable();
        if (string == null) {
            return;
        }
        int n2 = Integer.parseInt(string);
        if (this.midi_nrpn_connections.get(n2) == null) {
            this.midi_nrpn_connections.put(n2, new int[]{n});
        } else {
            int[] nArray = this.midi_nrpn_connections.get(n2);
            int[] nArray2 = new int[nArray.length + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray2[nArray2.length - 1] = n;
            this.midi_nrpn_connections.put(n2, nArray2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SoftPerformer(ModelPerformer modelPerformer) {
        Object object;
        int n;
        Object object2;
        int n2;
        this.performer = modelPerformer;
        this.keyFrom = modelPerformer.getKeyFrom();
        this.keyTo = modelPerformer.getKeyTo();
        this.velFrom = modelPerformer.getVelFrom();
        this.velTo = modelPerformer.getVelTo();
        this.exclusiveClass = modelPerformer.getExclusiveClass();
        this.selfNonExclusive = modelPerformer.isSelfNonExclusive();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<ModelConnectionBlock> arrayList = new ArrayList<ModelConnectionBlock>();
        arrayList.addAll(modelPerformer.getConnectionBlocks());
        if (modelPerformer.isDefaultConnectionsEnabled()) {
            boolean bl = false;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                ModelConnectionBlock modelConnectionBlock = (ModelConnectionBlock)arrayList.get(n2);
                object2 = modelConnectionBlock.getSources();
                ModelDestination modelDestination = modelConnectionBlock.getDestination();
                boolean bl2 = false;
                if (modelDestination != null && object2 != null && ((ModelSource[])object2).length > 1) {
                    for (int i = 0; i < ((ModelSource[])object2).length; ++i) {
                        if (!((ModelSource)object2[i]).getIdentifier().getObject().equals("midi_cc") || !((ModelSource)object2[i]).getIdentifier().getVariable().equals("1")) continue;
                        bl2 = true;
                        bl = true;
                        break;
                    }
                }
                if (!bl2) continue;
                ModelConnectionBlock modelConnectionBlock2 = new ModelConnectionBlock();
                modelConnectionBlock2.setSources(modelConnectionBlock.getSources());
                modelConnectionBlock2.setDestination(modelConnectionBlock.getDestination());
                modelConnectionBlock2.addSource(new ModelSource(new ModelIdentifier("midi_rpn", "5")));
                modelConnectionBlock2.setScale(modelConnectionBlock.getScale() * 256.0);
                arrayList.set(n2, modelConnectionBlock2);
            }
            if (!bl) {
                ModelConnectionBlock modelConnectionBlock = new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO1, false, true, 0), new ModelSource(new ModelIdentifier("midi_cc", "1", 0), false, false, 0), 50.0, new ModelDestination(ModelDestination.DESTINATION_PITCH));
                modelConnectionBlock.addSource(new ModelSource(new ModelIdentifier("midi_rpn", "5")));
                modelConnectionBlock.setScale(modelConnectionBlock.getScale() * 256.0);
                arrayList.add(modelConnectionBlock);
            }
            n2 = 0;
            n = 0;
            object2 = null;
            int n3 = 0;
            for (ModelConnectionBlock modelConnectionBlock : arrayList) {
                ModelSource[] object32 = modelConnectionBlock.getSources();
                ModelDestination modelDestination = modelConnectionBlock.getDestination();
                if (modelDestination == null || object32 == null) continue;
                for (int i = 0; i < object32.length; ++i) {
                    ModelIdentifier modelIdentifier = object32[i].getIdentifier();
                    if (modelIdentifier.getObject().equals("midi_cc") && modelIdentifier.getVariable().equals("1")) {
                        object2 = modelConnectionBlock;
                        n3 = i;
                    }
                    if (!modelIdentifier.getObject().equals("midi")) continue;
                    if (modelIdentifier.getVariable().equals("channel_pressure")) {
                        n2 = 1;
                    }
                    if (!modelIdentifier.getVariable().equals("poly_pressure")) continue;
                    n = 1;
                }
            }
            if (object2 != null) {
                if (n2 == 0) {
                    object = new ModelConnectionBlock();
                    ((ModelConnectionBlock)object).setDestination(((ModelConnectionBlock)object2).getDestination());
                    ((ModelConnectionBlock)object).setScale(((ModelConnectionBlock)object2).getScale());
                    ModelSource[] modelSourceArray = ((ModelConnectionBlock)object2).getSources();
                    ModelSource[] modelSourceArray2 = new ModelSource[modelSourceArray.length];
                    for (int i = 0; i < modelSourceArray2.length; ++i) {
                        modelSourceArray2[i] = modelSourceArray[i];
                    }
                    modelSourceArray2[n3] = new ModelSource(new ModelIdentifier("midi", "channel_pressure"));
                    ((ModelConnectionBlock)object).setSources(modelSourceArray2);
                    hashMap.put(this.extractKeys((ModelConnectionBlock)object), object);
                }
                if (n == 0) {
                    object = new ModelConnectionBlock();
                    ((ModelConnectionBlock)object).setDestination(((ModelConnectionBlock)object2).getDestination());
                    ((ModelConnectionBlock)object).setScale(((ModelConnectionBlock)object2).getScale());
                    ModelSource[] modelSourceArray = ((ModelConnectionBlock)object2).getSources();
                    ModelSource[] modelSourceArray3 = new ModelSource[modelSourceArray.length];
                    for (int i = 0; i < modelSourceArray3.length; ++i) {
                        modelSourceArray3[i] = modelSourceArray[i];
                    }
                    modelSourceArray3[n3] = new ModelSource(new ModelIdentifier("midi", "poly_pressure"));
                    ((ModelConnectionBlock)object).setSources(modelSourceArray3);
                    hashMap.put(this.extractKeys((ModelConnectionBlock)object), object);
                }
            }
            object = null;
            for (ModelConnectionBlock modelConnectionBlock : arrayList) {
                ModelSource[] modelSourceArray = modelConnectionBlock.getSources();
                if (modelSourceArray.length == 0 || !modelSourceArray[0].getIdentifier().getObject().equals("lfo") || !modelConnectionBlock.getDestination().getIdentifier().equals(ModelDestination.DESTINATION_PITCH)) continue;
                if (object == null) {
                    object = modelConnectionBlock;
                    continue;
                }
                if (((ModelConnectionBlock)object).getSources().length > modelSourceArray.length) {
                    object = modelConnectionBlock;
                    continue;
                }
                if (((ModelConnectionBlock)object).getSources()[0].getIdentifier().getInstance() >= 1 || ((ModelConnectionBlock)object).getSources()[0].getIdentifier().getInstance() <= modelSourceArray[0].getIdentifier().getInstance()) continue;
                object = modelConnectionBlock;
            }
            int n4 = 1;
            if (object != null) {
                n4 = ((ModelConnectionBlock)object).getSources()[0].getIdentifier().getInstance();
            }
            ModelConnectionBlock modelConnectionBlock = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "78"), false, true, 0), 2000.0, new ModelDestination(new ModelIdentifier("lfo", "delay2", n4)));
            hashMap.put(this.extractKeys(modelConnectionBlock), modelConnectionBlock);
            final double d = object == null ? 0.0 : ((ModelConnectionBlock)object).getScale();
            ModelConnectionBlock modelConnectionBlock2 = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("lfo", n4)), new ModelSource(new ModelIdentifier("midi_cc", "77"), new ModelTransform(){
                double s;
                {
                    this.s = d;
                }

                @Override
                public double transform(double d2) {
                    d2 = d2 * 2.0 - 1.0;
                    d2 *= 600.0;
                    if (this.s == 0.0) {
                        return d2;
                    }
                    if (this.s > 0.0) {
                        if (d2 < -this.s) {
                            d2 = -this.s;
                        }
                        return d2;
                    }
                    if (d2 < this.s) {
                        d2 = -this.s;
                    }
                    return -d2;
                }
            }), new ModelDestination(ModelDestination.DESTINATION_PITCH));
            hashMap.put(this.extractKeys(modelConnectionBlock2), modelConnectionBlock2);
            ModelConnectionBlock modelConnectionBlock3 = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "76"), false, true, 0), 2400.0, new ModelDestination(new ModelIdentifier("lfo", "freq", n4)));
            hashMap.put(this.extractKeys(modelConnectionBlock3), modelConnectionBlock3);
        }
        if (modelPerformer.isDefaultConnectionsEnabled()) {
            ModelConnectionBlock[] modelConnectionBlockArray = defaultconnections;
            n2 = modelConnectionBlockArray.length;
            for (n = 0; n < n2; ++n) {
                object2 = modelConnectionBlockArray[n];
                hashMap.put(this.extractKeys((ModelConnectionBlock)object2), object2);
            }
        }
        for (ModelConnectionBlock modelConnectionBlock : arrayList) {
            hashMap.put(this.extractKeys(modelConnectionBlock), modelConnectionBlock);
        }
        ArrayList arrayList2 = new ArrayList();
        this.midi_ctrl_connections = new int[128][];
        for (n2 = 0; n2 < this.midi_ctrl_connections.length; ++n2) {
            this.midi_ctrl_connections[n2] = null;
        }
        this.midi_connections = new int[5][];
        for (n2 = 0; n2 < this.midi_connections.length; ++n2) {
            this.midi_connections[n2] = null;
        }
        n2 = 0;
        n = 0;
        for (ModelConnectionBlock modelConnectionBlock : hashMap.values()) {
            ModelIdentifier modelIdentifier;
            if (modelConnectionBlock.getDestination() != null && (modelIdentifier = ((ModelDestination)(object = modelConnectionBlock.getDestination())).getIdentifier()).getObject().equals("noteon")) {
                n = 1;
                if (modelIdentifier.getVariable().equals("keynumber")) {
                    this.forcedKeynumber = true;
                }
                if (modelIdentifier.getVariable().equals("velocity")) {
                    this.forcedVelocity = true;
                }
            }
            if (n != 0) {
                arrayList2.add(0, modelConnectionBlock);
                n = 0;
                continue;
            }
            arrayList2.add(modelConnectionBlock);
        }
        object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            ModelConnectionBlock modelConnectionBlock = (ModelConnectionBlock)object2.next();
            if (modelConnectionBlock.getSources() != null) {
                object = modelConnectionBlock.getSources();
                for (int i = 0; i < ((ModelSource[])object).length; ++i) {
                    this.processSource(object[i], n2);
                }
            }
            ++n2;
        }
        this.connections = new ModelConnectionBlock[arrayList2.size()];
        arrayList2.toArray(this.connections);
        this.ctrl_connections = new int[this.ctrl_connections_list.size()];
        for (int i = 0; i < this.ctrl_connections.length; ++i) {
            this.ctrl_connections[i] = this.ctrl_connections_list.get(i);
        }
        this.oscillators = new ModelOscillator[modelPerformer.getOscillators().size()];
        modelPerformer.getOscillators().toArray(this.oscillators);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            void var11_43;
            ModelConnectionBlock modelConnectionBlock = (ModelConnectionBlock)iterator.next();
            if (modelConnectionBlock.getDestination() != null && SoftPerformer.isUnnecessaryTransform(modelConnectionBlock.getDestination().getTransform())) {
                modelConnectionBlock.getDestination().setTransform(null);
            }
            if (modelConnectionBlock.getSources() == null) continue;
            object = modelConnectionBlock.getSources();
            int n3 = ((Object)object).length;
            boolean bl = false;
            while (var11_43 < n3) {
                Object object3 = object[var11_43];
                if (SoftPerformer.isUnnecessaryTransform(((ModelSource)object3).getTransform())) {
                    ((ModelSource)object3).setTransform(null);
                }
                ++var11_43;
            }
        }
    }

    private static boolean isUnnecessaryTransform(ModelTransform modelTransform) {
        if (modelTransform == null) {
            return false;
        }
        if (!(modelTransform instanceof ModelStandardTransform)) {
            return false;
        }
        ModelStandardTransform modelStandardTransform = (ModelStandardTransform)modelTransform;
        if (modelStandardTransform.getDirection()) {
            return false;
        }
        if (modelStandardTransform.getPolarity()) {
            return false;
        }
        if (modelStandardTransform.getTransform() != 0) {
            return false;
        }
        return false;
    }

    static {
        int n = 0;
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("noteon", "on", 0), false, false, 0), 1.0, new ModelDestination(new ModelIdentifier("eg", "on", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("noteon", "on", 0), false, false, 0), 1.0, new ModelDestination(new ModelIdentifier("eg", "on", 1)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("eg", "active", 0), false, false, 0), 1.0, new ModelDestination(new ModelIdentifier("mixer", "active", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("eg", 0), true, false, 0), -960.0, new ModelDestination(new ModelIdentifier("mixer", "gain")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("noteon", "velocity"), true, false, 1), -960.0, new ModelDestination(new ModelIdentifier("mixer", "gain")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi", "pitch"), false, true, 0), new ModelSource(new ModelIdentifier("midi_rpn", "0"), new ModelTransform(){

            @Override
            public double transform(double d) {
                int n = (int)(d * 16384.0);
                int n2 = n >> 7;
                int n3 = n & 0x7F;
                return n2 * 100 + n3;
            }
        }), new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("noteon", "keynumber"), false, false, 0), 12800.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "7"), true, false, 1), -960.0, new ModelDestination(new ModelIdentifier("mixer", "gain")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "8"), false, false, 0), 1000.0, new ModelDestination(new ModelIdentifier("mixer", "balance")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "10"), false, false, 0), 1000.0, new ModelDestination(new ModelIdentifier("mixer", "pan")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "11"), true, false, 1), -960.0, new ModelDestination(new ModelIdentifier("mixer", "gain")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "91"), false, false, 0), 1000.0, new ModelDestination(new ModelIdentifier("mixer", "reverb")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "93"), false, false, 0), 1000.0, new ModelDestination(new ModelIdentifier("mixer", "chorus")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "71"), false, true, 0), 200.0, new ModelDestination(new ModelIdentifier("filter", "q")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "74"), false, true, 0), 9600.0, new ModelDestination(new ModelIdentifier("filter", "freq")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "72"), false, true, 0), 6000.0, new ModelDestination(new ModelIdentifier("eg", "release2")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "73"), false, true, 0), 2000.0, new ModelDestination(new ModelIdentifier("eg", "attack2")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "75"), false, true, 0), 6000.0, new ModelDestination(new ModelIdentifier("eg", "decay2")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "67"), false, false, 3), -50.0, new ModelDestination(ModelDestination.DESTINATION_GAIN));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_cc", "67"), false, false, 3), -2400.0, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_rpn", "1"), false, true, 0), 100.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("midi_rpn", "2"), false, true, 0), 12800.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("master", "fine_tuning"), false, true, 0), 100.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(new ModelSource(new ModelIdentifier("master", "coarse_tuning"), false, true, 0), 12800.0, new ModelDestination(new ModelIdentifier("osc", "pitch")));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(13500.0, new ModelDestination(new ModelIdentifier("filter", "freq", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "delay", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "attack", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "hold", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "decay", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(1000.0, new ModelDestination(new ModelIdentifier("eg", "sustain", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "release", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(1200.0 * Math.log(0.015) / Math.log(2.0), new ModelDestination(new ModelIdentifier("eg", "shutdown", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "delay", 1)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "attack", 1)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "hold", 1)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "decay", 1)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(1000.0, new ModelDestination(new ModelIdentifier("eg", "sustain", 1)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("eg", "release", 1)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(-8.51318, new ModelDestination(new ModelIdentifier("lfo", "freq", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("lfo", "delay", 0)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(-8.51318, new ModelDestination(new ModelIdentifier("lfo", "freq", 1)));
        SoftPerformer.defaultconnections[n++] = new ModelConnectionBlock(Double.NEGATIVE_INFINITY, new ModelDestination(new ModelIdentifier("lfo", "delay", 1)));
        keySortComparator = new KeySortComparator();
    }

    private static class KeySortComparator
    implements Comparator<ModelSource> {
        private KeySortComparator() {
        }

        @Override
        public int compare(ModelSource modelSource, ModelSource modelSource2) {
            return modelSource.getIdentifier().toString().compareTo(modelSource2.getIdentifier().toString());
        }
    }
}

