/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.packaging.mime.internet;

import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.hdr;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.LineInputStream;
import com.sun.xml.internal.messaging.saaj.util.FinalArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.List;
import java.util.NoSuchElementException;

public final class InternetHeaders {
    private final FinalArrayList headers = new FinalArrayList();
    private List headerValueView;

    public InternetHeaders() {
    }

    public InternetHeaders(InputStream inputStream) throws MessagingException {
        this.load(inputStream);
    }

    public void load(InputStream inputStream) throws MessagingException {
        LineInputStream lineInputStream = new LineInputStream(inputStream);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            do {
                if ((string2 = lineInputStream.readLine()) != null && (string2.startsWith(" ") || string2.startsWith("\t"))) {
                    if (string != null) {
                        stringBuffer.append(string);
                        string = null;
                    }
                    stringBuffer.append("\r\n");
                    stringBuffer.append(string2);
                    continue;
                }
                if (string != null) {
                    this.addHeaderLine(string);
                } else if (stringBuffer.length() > 0) {
                    this.addHeaderLine(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                string = string2;
            } while (string2 != null && string2.length() > 0);
        }
        catch (IOException iOException) {
            throw new MessagingException("Error in input stream", iOException);
        }
    }

    public String[] getHeader(String string) {
        FinalArrayList finalArrayList = new FinalArrayList();
        int n = this.headers.size();
        for (int i = 0; i < n; ++i) {
            hdr hdr2 = (hdr)this.headers.get(i);
            if (!string.equalsIgnoreCase(hdr2.name)) continue;
            finalArrayList.add(hdr2.getValue());
        }
        if (finalArrayList.size() == 0) {
            return null;
        }
        return finalArrayList.toArray(new String[finalArrayList.size()]);
    }

    public String getHeader(String string, String string2) {
        String[] stringArray = this.getHeader(string);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 1 || string2 == null) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(string2);
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public void setHeader(String string, String string2) {
        boolean bl = false;
        for (int i = 0; i < this.headers.size(); ++i) {
            hdr hdr2 = (hdr)this.headers.get(i);
            if (!string.equalsIgnoreCase(hdr2.name)) continue;
            if (!bl) {
                int n;
                hdr2.line = hdr2.line != null && (n = hdr2.line.indexOf(58)) >= 0 ? hdr2.line.substring(0, n + 1) + " " + string2 : string + ": " + string2;
                bl = true;
                continue;
            }
            this.headers.remove(i);
            --i;
        }
        if (!bl) {
            this.addHeader(string, string2);
        }
    }

    public void addHeader(String string, String string2) {
        int n = this.headers.size();
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            hdr hdr2 = (hdr)this.headers.get(i);
            if (string.equalsIgnoreCase(hdr2.name)) {
                this.headers.add(i + 1, new hdr(string, string2));
                return;
            }
            if (!hdr2.name.equals(":")) continue;
            n = i;
        }
        this.headers.add(n, new hdr(string, string2));
    }

    public void removeHeader(String string) {
        for (int i = 0; i < this.headers.size(); ++i) {
            hdr hdr2 = (hdr)this.headers.get(i);
            if (!string.equalsIgnoreCase(hdr2.name)) continue;
            this.headers.remove(i);
            --i;
        }
    }

    public FinalArrayList getAllHeaders() {
        return this.headers;
    }

    public void addHeaderLine(String string) {
        try {
            char c = string.charAt(0);
            if (c == ' ' || c == '\t') {
                hdr hdr2 = (hdr)this.headers.get(this.headers.size() - 1);
                hdr2.line = hdr2.line + "\r\n" + string;
            } else {
                this.headers.add(new hdr(string));
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public List getAllHeaderLines() {
        if (this.headerValueView == null) {
            this.headerValueView = new AbstractList(){

                @Override
                public Object get(int n) {
                    return ((hdr)((InternetHeaders)InternetHeaders.this).headers.get((int)n)).line;
                }

                @Override
                public int size() {
                    return InternetHeaders.this.headers.size();
                }
            };
        }
        return this.headerValueView;
    }
}

