/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.xml;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.internal.ws.encoding.ContentType;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.encoding.XMLHTTPBindingCodec;
import com.sun.xml.internal.ws.message.AbstractMessageImpl;
import com.sun.xml.internal.ws.message.EmptyMessageImpl;
import com.sun.xml.internal.ws.message.MimeAttachmentSet;
import com.sun.xml.internal.ws.message.source.PayloadSourceMessage;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class XMLMessage {
    private static final int PLAIN_XML_FLAG = 1;
    private static final int MIME_MULTIPART_FLAG = 2;
    private static final int FI_ENCODED_FLAG = 16;

    public static Message create(String string, InputStream inputStream, WSBinding wSBinding) {
        AbstractMessageImpl abstractMessageImpl;
        try {
            ContentType contentType;
            int n;
            inputStream = StreamUtils.hasSomeData(inputStream);
            if (inputStream == null) {
                return Messages.createEmpty(SOAPVersion.SOAP_11);
            }
            abstractMessageImpl = string != null ? (((n = XMLMessage.identifyContentType(contentType = new ContentType(string))) & 2) != 0 ? new XMLMultiPart(string, inputStream, wSBinding) : ((n & 1) != 0 ? new XmlContent(string, inputStream, wSBinding) : new UnknownContent(string, inputStream))) : new UnknownContent("application/octet-stream", inputStream);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        return abstractMessageImpl;
    }

    public static Message create(Source source) {
        return source == null ? Messages.createEmpty(SOAPVersion.SOAP_11) : Messages.createUsingPayload(source, SOAPVersion.SOAP_11);
    }

    public static Message create(DataSource dataSource, WSBinding wSBinding) {
        try {
            return dataSource == null ? Messages.createEmpty(SOAPVersion.SOAP_11) : XMLMessage.create(dataSource.getContentType(), dataSource.getInputStream(), wSBinding);
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    public static Message create(Exception exception) {
        return new FaultMessage(SOAPVersion.SOAP_11);
    }

    private static int getContentId(String string) {
        try {
            ContentType contentType = new ContentType(string);
            return XMLMessage.identifyContentType(contentType);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    public static boolean isFastInfoset(String string) {
        return (XMLMessage.getContentId(string) & 0x10) != 0;
    }

    public static int identifyContentType(ContentType contentType) {
        String string = contentType.getPrimaryType();
        String string2 = contentType.getSubType();
        if (string.equalsIgnoreCase("multipart") && string2.equalsIgnoreCase("related")) {
            String string3 = contentType.getParameter("type");
            if (string3 != null) {
                if (XMLMessage.isXMLType(string3)) {
                    return 3;
                }
                if (XMLMessage.isFastInfosetType(string3)) {
                    return 18;
                }
            }
            return 0;
        }
        if (XMLMessage.isXMLType(string, string2)) {
            return 1;
        }
        if (XMLMessage.isFastInfosetType(string, string2)) {
            return 16;
        }
        return 0;
    }

    protected static boolean isXMLType(@NotNull String string, @NotNull String string2) {
        return string.equalsIgnoreCase("text") && string2.equalsIgnoreCase("xml") || string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("xml") || string.equalsIgnoreCase("application") && string2.toLowerCase().endsWith("+xml");
    }

    protected static boolean isXMLType(String string) {
        String string2 = string.toLowerCase();
        return string2.startsWith("text/xml") || string2.startsWith("application/xml") || string2.startsWith("application/") && string2.indexOf("+xml") != -1;
    }

    protected static boolean isFastInfosetType(String string, String string2) {
        return string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("fastinfoset");
    }

    protected static boolean isFastInfosetType(String string) {
        return string.toLowerCase().startsWith("application/fastinfoset");
    }

    public static DataSource getDataSource(Message message, WSBinding wSBinding) {
        if (message == null) {
            return null;
        }
        if (message instanceof MessageDataSource) {
            return ((MessageDataSource)((Object)message)).getDataSource();
        }
        AttachmentSet attachmentSet = message.getAttachments();
        if (attachmentSet != null && !attachmentSet.isEmpty()) {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            try {
                XMLHTTPBindingCodec xMLHTTPBindingCodec = new XMLHTTPBindingCodec(wSBinding);
                com.sun.xml.internal.ws.api.pipe.ContentType contentType = xMLHTTPBindingCodec.getStaticContentType(new Packet(message));
                xMLHTTPBindingCodec.encode(new Packet(message), (OutputStream)byteArrayBuffer);
                return XMLMessage.createDataSource(contentType.getContentType(), byteArrayBuffer.newInputStream());
            }
            catch (IOException iOException) {
                throw new WebServiceException(iOException);
            }
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create(byteArrayBuffer);
        try {
            message.writePayloadTo(xMLStreamWriter);
            xMLStreamWriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
        return XMLMessage.createDataSource("text/xml", byteArrayBuffer.newInputStream());
    }

    public static DataSource createDataSource(String string, InputStream inputStream) {
        return new XmlDataSource(string, inputStream);
    }

    private static class FaultMessage
    extends EmptyMessageImpl {
        public FaultMessage(SOAPVersion sOAPVersion) {
            super(sOAPVersion);
        }

        @Override
        public boolean isFault() {
            return true;
        }
    }

    public static interface MessageDataSource {
        public boolean hasUnconsumedDataSource();

        public DataSource getDataSource();
    }

    public static class UnknownContent
    extends AbstractMessageImpl
    implements MessageDataSource {
        private final DataSource ds;
        private final HeaderList headerList;

        public UnknownContent(String string, InputStream inputStream) {
            this(XMLMessage.createDataSource(string, inputStream));
        }

        public UnknownContent(DataSource dataSource) {
            super(SOAPVersion.SOAP_11);
            this.ds = dataSource;
            this.headerList = new HeaderList();
        }

        private UnknownContent(UnknownContent unknownContent) {
            super(unknownContent.soapVersion);
            this.ds = unknownContent.ds;
            this.headerList = HeaderList.copy(unknownContent.headerList);
        }

        @Override
        public boolean hasUnconsumedDataSource() {
            return true;
        }

        @Override
        public DataSource getDataSource() {
            assert (this.ds != null);
            return this.ds;
        }

        @Override
        protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasHeaders() {
            return false;
        }

        @Override
        public boolean isFault() {
            return false;
        }

        @Override
        public HeaderList getHeaders() {
            return this.headerList;
        }

        @Override
        public String getPayloadLocalPart() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPayloadNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPayload() {
            return false;
        }

        @Override
        public Source readPayloadAsSource() {
            return null;
        }

        @Override
        public XMLStreamReader readPayload() throws XMLStreamException {
            throw new WebServiceException("There isn't XML payload. Shouldn't come here.");
        }

        @Override
        public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        }

        @Override
        public Message copy() {
            return new UnknownContent(this);
        }
    }

    public static final class XMLMultiPart
    extends AbstractMessageImpl
    implements MessageDataSource {
        private final DataSource dataSource;
        private final StreamingAttachmentFeature feature;
        private Message delegate;
        private final HeaderList headerList = new HeaderList();
        private final WSBinding binding;

        public XMLMultiPart(String string, InputStream inputStream, WSBinding wSBinding) {
            super(SOAPVersion.SOAP_11);
            this.dataSource = XMLMessage.createDataSource(string, inputStream);
            this.feature = wSBinding.getFeature(StreamingAttachmentFeature.class);
            this.binding = wSBinding;
        }

        private Message getMessage() {
            if (this.delegate == null) {
                MimeMultipartParser mimeMultipartParser;
                try {
                    mimeMultipartParser = new MimeMultipartParser(this.dataSource.getInputStream(), this.dataSource.getContentType(), this.feature);
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
                InputStream inputStream = mimeMultipartParser.getRootPart().asInputStream();
                assert (inputStream != null);
                this.delegate = new PayloadSourceMessage(this.headerList, new StreamSource(inputStream), (AttachmentSet)new MimeAttachmentSet(mimeMultipartParser), SOAPVersion.SOAP_11);
            }
            return this.delegate;
        }

        @Override
        public boolean hasUnconsumedDataSource() {
            return this.delegate == null;
        }

        @Override
        public DataSource getDataSource() {
            return this.hasUnconsumedDataSource() ? this.dataSource : XMLMessage.getDataSource(this.getMessage(), this.binding);
        }

        @Override
        public boolean hasHeaders() {
            return false;
        }

        @Override
        @NotNull
        public HeaderList getHeaders() {
            return this.headerList;
        }

        @Override
        public String getPayloadLocalPart() {
            return this.getMessage().getPayloadLocalPart();
        }

        @Override
        public String getPayloadNamespaceURI() {
            return this.getMessage().getPayloadNamespaceURI();
        }

        @Override
        public boolean hasPayload() {
            return true;
        }

        @Override
        public boolean isFault() {
            return false;
        }

        @Override
        public Source readEnvelopeAsSource() {
            return this.getMessage().readEnvelopeAsSource();
        }

        @Override
        public Source readPayloadAsSource() {
            return this.getMessage().readPayloadAsSource();
        }

        @Override
        public SOAPMessage readAsSOAPMessage() throws SOAPException {
            return this.getMessage().readAsSOAPMessage();
        }

        @Override
        public SOAPMessage readAsSOAPMessage(Packet packet, boolean bl) throws SOAPException {
            return this.getMessage().readAsSOAPMessage(packet, bl);
        }

        @Override
        public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
            return this.getMessage().readPayloadAsJAXB(unmarshaller);
        }

        @Override
        public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
            return this.getMessage().readPayloadAsJAXB(bridge);
        }

        @Override
        public XMLStreamReader readPayload() throws XMLStreamException {
            return this.getMessage().readPayload();
        }

        @Override
        public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
            this.getMessage().writePayloadTo(xMLStreamWriter);
        }

        @Override
        public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
            this.getMessage().writeTo(xMLStreamWriter);
        }

        @Override
        public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
            this.getMessage().writeTo(contentHandler, errorHandler);
        }

        @Override
        public Message copy() {
            return this.getMessage().copy();
        }

        @Override
        protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOneWay(@NotNull WSDLPort wSDLPort) {
            return false;
        }

        @Override
        @NotNull
        public AttachmentSet getAttachments() {
            return this.getMessage().getAttachments();
        }
    }

    private static class XmlContent
    extends AbstractMessageImpl
    implements MessageDataSource {
        private final XmlDataSource dataSource;
        private boolean consumed;
        private Message delegate;
        private final HeaderList headerList;
        private final WSBinding binding;

        public XmlContent(String string, InputStream inputStream, WSBinding wSBinding) {
            super(SOAPVersion.SOAP_11);
            this.dataSource = new XmlDataSource(string, inputStream);
            this.headerList = new HeaderList();
            this.binding = wSBinding;
        }

        private Message getMessage() {
            if (this.delegate == null) {
                InputStream inputStream = this.dataSource.getInputStream();
                assert (inputStream != null);
                this.delegate = Messages.createUsingPayload(new StreamSource(inputStream), SOAPVersion.SOAP_11);
                this.consumed = true;
            }
            return this.delegate;
        }

        @Override
        public boolean hasUnconsumedDataSource() {
            return !this.dataSource.consumed() && !this.consumed;
        }

        @Override
        public DataSource getDataSource() {
            return this.hasUnconsumedDataSource() ? this.dataSource : XMLMessage.getDataSource(this.getMessage(), this.binding);
        }

        @Override
        public boolean hasHeaders() {
            return false;
        }

        @Override
        @NotNull
        public HeaderList getHeaders() {
            return this.headerList;
        }

        @Override
        public String getPayloadLocalPart() {
            return this.getMessage().getPayloadLocalPart();
        }

        @Override
        public String getPayloadNamespaceURI() {
            return this.getMessage().getPayloadNamespaceURI();
        }

        @Override
        public boolean hasPayload() {
            return true;
        }

        @Override
        public boolean isFault() {
            return false;
        }

        @Override
        public Source readEnvelopeAsSource() {
            return this.getMessage().readEnvelopeAsSource();
        }

        @Override
        public Source readPayloadAsSource() {
            return this.getMessage().readPayloadAsSource();
        }

        @Override
        public SOAPMessage readAsSOAPMessage() throws SOAPException {
            return this.getMessage().readAsSOAPMessage();
        }

        @Override
        public SOAPMessage readAsSOAPMessage(Packet packet, boolean bl) throws SOAPException {
            return this.getMessage().readAsSOAPMessage(packet, bl);
        }

        @Override
        public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
            return this.getMessage().readPayloadAsJAXB(unmarshaller);
        }

        @Override
        public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
            return this.getMessage().readPayloadAsJAXB(bridge);
        }

        @Override
        public XMLStreamReader readPayload() throws XMLStreamException {
            return this.getMessage().readPayload();
        }

        @Override
        public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
            this.getMessage().writePayloadTo(xMLStreamWriter);
        }

        @Override
        public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
            this.getMessage().writeTo(xMLStreamWriter);
        }

        @Override
        public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
            this.getMessage().writeTo(contentHandler, errorHandler);
        }

        @Override
        public Message copy() {
            return this.getMessage().copy();
        }

        @Override
        protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
            throw new UnsupportedOperationException();
        }
    }

    private static class XmlDataSource
    implements DataSource {
        private final String contentType;
        private final InputStream is;
        private boolean consumed;

        XmlDataSource(String string, InputStream inputStream) {
            this.contentType = string;
            this.is = inputStream;
        }

        public boolean consumed() {
            return this.consumed;
        }

        @Override
        public InputStream getInputStream() {
            this.consumed = !this.consumed;
            return this.is;
        }

        @Override
        public OutputStream getOutputStream() {
            return null;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getName() {
            return "";
        }
    }
}

