/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.streaming;

import com.sun.istack.internal.FinalArrayList;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.XMLStreamException2;
import com.sun.xml.internal.ws.util.xml.DummyLocation;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class DOMStreamReader
implements XMLStreamReader,
NamespaceContext {
    private Node _current;
    private Node _start;
    private NamedNodeMap _namedNodeMap;
    private String wholeText;
    private final FinalArrayList<Attr> _currentAttributes = new FinalArrayList();
    private Scope[] scopes = new Scope[8];
    private int depth = 0;
    int _state;

    public DOMStreamReader() {
    }

    public DOMStreamReader(Node node) {
        this.setCurrentNode(node);
    }

    public void setCurrentNode(Node node) {
        this.scopes[0] = new Scope(null);
        this.depth = 0;
        this._start = this._current = node;
        this._state = 7;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    private void splitAttributes() {
        int n;
        this._currentAttributes.clear();
        Scope scope = this.allocateScope();
        this._namedNodeMap = this._current.getAttributes();
        if (this._namedNodeMap != null) {
            n = this._namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)this._namedNodeMap.item(i);
                String string = attr.getNodeName();
                if (string.startsWith("xmlns:") || string.equals("xmlns")) {
                    scope.currentNamespaces.add(attr);
                    continue;
                }
                this._currentAttributes.add(attr);
            }
        }
        this.ensureNs(this._current);
        for (n = this._currentAttributes.size() - 1; n >= 0; --n) {
            Attr attr = (Attr)this._currentAttributes.get(n);
            if (DOMStreamReader.fixNull(attr.getNamespaceURI()).length() <= 0) continue;
            this.ensureNs(attr);
        }
    }

    private void ensureNs(Node node) {
        String string = DOMStreamReader.fixNull(node.getPrefix());
        String string2 = DOMStreamReader.fixNull(node.getNamespaceURI());
        Scope scope = this.scopes[this.depth];
        String string3 = scope.getNamespaceURI(string);
        if (string.length() == 0 ? (string3 = DOMStreamReader.fixNull(string3)).equals(string2) : string3 != null && string3.equals(string2)) {
            return;
        }
        if (string.equals("xml") || string.equals("xmlns")) {
            return;
        }
        scope.additionalNamespaces.add(string);
        scope.additionalNamespaces.add(string2);
    }

    private Scope allocateScope() {
        Object object;
        if (this.scopes.length == ++this.depth) {
            object = new Scope[this.scopes.length * 2];
            System.arraycopy(this.scopes, 0, object, 0, this.scopes.length);
            this.scopes = object;
        }
        if ((object = this.scopes[this.depth]) == null) {
            this.scopes[this.depth] = new Scope(this.scopes[this.depth - 1]);
            object = this.scopes[this.depth];
        } else {
            object.reset();
        }
        return object;
    }

    @Override
    public int getAttributeCount() {
        if (this._state == 1) {
            return this._currentAttributes.size();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeCount() called in illegal state");
    }

    @Override
    public String getAttributeLocalName(int n) {
        if (this._state == 1) {
            String string = ((Attr)this._currentAttributes.get(n)).getLocalName();
            return string != null ? string : QName.valueOf(((Attr)this._currentAttributes.get(n)).getNodeName()).getLocalPart();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeLocalName() called in illegal state");
    }

    @Override
    public QName getAttributeName(int n) {
        if (this._state == 1) {
            Node node = (Node)this._currentAttributes.get(n);
            String string = node.getLocalName();
            if (string != null) {
                String string2 = node.getPrefix();
                String string3 = node.getNamespaceURI();
                return new QName(DOMStreamReader.fixNull(string3), string, DOMStreamReader.fixNull(string2));
            }
            return QName.valueOf(node.getNodeName());
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeName() called in illegal state");
    }

    @Override
    public String getAttributeNamespace(int n) {
        if (this._state == 1) {
            String string = ((Attr)this._currentAttributes.get(n)).getNamespaceURI();
            return DOMStreamReader.fixNull(string);
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeNamespace() called in illegal state");
    }

    @Override
    public String getAttributePrefix(int n) {
        if (this._state == 1) {
            String string = ((Attr)this._currentAttributes.get(n)).getPrefix();
            return DOMStreamReader.fixNull(string);
        }
        throw new IllegalStateException("DOMStreamReader: getAttributePrefix() called in illegal state");
    }

    @Override
    public String getAttributeType(int n) {
        if (this._state == 1) {
            return "CDATA";
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeType() called in illegal state");
    }

    @Override
    public String getAttributeValue(int n) {
        if (this._state == 1) {
            return ((Attr)this._currentAttributes.get(n)).getNodeValue();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeValue() called in illegal state");
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        if (this._state == 1) {
            if (this._namedNodeMap != null) {
                Node node = this._namedNodeMap.getNamedItemNS(string, string2);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeValue() called in illegal state");
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        throw new RuntimeException("DOMStreamReader: getElementText() not implemented");
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public int getEventType() {
        return this._state;
    }

    @Override
    public String getLocalName() {
        if (this._state == 1 || this._state == 2) {
            String string = this._current.getLocalName();
            return string != null ? string : QName.valueOf(this._current.getNodeName()).getLocalPart();
        }
        if (this._state == 9) {
            return this._current.getNodeName();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeValue() called in illegal state");
    }

    @Override
    public Location getLocation() {
        return DummyLocation.INSTANCE;
    }

    @Override
    public QName getName() {
        if (this._state == 1 || this._state == 2) {
            String string = this._current.getLocalName();
            if (string != null) {
                String string2 = this._current.getPrefix();
                String string3 = this._current.getNamespaceURI();
                return new QName(DOMStreamReader.fixNull(string3), string, DOMStreamReader.fixNull(string2));
            }
            return QName.valueOf(this._current.getNodeName());
        }
        throw new IllegalStateException("DOMStreamReader: getName() called in illegal state");
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this;
    }

    private Scope getCheckedScope() {
        if (this._state == 1 || this._state == 2) {
            return this.scopes[this.depth];
        }
        throw new IllegalStateException("DOMStreamReader: neither on START_ELEMENT nor END_ELEMENT");
    }

    @Override
    public int getNamespaceCount() {
        return this.getCheckedScope().getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int n) {
        return this.getCheckedScope().getNamespacePrefix(n);
    }

    @Override
    public String getNamespaceURI(int n) {
        return this.getCheckedScope().getNamespaceURI(n);
    }

    @Override
    public String getNamespaceURI() {
        if (this._state == 1 || this._state == 2) {
            String string = this._current.getNamespaceURI();
            return DOMStreamReader.fixNull(string);
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String string) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("DOMStreamReader: getNamespaceURI(String) call with a null prefix");
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String string3 = this.scopes[this.depth].getNamespaceURI(string);
        if (string3 != null) {
            return string3;
        }
        Node node = this.findRootElement();
        String string4 = string2 = string.length() == 0 ? "xmlns" : "xmlns:" + string;
        while (node.getNodeType() != 9) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Attr attr = (Attr)namedNodeMap.getNamedItem(string2);
            if (attr != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        return null;
    }

    @Override
    public String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("DOMStreamReader: getPrefix(String) call with a null namespace URI");
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        String string2 = this.scopes[this.depth].getPrefix(string);
        if (string2 != null) {
            return string2;
        }
        Node node = this.findRootElement();
        while (node.getNodeType() != 9) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                string2 = DOMStreamReader.getPrefixForAttr(attr, string);
                if (string2 == null) continue;
                return string2;
            }
            node = node.getParentNode();
        }
        return null;
    }

    private Node findRootElement() {
        short s;
        Node node = this._start;
        while ((s = node.getNodeType()) != 9 && s != 1) {
            node = node.getParentNode();
        }
        return node;
    }

    private static String getPrefixForAttr(Attr attr, String string) {
        String string2 = attr.getNodeName();
        if (!string2.startsWith("xmlns:") && !string2.equals("xmlns")) {
            return null;
        }
        if (attr.getValue().equals(string)) {
            if (string2.equals("xmlns")) {
                return "";
            }
            String string3 = attr.getLocalName();
            return string3 != null ? string3 : QName.valueOf(string2).getLocalPart();
        }
        return null;
    }

    @Override
    public Iterator getPrefixes(String string) {
        String string2 = this.getPrefix(string);
        if (string2 == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.singletonList(string2).iterator();
    }

    @Override
    public String getPIData() {
        if (this._state == 3) {
            return ((ProcessingInstruction)this._current).getData();
        }
        return null;
    }

    @Override
    public String getPITarget() {
        if (this._state == 3) {
            return ((ProcessingInstruction)this._current).getTarget();
        }
        return null;
    }

    @Override
    public String getPrefix() {
        if (this._state == 1 || this._state == 2) {
            String string = this._current.getPrefix();
            return DOMStreamReader.fixNull(string);
        }
        return null;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return null;
    }

    @Override
    public String getText() {
        if (this._state == 4) {
            return this.wholeText;
        }
        if (this._state == 12 || this._state == 5 || this._state == 9) {
            return this._current.getNodeValue();
        }
        throw new IllegalStateException("DOMStreamReader: getTextLength() called in illegal state");
    }

    @Override
    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        String string = this.getText();
        int n4 = Math.min(n3, string.length() - n);
        string.getChars(n, n + n4, cArray, n2);
        return n4;
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public int getTextStart() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return 0;
        }
        throw new IllegalStateException("DOMStreamReader: getTextStart() called in illegal state");
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean hasName() {
        return this._state == 1 || this._state == 2;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this._state != 8;
    }

    @Override
    public boolean hasText() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return this.getText().trim().length() > 0;
        }
        return false;
    }

    @Override
    public boolean isAttributeSpecified(int n) {
        return false;
    }

    @Override
    public boolean isCharacters() {
        return this._state == 4;
    }

    @Override
    public boolean isEndElement() {
        return this._state == 2;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean isStartElement() {
        return this._state == 1;
    }

    @Override
    public boolean isWhiteSpace() {
        if (this._state == 4 || this._state == 12) {
            return this.getText().trim().length() == 0;
        }
        return false;
    }

    private static int mapNodeTypeToState(int n) {
        switch (n) {
            case 4: {
                return 12;
            }
            case 8: {
                return 5;
            }
            case 1: {
                return 1;
            }
            case 6: {
                return 15;
            }
            case 5: {
                return 9;
            }
            case 12: {
                return 14;
            }
            case 7: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        throw new RuntimeException("DOMStreamReader: Unexpected node type");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int next() throws XMLStreamException {
        int n;
        block4: while (true) {
            n = this._next();
            switch (n) {
                case 4: {
                    Node node = this._current.getPreviousSibling();
                    if (node != null && node.getNodeType() == 3) continue block4;
                    Text text = (Text)this._current;
                    this.wholeText = text.getWholeText();
                    if (this.wholeText.length() != 0) return 4;
                    continue block4;
                }
                case 1: {
                    this.splitAttributes();
                    return 1;
                }
            }
            break;
        }
        return n;
    }

    private int _next() throws XMLStreamException {
        switch (this._state) {
            case 8: {
                throw new IllegalStateException("DOMStreamReader: Calling next() at END_DOCUMENT");
            }
            case 7: {
                if (this._current.getNodeType() == 1) {
                    this._state = 1;
                    return 1;
                }
                Node node = this._current.getFirstChild();
                if (node == null) {
                    this._state = 8;
                    return 8;
                }
                this._current = node;
                this._state = DOMStreamReader.mapNodeTypeToState(this._current.getNodeType());
                return this._state;
            }
            case 1: {
                Node node = this._current.getFirstChild();
                if (node == null) {
                    this._state = 2;
                    return 2;
                }
                this._current = node;
                this._state = DOMStreamReader.mapNodeTypeToState(this._current.getNodeType());
                return this._state;
            }
            case 2: {
                --this.depth;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 12: {
                if (this._current == this._start) {
                    this._state = 8;
                    return 8;
                }
                Node node = this._current.getNextSibling();
                if (node == null) {
                    this._current = this._current.getParentNode();
                    this._state = this._current == null || this._current.getNodeType() == 9 ? 8 : 2;
                    return this._state;
                }
                this._current = node;
                this._state = DOMStreamReader.mapNodeTypeToState(this._current.getNodeType());
                return this._state;
            }
        }
        throw new RuntimeException("DOMStreamReader: Unexpected internal state");
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int n = this.next();
        while (n == 4 && this.isWhiteSpace() || n == 12 && this.isWhiteSpace() || n == 6 || n == 3 || n == 5) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException2("DOMStreamReader: Expected start or end tag");
        }
        return n;
    }

    @Override
    public void require(int n, String string, String string2) throws XMLStreamException {
        if (n != this._state) {
            throw new XMLStreamException2("DOMStreamReader: Required event type not found");
        }
        if (string != null && !string.equals(this.getNamespaceURI())) {
            throw new XMLStreamException2("DOMStreamReader: Required namespaceURI not found");
        }
        if (string2 != null && !string2.equals(this.getLocalName())) {
            throw new XMLStreamException2("DOMStreamReader: Required localName not found");
        }
    }

    @Override
    public boolean standaloneSet() {
        return true;
    }

    private static void displayDOM(Node node, OutputStream outputStream) {
        try {
            System.out.println("\n====\n");
            XmlUtil.newTransformer().transform(new DOMSource(node), new StreamResult(outputStream));
            System.out.println("\n====\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void verifyDOMIntegrity(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 2: {
                if (node.getLocalName() == null) {
                    System.out.println("WARNING: DOM level 1 node found");
                    System.out.println(" -> node.getNodeName() = " + node.getNodeName());
                    System.out.println(" -> node.getNamespaceURI() = " + node.getNamespaceURI());
                    System.out.println(" -> node.getLocalName() = " + node.getLocalName());
                    System.out.println(" -> node.getPrefix() = " + node.getPrefix());
                }
                if (node.getNodeType() == 2) {
                    return;
                }
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    DOMStreamReader.verifyDOMIntegrity(namedNodeMap.item(i));
                }
            }
            case 9: {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    DOMStreamReader.verifyDOMIntegrity(nodeList.item(i));
                }
                break;
            }
        }
    }

    private static String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static final class Scope {
        final Scope parent;
        final FinalArrayList<Attr> currentNamespaces = new FinalArrayList();
        final FinalArrayList<String> additionalNamespaces = new FinalArrayList();

        Scope(Scope scope) {
            this.parent = scope;
        }

        void reset() {
            this.currentNamespaces.clear();
            this.additionalNamespaces.clear();
        }

        int getNamespaceCount() {
            return this.currentNamespaces.size() + this.additionalNamespaces.size() / 2;
        }

        String getNamespacePrefix(int n) {
            int n2 = this.currentNamespaces.size();
            if (n < n2) {
                Attr attr = (Attr)this.currentNamespaces.get(n);
                String string = attr.getLocalName();
                if (string == null) {
                    string = QName.valueOf(attr.getNodeName()).getLocalPart();
                }
                return string.equals("xmlns") ? null : string;
            }
            return (String)this.additionalNamespaces.get((n - n2) * 2);
        }

        String getNamespaceURI(int n) {
            int n2 = this.currentNamespaces.size();
            if (n < n2) {
                return ((Attr)this.currentNamespaces.get(n)).getValue();
            }
            return (String)this.additionalNamespaces.get((n - n2) * 2 + 1);
        }

        String getPrefix(String string) {
            Scope scope = this;
            while (scope != null) {
                int n;
                for (n = scope.currentNamespaces.size() - 1; n >= 0; --n) {
                    String string2 = DOMStreamReader.getPrefixForAttr((Attr)scope.currentNamespaces.get(n), string);
                    if (string2 == null) continue;
                    return string2;
                }
                for (n = scope.additionalNamespaces.size() - 2; n >= 0; n -= 2) {
                    if (!((String)scope.additionalNamespaces.get(n + 1)).equals(string)) continue;
                    return (String)scope.additionalNamespaces.get(n);
                }
                scope = scope.parent;
            }
            return null;
        }

        String getNamespaceURI(@NotNull String string) {
            String string2 = string.length() == 0 ? "xmlns" : "xmlns:" + string;
            Scope scope = this;
            while (scope != null) {
                int n;
                for (n = scope.currentNamespaces.size() - 1; n >= 0; --n) {
                    Attr attr = (Attr)scope.currentNamespaces.get(n);
                    if (!attr.getNodeName().equals(string2)) continue;
                    return attr.getValue();
                }
                for (n = scope.additionalNamespaces.size() - 2; n >= 0; n -= 2) {
                    if (!((String)scope.additionalNamespaces.get(n)).equals(string)) continue;
                    return (String)scope.additionalNamespaces.get(n + 1);
                }
                scope = scope.parent;
            }
            return null;
        }
    }
}

