/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.parser;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLDescriptorKind;
import com.sun.xml.internal.ws.api.policy.PolicyResolver;
import com.sun.xml.internal.ws.api.policy.PolicyResolverFactory;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.api.wsdl.parser.MetaDataResolver;
import com.sun.xml.internal.ws.api.wsdl.parser.MetadataResolverFactory;
import com.sun.xml.internal.ws.api.wsdl.parser.ServiceDescriptor;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.api.wsdl.parser.XMLEntityResolver;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundFaultImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLFaultImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLInputImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLMessageImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLOutputImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPartDescriptorImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPartImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortTypeImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.internal.ws.policy.jaxws.PolicyWSDLParserExtension;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.resources.WsdlmodelMessages;
import com.sun.xml.internal.ws.streaming.SourceReaderFactory;
import com.sun.xml.internal.ws.streaming.TidyXMLStreamReader;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.EntityResolverWrapper;
import com.sun.xml.internal.ws.wsdl.parser.FoolProofParserExtension;
import com.sun.xml.internal.ws.wsdl.parser.InaccessibleWSDLException;
import com.sun.xml.internal.ws.wsdl.parser.MIMEConstants;
import com.sun.xml.internal.ws.wsdl.parser.MemberSubmissionAddressingWSDLParserExtension;
import com.sun.xml.internal.ws.wsdl.parser.MexEntityResolver;
import com.sun.xml.internal.ws.wsdl.parser.ParserUtil;
import com.sun.xml.internal.ws.wsdl.parser.SOAPConstants;
import com.sun.xml.internal.ws.wsdl.parser.W3CAddressingMetadataWSDLParserExtension;
import com.sun.xml.internal.ws.wsdl.parser.W3CAddressingWSDLParserExtension;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import com.sun.xml.internal.ws.wsdl.parser.WSDLParserExtensionContextImpl;
import com.sun.xml.internal.ws.wsdl.parser.WSDLParserExtensionFacade;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class RuntimeWSDLParser {
    private final WSDLModelImpl wsdlDoc;
    private String targetNamespace;
    private final Set<String> importedWSDLs = new HashSet<String>();
    private final XMLEntityResolver resolver;
    private final PolicyResolver policyResolver;
    private final WSDLParserExtension extensionFacade;
    private final WSDLParserExtensionContextImpl context;
    List<WSDLParserExtension> extensions;
    private static final Logger LOGGER = Logger.getLogger(RuntimeWSDLParser.class.getName());

    public static WSDLModelImpl parse(@Nullable URL uRL, @NotNull Source source, @NotNull EntityResolver entityResolver, boolean bl, Container container, WSDLParserExtension ... wSDLParserExtensionArray) throws IOException, XMLStreamException, SAXException {
        return RuntimeWSDLParser.parse(uRL, source, entityResolver, bl, container, PolicyResolverFactory.create(), wSDLParserExtensionArray);
    }

    public static WSDLModelImpl parse(@Nullable URL uRL, @NotNull Source source, @NotNull EntityResolver entityResolver, boolean bl, Container container, @NotNull PolicyResolver policyResolver, WSDLParserExtension ... wSDLParserExtensionArray) throws IOException, XMLStreamException, SAXException {
        XMLEntityResolver.Parser parser;
        assert (entityResolver != null);
        RuntimeWSDLParser runtimeWSDLParser = new RuntimeWSDLParser(source.getSystemId(), new EntityResolverWrapper(entityResolver), bl, container, policyResolver, wSDLParserExtensionArray);
        try {
            parser = runtimeWSDLParser.resolveWSDL(uRL, source);
            if (!RuntimeWSDLParser.hasWSDLDefinitions(parser.parser)) {
                throw new XMLStreamException(ClientMessages.RUNTIME_WSDLPARSER_INVALID_WSDL(parser.systemId, WSDLConstants.QNAME_DEFINITIONS, parser.parser.getName(), parser.parser.getLocation()));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            if (uRL == null) {
                throw xMLStreamException;
            }
            return RuntimeWSDLParser.tryWithMex(runtimeWSDLParser, uRL, entityResolver, bl, container, xMLStreamException, policyResolver, wSDLParserExtensionArray);
        }
        catch (IOException iOException) {
            if (uRL == null) {
                throw iOException;
            }
            return RuntimeWSDLParser.tryWithMex(runtimeWSDLParser, uRL, entityResolver, bl, container, iOException, policyResolver, wSDLParserExtensionArray);
        }
        runtimeWSDLParser.parseWSDL(parser, false);
        runtimeWSDLParser.wsdlDoc.freeze();
        runtimeWSDLParser.extensionFacade.finished(runtimeWSDLParser.context);
        runtimeWSDLParser.extensionFacade.postFinished(runtimeWSDLParser.context);
        if (runtimeWSDLParser.wsdlDoc.getServices().isEmpty()) {
            throw new WebServiceException(ClientMessages.WSDL_CONTAINS_NO_SERVICE(uRL));
        }
        return runtimeWSDLParser.wsdlDoc;
    }

    private static WSDLModelImpl tryWithMex(@NotNull RuntimeWSDLParser runtimeWSDLParser, @NotNull URL uRL, @NotNull EntityResolver entityResolver, boolean bl, Container container, Throwable throwable, PolicyResolver policyResolver, WSDLParserExtension ... wSDLParserExtensionArray) throws SAXException, XMLStreamException {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        try {
            WSDLModelImpl wSDLModelImpl = runtimeWSDLParser.parseUsingMex(uRL, entityResolver, bl, container, policyResolver, wSDLParserExtensionArray);
            if (wSDLModelImpl == null) {
                throw new WebServiceException(ClientMessages.FAILED_TO_PARSE(uRL.toExternalForm(), throwable.getMessage()), throwable);
            }
            return wSDLModelImpl;
        }
        catch (URISyntaxException uRISyntaxException) {
            arrayList.add(throwable);
            arrayList.add(uRISyntaxException);
        }
        catch (IOException iOException) {
            arrayList.add(throwable);
            arrayList.add(iOException);
        }
        throw new InaccessibleWSDLException(arrayList);
    }

    private WSDLModelImpl parseUsingMex(@NotNull URL uRL, @NotNull EntityResolver entityResolver, boolean bl, Container container, PolicyResolver policyResolver, WSDLParserExtension[] wSDLParserExtensionArray) throws IOException, SAXException, XMLStreamException, URISyntaxException {
        Object object;
        MetaDataResolver metaDataResolver = null;
        ServiceDescriptor serviceDescriptor = null;
        RuntimeWSDLParser runtimeWSDLParser = null;
        Object object2 = ServiceFinder.find(MetadataResolverFactory.class).iterator();
        while (object2.hasNext() && (serviceDescriptor = (metaDataResolver = ((MetadataResolverFactory)(object = object2.next())).metadataResolver(entityResolver)).resolve(uRL.toURI())) == null) {
        }
        if (serviceDescriptor != null) {
            object2 = serviceDescriptor.getWSDLs();
            runtimeWSDLParser = new RuntimeWSDLParser(uRL.toExternalForm(), new MexEntityResolver((List<? extends Source>)object2), bl, container, policyResolver, wSDLParserExtensionArray);
            object = object2.iterator();
            while (object.hasNext()) {
                Source source = (Source)object.next();
                String string = source.getSystemId();
                XMLEntityResolver.Parser parser = runtimeWSDLParser.resolver.resolveEntity(null, string);
                runtimeWSDLParser.parseWSDL(parser, false);
            }
        }
        if ((metaDataResolver == null || serviceDescriptor == null) && (uRL.getProtocol().equals("http") || uRL.getProtocol().equals("https")) && uRL.getQuery() == null) {
            object2 = uRL.toExternalForm();
            object2 = (String)object2 + "?wsdl";
            uRL = new URL((String)object2);
            runtimeWSDLParser = new RuntimeWSDLParser(uRL.toExternalForm(), new EntityResolverWrapper(entityResolver), bl, container, policyResolver, wSDLParserExtensionArray);
            object = this.resolveWSDL(uRL, new StreamSource(uRL.toExternalForm()));
            runtimeWSDLParser.parseWSDL((XMLEntityResolver.Parser)object, false);
        }
        if (runtimeWSDLParser == null) {
            return null;
        }
        runtimeWSDLParser.wsdlDoc.freeze();
        runtimeWSDLParser.extensionFacade.finished(runtimeWSDLParser.context);
        runtimeWSDLParser.extensionFacade.postFinished(runtimeWSDLParser.context);
        return runtimeWSDLParser.wsdlDoc;
    }

    private static boolean hasWSDLDefinitions(XMLStreamReader xMLStreamReader) {
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        return xMLStreamReader.getName().equals(WSDLConstants.QNAME_DEFINITIONS);
    }

    public static WSDLModelImpl parse(XMLEntityResolver.Parser parser, XMLEntityResolver xMLEntityResolver, boolean bl, Container container, PolicyResolver policyResolver, WSDLParserExtension ... wSDLParserExtensionArray) throws IOException, XMLStreamException, SAXException {
        assert (xMLEntityResolver != null);
        RuntimeWSDLParser runtimeWSDLParser = new RuntimeWSDLParser(parser.systemId.toExternalForm(), xMLEntityResolver, bl, container, policyResolver, wSDLParserExtensionArray);
        runtimeWSDLParser.parseWSDL(parser, false);
        runtimeWSDLParser.wsdlDoc.freeze();
        runtimeWSDLParser.extensionFacade.finished(runtimeWSDLParser.context);
        runtimeWSDLParser.extensionFacade.postFinished(runtimeWSDLParser.context);
        return runtimeWSDLParser.wsdlDoc;
    }

    public static WSDLModelImpl parse(XMLEntityResolver.Parser parser, XMLEntityResolver xMLEntityResolver, boolean bl, Container container, WSDLParserExtension ... wSDLParserExtensionArray) throws IOException, XMLStreamException, SAXException {
        assert (xMLEntityResolver != null);
        RuntimeWSDLParser runtimeWSDLParser = new RuntimeWSDLParser(parser.systemId.toExternalForm(), xMLEntityResolver, bl, container, PolicyResolverFactory.create(), wSDLParserExtensionArray);
        runtimeWSDLParser.parseWSDL(parser, false);
        runtimeWSDLParser.wsdlDoc.freeze();
        runtimeWSDLParser.extensionFacade.finished(runtimeWSDLParser.context);
        runtimeWSDLParser.extensionFacade.postFinished(runtimeWSDLParser.context);
        return runtimeWSDLParser.wsdlDoc;
    }

    private RuntimeWSDLParser(@NotNull String string, XMLEntityResolver xMLEntityResolver, boolean bl, Container container, PolicyResolver policyResolver, WSDLParserExtension ... wSDLParserExtensionArray) {
        this.wsdlDoc = string != null ? new WSDLModelImpl(string) : new WSDLModelImpl();
        this.resolver = xMLEntityResolver;
        this.policyResolver = policyResolver;
        this.extensions = new ArrayList<WSDLParserExtension>();
        this.context = new WSDLParserExtensionContextImpl(this.wsdlDoc, bl, container, policyResolver);
        this.register(new PolicyWSDLParserExtension());
        this.register(new MemberSubmissionAddressingWSDLParserExtension());
        this.register(new W3CAddressingWSDLParserExtension());
        this.register(new W3CAddressingMetadataWSDLParserExtension());
        for (WSDLParserExtension wSDLParserExtension : wSDLParserExtensionArray) {
            this.register(wSDLParserExtension);
        }
        this.extensionFacade = new WSDLParserExtensionFacade(this.extensions.toArray(new WSDLParserExtension[0]));
    }

    private XMLEntityResolver.Parser resolveWSDL(@Nullable URL uRL, @NotNull Source source) throws IOException, SAXException, XMLStreamException {
        String string = source.getSystemId();
        XMLEntityResolver.Parser parser = this.resolver.resolveEntity(null, string);
        if (parser == null && uRL != null) {
            parser = this.resolver.resolveEntity(null, uRL.toExternalForm());
        }
        if (parser == null) {
            parser = uRL != null ? new XMLEntityResolver.Parser(uRL, RuntimeWSDLParser.createReader(uRL)) : new XMLEntityResolver.Parser(uRL, this.createReader(source));
        }
        return parser;
    }

    private XMLStreamReader createReader(@NotNull Source source) throws XMLStreamException {
        return new TidyXMLStreamReader(SourceReaderFactory.createSourceReader(source, true), null);
    }

    private void parseImport(@NotNull URL uRL) throws XMLStreamException, IOException, SAXException {
        String string = uRL.toExternalForm();
        XMLEntityResolver.Parser parser = this.resolver.resolveEntity(null, string);
        if (parser == null) {
            parser = new XMLEntityResolver.Parser(uRL, RuntimeWSDLParser.createReader(uRL));
        }
        this.parseWSDL(parser, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseWSDL(XMLEntityResolver.Parser parser, boolean bl) throws XMLStreamException, IOException, SAXException {
        try (XMLStreamReader xMLStreamReader = parser.parser;){
            if (parser.systemId != null && !this.importedWSDLs.add(parser.systemId.toExternalForm())) {
                return;
            }
            if (xMLStreamReader.getEventType() == 7) {
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            }
            if (xMLStreamReader.getEventType() != 8 && xMLStreamReader.getName().equals(WSDLConstants.QNAME_SCHEMA) && bl) {
                LOGGER.warning(WsdlmodelMessages.WSDL_IMPORT_SHOULD_BE_WSDL(parser.systemId));
                return;
            }
            String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "targetNamespace");
            String string2 = this.targetNamespace;
            this.targetNamespace = string;
            while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2 && xMLStreamReader.getEventType() != 8) {
                QName qName = xMLStreamReader.getName();
                if (WSDLConstants.QNAME_IMPORT.equals(qName)) {
                    this.parseImport(parser.systemId, xMLStreamReader);
                    continue;
                }
                if (WSDLConstants.QNAME_MESSAGE.equals(qName)) {
                    this.parseMessage(xMLStreamReader);
                    continue;
                }
                if (WSDLConstants.QNAME_PORT_TYPE.equals(qName)) {
                    this.parsePortType(xMLStreamReader);
                    continue;
                }
                if (WSDLConstants.QNAME_BINDING.equals(qName)) {
                    this.parseBinding(xMLStreamReader);
                    continue;
                }
                if (WSDLConstants.QNAME_SERVICE.equals(qName)) {
                    this.parseService(xMLStreamReader);
                    continue;
                }
                this.extensionFacade.definitionsElements(xMLStreamReader);
            }
            this.targetNamespace = string2;
        }
    }

    private void parseService(XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        WSDLServiceImpl wSDLServiceImpl = new WSDLServiceImpl(xMLStreamReader, this.wsdlDoc, new QName(this.targetNamespace, string));
        this.extensionFacade.serviceAttributes(wSDLServiceImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.QNAME_PORT.equals(qName)) {
                this.parsePort(xMLStreamReader, wSDLServiceImpl);
                if (xMLStreamReader.getEventType() == 2) continue;
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            this.extensionFacade.serviceElements(wSDLServiceImpl, xMLStreamReader);
        }
        this.wsdlDoc.addService(wSDLServiceImpl);
    }

    private void parsePort(XMLStreamReader xMLStreamReader, WSDLServiceImpl wSDLServiceImpl) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        String string2 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "binding");
        QName qName = ParserUtil.getQName(xMLStreamReader, string2);
        QName qName2 = new QName(wSDLServiceImpl.getName().getNamespaceURI(), string);
        WSDLPortImpl wSDLPortImpl = new WSDLPortImpl(xMLStreamReader, wSDLServiceImpl, qName2, qName);
        this.extensionFacade.portAttributes(wSDLPortImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName3 = xMLStreamReader.getName();
            if (SOAPConstants.QNAME_ADDRESS.equals(qName3) || SOAPConstants.QNAME_SOAP12ADDRESS.equals(qName3)) {
                String string3 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "location");
                if (string3 != null) {
                    try {
                        wSDLPortImpl.setAddress(new EndpointAddress(string3));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            if (AddressingVersion.W3C.nsUri.equals(qName3.getNamespaceURI()) && "EndpointReference".equals(qName3.getLocalPart())) {
                try {
                    WSEndpointReference wSEndpointReference = new WSEndpointReference(xMLStreamReader, AddressingVersion.W3C);
                    wSDLPortImpl.setEPR(wSEndpointReference);
                    if (xMLStreamReader.getEventType() != 2 || !xMLStreamReader.getName().equals(WSDLConstants.QNAME_PORT)) continue;
                    break;
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException(xMLStreamException);
                }
            }
            this.extensionFacade.portElements(wSDLPortImpl, xMLStreamReader);
        }
        if (wSDLPortImpl.getAddress() == null) {
            try {
                wSDLPortImpl.setAddress(new EndpointAddress(""));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        wSDLServiceImpl.put(qName2, wSDLPortImpl);
    }

    private void parseBinding(XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        String string2 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "type");
        if (string == null || string2 == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return;
        }
        WSDLBoundPortTypeImpl wSDLBoundPortTypeImpl = new WSDLBoundPortTypeImpl(xMLStreamReader, this.wsdlDoc, new QName(this.targetNamespace, string), ParserUtil.getQName(xMLStreamReader, string2));
        this.extensionFacade.bindingAttributes(wSDLBoundPortTypeImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            String string3;
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.NS_SOAP_BINDING.equals(qName)) {
                wSDLBoundPortTypeImpl.setBindingId(BindingID.SOAP11_HTTP);
                string3 = xMLStreamReader.getAttributeValue(null, "style");
                if (string3 != null && string3.equals("rpc")) {
                    wSDLBoundPortTypeImpl.setStyle(SOAPBinding.Style.RPC);
                } else {
                    wSDLBoundPortTypeImpl.setStyle(SOAPBinding.Style.DOCUMENT);
                }
                RuntimeWSDLParser.goToEnd(xMLStreamReader);
                continue;
            }
            if (WSDLConstants.NS_SOAP12_BINDING.equals(qName)) {
                wSDLBoundPortTypeImpl.setBindingId(BindingID.SOAP12_HTTP);
                string3 = xMLStreamReader.getAttributeValue(null, "style");
                if (string3 != null && string3.equals("rpc")) {
                    wSDLBoundPortTypeImpl.setStyle(SOAPBinding.Style.RPC);
                } else {
                    wSDLBoundPortTypeImpl.setStyle(SOAPBinding.Style.DOCUMENT);
                }
                RuntimeWSDLParser.goToEnd(xMLStreamReader);
                continue;
            }
            if (WSDLConstants.QNAME_OPERATION.equals(qName)) {
                this.parseBindingOperation(xMLStreamReader, wSDLBoundPortTypeImpl);
                continue;
            }
            this.extensionFacade.bindingElements(wSDLBoundPortTypeImpl, xMLStreamReader);
        }
    }

    private void parseBindingOperation(XMLStreamReader xMLStreamReader, WSDLBoundPortTypeImpl wSDLBoundPortTypeImpl) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        if (string == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return;
        }
        QName qName = new QName(wSDLBoundPortTypeImpl.getPortTypeName().getNamespaceURI(), string);
        WSDLBoundOperationImpl wSDLBoundOperationImpl = new WSDLBoundOperationImpl(xMLStreamReader, wSDLBoundPortTypeImpl, qName);
        wSDLBoundPortTypeImpl.put(qName, wSDLBoundOperationImpl);
        this.extensionFacade.bindingOperationAttributes(wSDLBoundOperationImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName2 = xMLStreamReader.getName();
            String string2 = null;
            if (WSDLConstants.QNAME_INPUT.equals(qName2)) {
                this.parseInputBinding(xMLStreamReader, wSDLBoundOperationImpl);
            } else if (WSDLConstants.QNAME_OUTPUT.equals(qName2)) {
                this.parseOutputBinding(xMLStreamReader, wSDLBoundOperationImpl);
            } else if (WSDLConstants.QNAME_FAULT.equals(qName2)) {
                this.parseFaultBinding(xMLStreamReader, wSDLBoundOperationImpl);
            } else if (SOAPConstants.QNAME_OPERATION.equals(qName2) || SOAPConstants.QNAME_SOAP12OPERATION.equals(qName2)) {
                string2 = xMLStreamReader.getAttributeValue(null, "style");
                String string3 = xMLStreamReader.getAttributeValue(null, "soapAction");
                if (string3 != null) {
                    wSDLBoundOperationImpl.setSoapAction(string3);
                }
                RuntimeWSDLParser.goToEnd(xMLStreamReader);
            } else {
                this.extensionFacade.bindingOperationElements(wSDLBoundOperationImpl, xMLStreamReader);
            }
            if (string2 != null) {
                if (string2.equals("rpc")) {
                    wSDLBoundOperationImpl.setStyle(SOAPBinding.Style.RPC);
                    continue;
                }
                wSDLBoundOperationImpl.setStyle(SOAPBinding.Style.DOCUMENT);
                continue;
            }
            wSDLBoundOperationImpl.setStyle(wSDLBoundPortTypeImpl.getStyle());
        }
    }

    private void parseInputBinding(XMLStreamReader xMLStreamReader, WSDLBoundOperationImpl wSDLBoundOperationImpl) {
        boolean bl = false;
        this.extensionFacade.bindingOperationInputAttributes(wSDLBoundOperationImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if ((SOAPConstants.QNAME_BODY.equals(qName) || SOAPConstants.QNAME_SOAP12BODY.equals(qName)) && !bl) {
                bl = true;
                wSDLBoundOperationImpl.setInputExplicitBodyParts(RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, wSDLBoundOperationImpl, BindingMode.INPUT));
                RuntimeWSDLParser.goToEnd(xMLStreamReader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(qName) || SOAPConstants.QNAME_SOAP12HEADER.equals(qName)) {
                RuntimeWSDLParser.parseSOAPHeaderBinding(xMLStreamReader, wSDLBoundOperationImpl.getInputParts());
                continue;
            }
            if (MIMEConstants.QNAME_MULTIPART_RELATED.equals(qName)) {
                RuntimeWSDLParser.parseMimeMultipartBinding(xMLStreamReader, wSDLBoundOperationImpl, BindingMode.INPUT);
                continue;
            }
            this.extensionFacade.bindingOperationInputElements(wSDLBoundOperationImpl, xMLStreamReader);
        }
    }

    private void parseOutputBinding(XMLStreamReader xMLStreamReader, WSDLBoundOperationImpl wSDLBoundOperationImpl) {
        boolean bl = false;
        this.extensionFacade.bindingOperationOutputAttributes(wSDLBoundOperationImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if ((SOAPConstants.QNAME_BODY.equals(qName) || SOAPConstants.QNAME_SOAP12BODY.equals(qName)) && !bl) {
                bl = true;
                wSDLBoundOperationImpl.setOutputExplicitBodyParts(RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, wSDLBoundOperationImpl, BindingMode.OUTPUT));
                RuntimeWSDLParser.goToEnd(xMLStreamReader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(qName) || SOAPConstants.QNAME_SOAP12HEADER.equals(qName)) {
                RuntimeWSDLParser.parseSOAPHeaderBinding(xMLStreamReader, wSDLBoundOperationImpl.getOutputParts());
                continue;
            }
            if (MIMEConstants.QNAME_MULTIPART_RELATED.equals(qName)) {
                RuntimeWSDLParser.parseMimeMultipartBinding(xMLStreamReader, wSDLBoundOperationImpl, BindingMode.OUTPUT);
                continue;
            }
            this.extensionFacade.bindingOperationOutputElements(wSDLBoundOperationImpl, xMLStreamReader);
        }
    }

    private void parseFaultBinding(XMLStreamReader xMLStreamReader, WSDLBoundOperationImpl wSDLBoundOperationImpl) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        WSDLBoundFaultImpl wSDLBoundFaultImpl = new WSDLBoundFaultImpl(xMLStreamReader, string, wSDLBoundOperationImpl);
        wSDLBoundOperationImpl.addFault(wSDLBoundFaultImpl);
        this.extensionFacade.bindingOperationFaultAttributes(wSDLBoundFaultImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            this.extensionFacade.bindingOperationFaultElements(wSDLBoundFaultImpl, xMLStreamReader);
        }
    }

    private static boolean parseSOAPBodyBinding(XMLStreamReader xMLStreamReader, WSDLBoundOperationImpl wSDLBoundOperationImpl, BindingMode bindingMode) {
        String string = xMLStreamReader.getAttributeValue(null, "namespace");
        if (bindingMode == BindingMode.INPUT) {
            wSDLBoundOperationImpl.setRequestNamespace(string);
            return RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, wSDLBoundOperationImpl.getInputParts());
        }
        wSDLBoundOperationImpl.setResponseNamespace(string);
        return RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, wSDLBoundOperationImpl.getOutputParts());
    }

    private static boolean parseSOAPBodyBinding(XMLStreamReader xMLStreamReader, Map<String, ParameterBinding> map) {
        String string = xMLStreamReader.getAttributeValue(null, "parts");
        if (string != null) {
            List<String> list = XmlUtil.parseTokenList(string);
            if (list.isEmpty()) {
                map.put(" ", ParameterBinding.BODY);
            } else {
                for (String string2 : list) {
                    map.put(string2, ParameterBinding.BODY);
                }
            }
            return true;
        }
        return false;
    }

    private static void parseSOAPHeaderBinding(XMLStreamReader xMLStreamReader, Map<String, ParameterBinding> map) {
        String string = xMLStreamReader.getAttributeValue(null, "part");
        if (string == null || string.equals("")) {
            return;
        }
        map.put(string, ParameterBinding.HEADER);
        RuntimeWSDLParser.goToEnd(xMLStreamReader);
    }

    private static void parseMimeMultipartBinding(XMLStreamReader xMLStreamReader, WSDLBoundOperationImpl wSDLBoundOperationImpl, BindingMode bindingMode) {
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (MIMEConstants.QNAME_PART.equals(qName)) {
                RuntimeWSDLParser.parseMIMEPart(xMLStreamReader, wSDLBoundOperationImpl, bindingMode);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private static void parseMIMEPart(XMLStreamReader xMLStreamReader, WSDLBoundOperationImpl wSDLBoundOperationImpl, BindingMode bindingMode) {
        boolean bl = false;
        Map<String, ParameterBinding> map = null;
        if (bindingMode == BindingMode.INPUT) {
            map = wSDLBoundOperationImpl.getInputParts();
        } else if (bindingMode == BindingMode.OUTPUT) {
            map = wSDLBoundOperationImpl.getOutputParts();
        } else if (bindingMode == BindingMode.FAULT) {
            map = wSDLBoundOperationImpl.getFaultParts();
        }
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (SOAPConstants.QNAME_BODY.equals(qName) && !bl) {
                bl = true;
                RuntimeWSDLParser.parseSOAPBodyBinding(xMLStreamReader, wSDLBoundOperationImpl, bindingMode);
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            if (SOAPConstants.QNAME_HEADER.equals(qName)) {
                bl = true;
                RuntimeWSDLParser.parseSOAPHeaderBinding(xMLStreamReader, map);
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            if (MIMEConstants.QNAME_CONTENT.equals(qName)) {
                String string = xMLStreamReader.getAttributeValue(null, "part");
                String string2 = xMLStreamReader.getAttributeValue(null, "type");
                if (string == null || string2 == null) {
                    XMLStreamReaderUtil.skipElement(xMLStreamReader);
                    continue;
                }
                ParameterBinding parameterBinding = ParameterBinding.createAttachment(string2);
                if (map != null && parameterBinding != null && string != null) {
                    map.put(string, parameterBinding);
                }
                XMLStreamReaderUtil.next(xMLStreamReader);
                continue;
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    protected void parseImport(@Nullable URL uRL, XMLStreamReader xMLStreamReader) throws IOException, SAXException, XMLStreamException {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "location");
        URL uRL2 = uRL != null ? new URL(uRL, string) : new URL(string);
        this.parseImport(uRL2);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private void parsePortType(XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        if (string == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return;
        }
        WSDLPortTypeImpl wSDLPortTypeImpl = new WSDLPortTypeImpl(xMLStreamReader, this.wsdlDoc, new QName(this.targetNamespace, string));
        this.extensionFacade.portTypeAttributes(wSDLPortTypeImpl, xMLStreamReader);
        this.wsdlDoc.addPortType(wSDLPortTypeImpl);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.QNAME_OPERATION.equals(qName)) {
                this.parsePortTypeOperation(xMLStreamReader, wSDLPortTypeImpl);
                continue;
            }
            this.extensionFacade.portTypeElements(wSDLPortTypeImpl, xMLStreamReader);
        }
    }

    private void parsePortTypeOperation(XMLStreamReader xMLStreamReader, WSDLPortTypeImpl wSDLPortTypeImpl) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        if (string == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return;
        }
        QName qName = new QName(wSDLPortTypeImpl.getName().getNamespaceURI(), string);
        WSDLOperationImpl wSDLOperationImpl = new WSDLOperationImpl(xMLStreamReader, wSDLPortTypeImpl, qName);
        this.extensionFacade.portTypeOperationAttributes(wSDLOperationImpl, xMLStreamReader);
        String string2 = ParserUtil.getAttribute(xMLStreamReader, "parameterOrder");
        wSDLOperationImpl.setParameterOrder(string2);
        wSDLPortTypeImpl.put(string, wSDLOperationImpl);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName2 = xMLStreamReader.getName();
            if (qName2.equals(WSDLConstants.QNAME_INPUT)) {
                this.parsePortTypeOperationInput(xMLStreamReader, wSDLOperationImpl);
                continue;
            }
            if (qName2.equals(WSDLConstants.QNAME_OUTPUT)) {
                this.parsePortTypeOperationOutput(xMLStreamReader, wSDLOperationImpl);
                continue;
            }
            if (qName2.equals(WSDLConstants.QNAME_FAULT)) {
                this.parsePortTypeOperationFault(xMLStreamReader, wSDLOperationImpl);
                continue;
            }
            this.extensionFacade.portTypeOperationElements(wSDLOperationImpl, xMLStreamReader);
        }
    }

    private void parsePortTypeOperationFault(XMLStreamReader xMLStreamReader, WSDLOperationImpl wSDLOperationImpl) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "message");
        QName qName = ParserUtil.getQName(xMLStreamReader, string);
        String string2 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        WSDLFaultImpl wSDLFaultImpl = new WSDLFaultImpl(xMLStreamReader, string2, qName, wSDLOperationImpl);
        wSDLOperationImpl.addFault(wSDLFaultImpl);
        this.extensionFacade.portTypeOperationFaultAttributes(wSDLFaultImpl, xMLStreamReader);
        this.extensionFacade.portTypeOperationFault(wSDLOperationImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            this.extensionFacade.portTypeOperationFaultElements(wSDLFaultImpl, xMLStreamReader);
        }
    }

    private void parsePortTypeOperationInput(XMLStreamReader xMLStreamReader, WSDLOperationImpl wSDLOperationImpl) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "message");
        QName qName = ParserUtil.getQName(xMLStreamReader, string);
        String string2 = ParserUtil.getAttribute(xMLStreamReader, "name");
        WSDLInputImpl wSDLInputImpl = new WSDLInputImpl(xMLStreamReader, string2, qName, wSDLOperationImpl);
        wSDLOperationImpl.setInput(wSDLInputImpl);
        this.extensionFacade.portTypeOperationInputAttributes(wSDLInputImpl, xMLStreamReader);
        this.extensionFacade.portTypeOperationInput(wSDLOperationImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            this.extensionFacade.portTypeOperationInputElements(wSDLInputImpl, xMLStreamReader);
        }
    }

    private void parsePortTypeOperationOutput(XMLStreamReader xMLStreamReader, WSDLOperationImpl wSDLOperationImpl) {
        String string = ParserUtil.getAttribute(xMLStreamReader, "message");
        QName qName = ParserUtil.getQName(xMLStreamReader, string);
        String string2 = ParserUtil.getAttribute(xMLStreamReader, "name");
        WSDLOutputImpl wSDLOutputImpl = new WSDLOutputImpl(xMLStreamReader, string2, qName, wSDLOperationImpl);
        wSDLOperationImpl.setOutput(wSDLOutputImpl);
        this.extensionFacade.portTypeOperationOutputAttributes(wSDLOutputImpl, xMLStreamReader);
        this.extensionFacade.portTypeOperationOutput(wSDLOperationImpl, xMLStreamReader);
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            this.extensionFacade.portTypeOperationOutputElements(wSDLOutputImpl, xMLStreamReader);
        }
    }

    private void parseMessage(XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
        WSDLMessageImpl wSDLMessageImpl = new WSDLMessageImpl(xMLStreamReader, new QName(this.targetNamespace, string));
        this.extensionFacade.messageAttributes(wSDLMessageImpl, xMLStreamReader);
        int n = 0;
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            QName qName = xMLStreamReader.getName();
            if (WSDLConstants.QNAME_PART.equals(qName)) {
                String string2 = ParserUtil.getMandatoryNonEmptyAttribute(xMLStreamReader, "name");
                String string3 = null;
                int n2 = xMLStreamReader.getAttributeCount();
                WSDLDescriptorKind wSDLDescriptorKind = WSDLDescriptorKind.ELEMENT;
                for (int i = 0; i < n2; ++i) {
                    QName qName2 = xMLStreamReader.getAttributeName(i);
                    if (qName2.getLocalPart().equals("element")) {
                        wSDLDescriptorKind = WSDLDescriptorKind.ELEMENT;
                    } else if (qName2.getLocalPart().equals("TYPE")) {
                        wSDLDescriptorKind = WSDLDescriptorKind.TYPE;
                    }
                    if (!qName2.getLocalPart().equals("element") && !qName2.getLocalPart().equals("type")) continue;
                    string3 = xMLStreamReader.getAttributeValue(i);
                    break;
                }
                if (string3 != null) {
                    WSDLPartImpl wSDLPartImpl = new WSDLPartImpl(xMLStreamReader, string2, n, new WSDLPartDescriptorImpl(xMLStreamReader, ParserUtil.getQName(xMLStreamReader, string3), wSDLDescriptorKind));
                    wSDLMessageImpl.add(wSDLPartImpl);
                }
                if (xMLStreamReader.getEventType() == 2) continue;
                RuntimeWSDLParser.goToEnd(xMLStreamReader);
                continue;
            }
            this.extensionFacade.messageElements(wSDLMessageImpl, xMLStreamReader);
        }
        this.wsdlDoc.addMessage(wSDLMessageImpl);
        if (xMLStreamReader.getEventType() != 2) {
            RuntimeWSDLParser.goToEnd(xMLStreamReader);
        }
    }

    private static void goToEnd(XMLStreamReader xMLStreamReader) {
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
        }
    }

    private static XMLStreamReader createReader(URL uRL) throws IOException, XMLStreamException {
        try {
            FilterInputStream filterInputStream = new FilterInputStream(uRL.openStream()){
                boolean closed;

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        this.closed = true;
                        byte[] byArray = new byte[8192];
                        while (this.read(byArray) != -1) {
                        }
                        super.close();
                    }
                }
            };
            return new TidyXMLStreamReader(XMLStreamReaderFactory.create(uRL.toExternalForm(), filterInputStream, false), filterInputStream);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Got " + iOException.getMessage() + " while opening stream from " + uRL).initCause(iOException);
        }
    }

    private void register(WSDLParserExtension wSDLParserExtension) {
        this.extensions.add(new FoolProofParserExtension(wSDLParserExtension));
    }

    private static enum BindingMode {
        INPUT,
        OUTPUT,
        FAULT;

    }
}

