/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.DebugCMS;
import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateSet;
import iaik.cms.ContentInfo;
import iaik.cms.SignedData;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.cert.Certificate;

public class CMSCertList
implements Serializable {
    private SignedData a;
    private static boolean b = DebugCMS.getDebugMode() && b;

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo((ASN1Object)new ContentInfo(this.a).toASN1Object(), (OutputStream)outputStream);
            return;
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.write(this.toByteArray());
            return;
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public String toString() {
        return this.a.toString();
    }

    public byte[] toByteArray() throws CMSException {
        return new ContentInfo(this.a).toByteArray();
    }

    public void setCertificateList(Certificate[] certificateArray) {
        this.a.setCertificates(certificateArray);
    }

    public void setCertificateList(CertificateSet certificateSet) {
        this.a.setCertificateSet(certificateSet);
    }

    public void setCRLList(X509CRL[] x509CRLArray) {
        this.a.setCRLs(x509CRLArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        try {
            ContentInfo contentInfo = new ContentInfo(objectInputStream);
            this.a = (SignedData)contentInfo.getContent();
            return;
        }
        catch (CMSParsingException cMSParsingException) {
            throw new IOException(cMSParsingException.toString());
        }
    }

    public X509Certificate[] getX509Certificates() {
        return this.a.getX509Certificates();
    }

    public CertificateSet getCertificateSet() {
        return this.a.getCertificateSet();
    }

    public Certificate[] getCertificateList() {
        return this.a.getCertificates();
    }

    public X509CRL[] getCRLList() {
        return this.a.getCRLs();
    }

    public AttributeCertificate[] getAttributeCertificates() {
        return this.a.getAttributeCertificates();
    }

    public CMSCertList(InputStream inputStream) throws CMSParsingException, IOException {
        ContentInfo contentInfo = new ContentInfo(inputStream);
        this.a = (SignedData)contentInfo.getContent();
    }

    public CMSCertList() {
        this.a = new SignedData(ObjectID.cms_data);
    }
}

