/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.DebugCMS;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.cms.IssuerAndSerialNumber;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.attr.V1Form;
import iaik.x509.attr.V2Form;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class ESSIssuerSerial {
    private BigInteger a;
    private GeneralNames b;
    private static boolean c = DebugCMS.getDebugMode() && c;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SerialNumber: " + this.a + "\n");
        stringBuffer.append("Issuer: " + this.b + "\n");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.a));
        }
        catch (CodingException codingException) {
            throw new InternalErrorException((Exception)((Object)codingException));
        }
        return sEQUENCE;
    }

    private void a(X509Certificate x509Certificate) {
        GeneralName generalName = new GeneralName(4, (Object)((Name)x509Certificate.getIssuerDN()));
        this.b = new GeneralNames(generalName);
        this.a = x509Certificate.getSerialNumber();
    }

    private void a(AttributeCertificate attributeCertificate) throws CertificateException {
        AttCertIssuer attCertIssuer = attributeCertificate.getIssuer();
        if (attCertIssuer.getVForm() == 1) {
            this.b = ((V1Form)attCertIssuer).getGeneralNames();
        } else {
            V2Form v2Form = (V2Form)attCertIssuer;
            GeneralNames generalNames = v2Form.getIssuerName();
            if (generalNames != null) {
                this.b = generalNames;
            } else {
                throw new CertificateException("Cannot create IssuerSerial from given attribute certificate: insufficient issuer information!");
            }
        }
        this.a = attributeCertificate.getSerialNumber();
    }

    public boolean identifiesCert(Certificate certificate) {
        try {
            return this.equals(new ESSIssuerSerial(certificate));
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public int hashCode() {
        return this.b.hashCode() + this.a.hashCode();
    }

    public BigInteger getSerialNumber() {
        return this.a;
    }

    public GeneralNames getIssuer() {
        return this.b;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof ESSIssuerSerial) {
            ESSIssuerSerial eSSIssuerSerial = (ESSIssuerSerial)object;
            bl = this.b.equals((Object)eSSIssuerSerial.b) && this.a.compareTo(eSSIssuerSerial.a) == 0;
        }
        return bl;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = new GeneralNames(aSN1Object.getComponentAt(0));
        this.a = (BigInteger)aSN1Object.getComponentAt(1).getValue();
    }

    public ESSIssuerSerial(Certificate certificate) throws CertificateException {
        if (certificate instanceof X509Certificate) {
            this.a((X509Certificate)certificate);
            return;
        }
        if (certificate instanceof AttributeCertificate) {
            this.a((AttributeCertificate)certificate);
            return;
        }
        throw new IllegalArgumentException("Only iaik.x509.X509Certificate and iaik.x509.attr.AttributeCertificate objects are allowed!");
    }

    public ESSIssuerSerial(IssuerAndSerialNumber issuerAndSerialNumber) {
        this(issuerAndSerialNumber.getIssuer(), issuerAndSerialNumber.getSerialNumber());
    }

    public ESSIssuerSerial(Name name, BigInteger bigInteger) {
        if (name == null) {
            throw new NullPointerException("Issuer must not be null!");
        }
        if (bigInteger == null) {
            throw new NullPointerException("SerialNumber must not be null!");
        }
        GeneralName generalName = new GeneralName(4, (Object)name);
        this.b = new GeneralNames(generalName);
        this.a = bigInteger;
    }

    public ESSIssuerSerial(GeneralNames generalNames, BigInteger bigInteger) {
        if (generalNames == null) {
            throw new NullPointerException("Issuer must not be null!");
        }
        if (bigInteger == null) {
            throw new NullPointerException("SerialNumber must not be null!");
        }
        this.b = generalNames;
        this.a = bigInteger;
    }

    public ESSIssuerSerial(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("ASN.1 object must not be null!");
        }
        this.decode(aSN1Object);
    }
}

