/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.keyinfo.KeyValueType;
import iaik.xml.crypto.utils.DOMUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSAKeyValueImpl
extends KeyValueType {
    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Object object;
        if (nodeList == null) {
            return;
        }
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object.getNodeType() == 1 && object.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
                if (object.getLocalName().equals("Modulus")) {
                    bigInteger = new BigInteger(1, DOMStructure.getBytesFromElement((Element)object));
                } else if (object.getLocalName().equals("Exponent")) {
                    bigInteger2 = new BigInteger(1, DOMStructure.getBytesFromElement((Element)object));
                }
            }
            ++n;
        }
        object = new RSAPublicKeySpec(bigInteger, bigInteger2);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.publicKey_ = (RSAPublicKey)keyFactory.generatePublic((KeySpec)object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException("Failed to create RSA key.");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new MarshalException("Failed to create RSA key.");
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dOMCryptoContext.getDefaultNamespacePrefix());
        RSAPublicKey rSAPublicKey = (RSAPublicKey)this.publicKey_;
        BigInteger bigInteger = rSAPublicKey.getModulus();
        BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DOMStructure.getQualifiedName(string, "Modulus"));
        Element element2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", DOMStructure.getQualifiedName(string, "Exponent"));
        DOMStructure.addBytesToElement(element, DOMUtils.bigInteger2byteArray(bigInteger), dOMCryptoContext);
        DOMStructure.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger2), dOMCryptoContext);
        node3.appendChild(element);
        node3.appendChild(element2);
        return node3;
    }

    public String getLocalName() {
        return "RSAKeyValue";
    }

    public RSAKeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.publicKey_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public RSAKeyValueImpl(RSAPublicKey rSAPublicKey) {
        super(rSAPublicKey);
    }
}

