/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.ecdsa;

import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.security.ecc.ECCException;
import iaik.security.ecc.interfaces.ECDSAParams;
import iaik.security.ecc.math.ecgroup.AffineCoordinate;
import iaik.security.ecc.math.ecgroup.CoordinateTypes;
import iaik.security.ecc.math.ecgroup.ECGroupFactory;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.field.BinaryFieldFactory;
import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.FieldFactory;
import iaik.security.ecc.math.field.PrimeFieldFactory;
import iaik.security.ecc.spec.ECCParameterSpec;
import java.math.BigInteger;
import java.security.InvalidParameterException;

public class ECDSAParameter
implements ECDSAParams {
    protected BigInteger s_;
    protected BigInteger r_;
    protected String oid_;
    protected BigInteger k_;
    protected ECPoint g_;
    protected BigInteger c_;
    protected static boolean DEFAULT_OID_ENCODING;
    public static final INTEGER ECDSA_PARAMETER_VERSION;

    static {
        ECDSA_PARAMETER_VERSION = new INTEGER(1);
        DEFAULT_OID_ENCODING = false;
    }

    public String toString() {
        return "BasePoint: " + this.g_.toString() + "\nOrder: " + this.r_.toString() + "\nCurve: " + this.g_.getCurve().toString();
    }

    public ASN1Object toASN1Object() {
        if (DEFAULT_OID_ENCODING && this.oid_ != null) {
            return new ObjectID(this.oid_);
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)ECDSA_PARAMETER_VERSION);
        sEQUENCE.addComponent(this.g_.getCurve().getField().toASN1Object());
        sEQUENCE.addComponent(this.g_.getCurve().toASN1Object());
        sEQUENCE.addComponent((ASN1Object)this.g_.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.r_));
        if (this.k_ != null) {
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.k_));
        }
        return sEQUENCE;
    }

    public int hashCode() {
        return this.g_.hashCode() + this.r_.hashCode();
    }

    public BigInteger getS() {
        return this.s_;
    }

    public BigInteger getR() {
        return this.r_;
    }

    public String getOID() {
        return this.oid_;
    }

    public BigInteger getK() {
        return this.k_;
    }

    public ECPoint getG() {
        return (ECPoint)this.g_.clone();
    }

    public BigInteger getC() {
        return this.c_;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ECDSAParameter)) {
            return false;
        }
        ECDSAParameter eCDSAParameter = (ECDSAParameter)object;
        return this.g_.equals(eCDSAParameter.getG()) && this.r_.equals(eCDSAParameter.getR());
    }

    ECDSAParameter(ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this.g_ = eCPoint;
        this.r_ = bigInteger;
        this.k_ = bigInteger2;
    }

    ECDSAParameter(ECPoint eCPoint, BigInteger bigInteger) {
        this.g_ = eCPoint;
        this.r_ = bigInteger;
    }

    ECDSAParameter(ECDSAParams eCDSAParams) {
        this.g_ = eCDSAParams.getG();
        this.r_ = eCDSAParams.getR();
        this.k_ = eCDSAParams.getK();
        this.oid_ = eCDSAParams.getOID();
    }

    ECDSAParameter(ASN1Object aSN1Object) throws InvalidParameterException {
        try {
            Object object;
            Object object2;
            Field field;
            Object object3;
            BigInteger bigInteger;
            int n = aSN1Object.countComponents();
            if (n < 5) {
                throw new InvalidParameterException("Invalid ECDSA Domain Parameters");
            }
            BigInteger bigInteger2 = (BigInteger)aSN1Object.getComponentAt(0).getValue();
            if (!bigInteger2.equals(ECDSA_PARAMETER_VERSION.getValue())) {
                throw new InvalidParameterException("No ECDSA Domain Parameter: wrong parameter version");
            }
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object.getComponentAt(1);
            if (sEQUENCE.getComponentAt(0).equals(new ObjectID("1.2.840.10045.1.1"))) {
                bigInteger = (BigInteger)sEQUENCE.getComponentAt(1).getValue();
                object3 = PrimeFieldFactory.getInstance(bigInteger);
                field = object3.getField();
            } else if (sEQUENCE.getComponentAt(0).equals(new ObjectID("1.2.840.10045.1.2"))) {
                bigInteger = (SEQUENCE)sEQUENCE.getComponentAt(1);
                object3 = (BigInteger)bigInteger.getComponentAt(0).getValue();
                object2 = (ObjectID)bigInteger.getComponentAt(1);
                if (object2.equals((Object)"1.2.840.10045.1.2.3.1")) {
                    throw new InvalidParameterException("GNB base representations not supported");
                }
                if (object2.equals((Object)new ObjectID("1.2.840.10045.1.2.3.2"))) {
                    object = new BigInteger[]{(BigInteger)bigInteger.getComponentAt(2).getValue()};
                } else if (object2.equals((Object)new ObjectID("1.2.840.10045.1.2.3.3"))) {
                    object = new BigInteger[3];
                    SEQUENCE sEQUENCE2 = (SEQUENCE)bigInteger.getComponentAt(2);
                    object[0] = (BigInteger)sEQUENCE2.getComponentAt(0).getValue();
                    object[1] = (BigInteger)sEQUENCE2.getComponentAt(1).getValue();
                    object[2] = (BigInteger)sEQUENCE2.getComponentAt(2).getValue();
                } else {
                    throw new InvalidParameterException("unknown base representation");
                }
                int n2 = ((BigInteger)object3).intValue() + 1;
                int n3 = n2 >>> 5;
                int n4 = n2 & 0x1F;
                int[] nArray = n4 != 0 ? new int[n3 + 1] : new int[n3];
                nArray[0] = 1;
                if (--n4 < 0) {
                    n4 = 31;
                }
                int n5 = nArray.length - 1;
                nArray[n5] = nArray[n5] | 1 << n4;
                int n6 = 0;
                while (n6 < ((BigInteger[])object).length) {
                    int n7 = object[n6].intValue() + 1;
                    n3 = n7 >>> 5;
                    n4 = n7 & 0x1F;
                    if (--n4 < 0) {
                        n4 = 31;
                    }
                    int n8 = n3;
                    nArray[n8] = nArray[n8] | 1 << n4;
                    ++n6;
                }
                FieldFactory fieldFactory = BinaryFieldFactory.getInstance(nArray);
                field = fieldFactory.getField();
            } else {
                throw new InvalidParameterException("Unknown field oid");
            }
            this.k_ = n == 6 ? (BigInteger)aSN1Object.getComponentAt(5).getValue() : null;
            bigInteger = (SEQUENCE)aSN1Object.getComponentAt(2);
            object3 = (OCTET_STRING)bigInteger.getComponentAt(0);
            object2 = field.newElement((byte[])object3.getValue());
            object3 = (OCTET_STRING)bigInteger.getComponentAt(1);
            object = field.newElement((byte[])object3.getValue());
            ECGroupFactory eCGroupFactory = ECGroupFactory.getInstance();
            EllipticCurve ellipticCurve = eCGroupFactory.getDefault((FieldElement)object2, (FieldElement)object, null);
            OCTET_STRING oCTET_STRING = (OCTET_STRING)aSN1Object.getComponentAt(3);
            this.g_ = new ECPoint((byte[])oCTET_STRING.getValue(), ellipticCurve);
            if (ellipticCurve.isPrecomputationEnabled()) {
                ((ECPoint)this.g_.clone()).precomputePoints();
            }
            this.r_ = (BigInteger)aSN1Object.getComponentAt(4).getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidParameterException("Invalid ECDSA domain parameters" + exception);
        }
    }

    protected ECDSAParameter() {
    }

    public ECDSAParameter(ECCParameterSpec eCCParameterSpec, int n) throws ECCException {
        if (eCCParameterSpec == null) {
            throw new ECCException("ECCException.1");
        }
        this.r_ = eCCParameterSpec.getR();
        this.k_ = eCCParameterSpec.getK();
        this.oid_ = eCCParameterSpec.getOID();
        ECGroupFactory eCGroupFactory = ECGroupFactory.getInstance();
        EllipticCurve ellipticCurve = eCGroupFactory.getCurve(eCCParameterSpec.getA(), eCCParameterSpec.getB(), this.r_, n);
        AffineCoordinate affineCoordinate = new AffineCoordinate(eCCParameterSpec.getGx(), eCCParameterSpec.getGy());
        this.g_ = ellipticCurve.newPoint(affineCoordinate);
        if (ellipticCurve.isPrecomputationEnabled()) {
            ((ECPoint)this.g_.clone()).precomputePoints();
        }
    }

    public ECDSAParameter(ECCParameterSpec eCCParameterSpec) throws ECCException {
        this(eCCParameterSpec, CoordinateTypes.getDefaultCoordinates(eCCParameterSpec.getA().getField().getFieldId()));
    }

    public static void setDefaultOIDEncoding(boolean bl) {
        DEFAULT_OID_ENCODING = bl;
    }

    public static boolean getDefaultOIDEncoding() {
        return DEFAULT_OID_ENCODING;
    }
}

