/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.ecgroup;

import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.ecgroup.EllipticCurveImpl;
import iaik.security.ecc.math.ecgroup.ProjectiveCoordinate;
import iaik.security.ecc.math.field.Constants;
import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.PrimeField;
import java.math.BigInteger;

class PrimeProjectiveCurve
extends EllipticCurveImpl {
    protected final FieldElement eight_;
    protected final FieldElement four_;
    protected final FieldElement three_;
    protected final FieldElement two_;

    public boolean useAffine() {
        return false;
    }

    public Field getField() {
        return this.field_;
    }

    public void multiply(ECPoint eCPoint, BigInteger bigInteger) {
        if (this.order_ != null && bigInteger.compareTo(this.order_) >= 0) {
            bigInteger = bigInteger.mod(this.order_);
        }
        ECPoint eCPoint2 = (ECPoint)eCPoint.clone();
        switch (bigInteger.signum()) {
            case 0: {
                eCPoint.setInfinity();
            }
            case -1: {
                bigInteger = bigInteger.negate();
                eCPoint.invert();
            }
            case 1: {
                eCPoint2.invert();
            }
        }
        ECPoint eCPoint3 = (ECPoint)eCPoint.clone();
        BigInteger bigInteger2 = bigInteger.multiply(Constants.BIG_THREE);
        int n = bigInteger2.bitLength() - 2;
        while (n > 0) {
            eCPoint3.doublePoint();
            if (bigInteger2.testBit(n) && !bigInteger.testBit(n)) {
                eCPoint3.addPoint(eCPoint);
            }
            if (!bigInteger2.testBit(n) && bigInteger.testBit(n)) {
                eCPoint3.addPoint(eCPoint2);
            }
            --n;
        }
        if (eCPoint3.isInfinity()) {
            eCPoint.setInfinity();
        } else {
            ProjectiveCoordinate projectiveCoordinate = (ProjectiveCoordinate)eCPoint3.getCoordinates();
            ProjectiveCoordinate projectiveCoordinate2 = (ProjectiveCoordinate)eCPoint.getCoordinates();
            eCPoint.getCoordinates().setX(eCPoint3.getCoordinates().getX());
            eCPoint.getCoordinates().setY(eCPoint3.getCoordinates().getY());
            projectiveCoordinate2.setZ(projectiveCoordinate.getZ());
        }
    }

    public void invert(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return;
        }
        eCPoint.getCoordinates().setY(eCPoint.getCoordinates().getY().negate());
    }

    public void addPoint(ECPoint eCPoint, ECPoint eCPoint2) {
        if (eCPoint2.equals(eCPoint)) {
            if (eCPoint.isInfinity()) {
                return;
            }
            eCPoint.doublePoint();
            return;
        }
        if (eCPoint.isInfinity()) {
            Coordinate coordinate = (Coordinate)eCPoint2.getCoordinates().clone();
            eCPoint.setCoordinates(coordinate);
            eCPoint.unsetInfinity();
            return;
        }
        FieldElement fieldElement = (FieldElement)eCPoint.getCoordinates().getX().clone();
        FieldElement fieldElement2 = (FieldElement)eCPoint.getCoordinates().getY().clone();
        FieldElement fieldElement3 = (FieldElement)((ProjectiveCoordinate)eCPoint.getCoordinates()).getZ().clone();
        FieldElement fieldElement4 = (FieldElement)eCPoint2.getCoordinates().getX().clone();
        FieldElement fieldElement5 = (FieldElement)eCPoint2.getCoordinates().getY().clone();
        FieldElement fieldElement6 = null;
        FieldElement fieldElement7 = null;
        if (!((ProjectiveCoordinate)eCPoint2.getCoordinates()).getZ().isOne()) {
            fieldElement6 = (FieldElement)((ProjectiveCoordinate)eCPoint2.getCoordinates()).getZ().clone();
            fieldElement7 = FieldElement.square(fieldElement6);
            fieldElement = fieldElement.multiply(fieldElement7);
            fieldElement7 = fieldElement7.multiply(fieldElement6);
            fieldElement2 = fieldElement2.multiply(fieldElement7);
        }
        fieldElement7 = FieldElement.square(fieldElement3);
        fieldElement4 = fieldElement4.multiply(fieldElement7);
        fieldElement7 = fieldElement7.multiply(fieldElement3);
        fieldElement5 = fieldElement5.multiply(fieldElement7);
        fieldElement4 = FieldElement.sub(fieldElement, fieldElement4);
        fieldElement5 = FieldElement.sub(fieldElement2, fieldElement5);
        if (fieldElement4.isZero()) {
            eCPoint.setInfinity();
            return;
        }
        fieldElement = fieldElement.multiply(this.two_).sub(fieldElement4);
        fieldElement2 = fieldElement2.multiply(this.two_).sub(fieldElement5);
        if (!((ProjectiveCoordinate)eCPoint2.getCoordinates()).getZ().isOne()) {
            fieldElement3 = fieldElement3.multiply(fieldElement6);
        }
        fieldElement3 = fieldElement3.multiply(fieldElement4);
        fieldElement7 = FieldElement.square(fieldElement4);
        fieldElement4 = fieldElement4.multiply(fieldElement7);
        fieldElement7 = fieldElement7.multiply(fieldElement);
        fieldElement = FieldElement.square(fieldElement5);
        fieldElement = fieldElement.sub(fieldElement7);
        fieldElement7 = fieldElement7.sub(FieldElement.multiply(fieldElement, this.two_));
        fieldElement5 = fieldElement5.multiply(fieldElement7);
        fieldElement4 = fieldElement4.multiply(fieldElement2);
        fieldElement2 = FieldElement.sub(fieldElement5, fieldElement4);
        fieldElement2 = fieldElement2.divide(this.two_);
        eCPoint.getCoordinates().setX(fieldElement);
        eCPoint.getCoordinates().setY(fieldElement2);
        ((ProjectiveCoordinate)eCPoint.getCoordinates()).setZ(fieldElement3);
    }

    public void doublePoint(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return;
        }
        FieldElement fieldElement = (FieldElement)eCPoint.getCoordinates().getX().clone();
        FieldElement fieldElement2 = (FieldElement)eCPoint.getCoordinates().getY().clone();
        FieldElement fieldElement3 = (FieldElement)((ProjectiveCoordinate)eCPoint.getCoordinates()).getZ().clone();
        FieldElement fieldElement4 = (FieldElement)eCPoint.getCoordinates().getX().clone();
        FieldElement fieldElement5 = (FieldElement)eCPoint.getCoordinates().getX().clone();
        FieldElement fieldElement6 = ((PrimeField)this.field_).newElement(this.a_.getField().getSize());
        if (this.a_.equals(fieldElement6.sub(this.three_))) {
            fieldElement4 = FieldElement.square(fieldElement3);
            fieldElement5 = FieldElement.sub(fieldElement, fieldElement4);
            fieldElement4 = fieldElement4.add(fieldElement);
            fieldElement5 = fieldElement5.multiply(fieldElement4);
            fieldElement4 = FieldElement.multiply(fieldElement5, this.three_);
        } else {
            fieldElement4 = this.a_;
            fieldElement5 = FieldElement.square(fieldElement3);
            fieldElement5 = fieldElement5.square();
            fieldElement5 = fieldElement5.multiply(fieldElement4);
            fieldElement4 = FieldElement.square(fieldElement);
            fieldElement4 = fieldElement4.multiply(this.three_);
            fieldElement4 = fieldElement4.add(fieldElement5);
        }
        fieldElement3 = fieldElement3.multiply(fieldElement2);
        fieldElement3 = fieldElement3.multiply(this.two_);
        fieldElement2 = fieldElement2.square();
        fieldElement5 = FieldElement.multiply(fieldElement, fieldElement2);
        fieldElement5 = fieldElement5.multiply(this.four_);
        fieldElement = FieldElement.square(fieldElement4);
        fieldElement = fieldElement.sub(FieldElement.multiply(fieldElement5, this.two_));
        fieldElement2 = fieldElement2.square();
        fieldElement2 = fieldElement2.multiply(this.eight_);
        fieldElement5 = fieldElement5.sub(fieldElement);
        fieldElement5 = fieldElement5.multiply(fieldElement4);
        fieldElement2 = FieldElement.sub(fieldElement5, fieldElement2);
        eCPoint.getCoordinates().setX(fieldElement);
        eCPoint.getCoordinates().setY(fieldElement2);
        ((ProjectiveCoordinate)eCPoint.getCoordinates()).setZ(fieldElement3);
    }

    PrimeProjectiveCurve(FieldElement fieldElement, FieldElement fieldElement2, BigInteger bigInteger) {
        this.a_ = fieldElement;
        this.b_ = fieldElement2;
        this.field_ = fieldElement.getField();
        this.order_ = bigInteger;
        this.two_ = ((PrimeField)this.field_).newElement(Constants.BIG_TWO);
        this.three_ = ((PrimeField)this.field_).newElement(Constants.BIG_THREE);
        this.four_ = ((PrimeField)this.field_).newElement(Constants.BIG_FOUR);
        this.eight_ = ((PrimeField)this.field_).newElement(Constants.BIG_EIGHT);
    }
}

