/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.util;

import iaik.security.ecc.ECCException;
import iaik.security.ecc.math.ecgroup.AffineCoordinate;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.util.PointCoDec;
import iaik.security.ecc.util.PointCompressor;
import iaik.security.ecc.util.Utils;

public class PointCoDecImpl
implements PointCoDec {
    protected boolean verifyOnCurve_ = false;
    protected int supportedCompressions_;
    protected PointCompressor decompressor_ = null;

    protected AffineCoordinate uncompressed(byte[] byArray, EllipticCurve ellipticCurve) throws ECCException {
        if ((byArray.length - 1) % 2 != 0) {
            throw new ECCException("Invalid encoded EC point");
        }
        int n = (byArray.length - 1) / 2;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        System.arraycopy(byArray, 1 + n, byArray3, 0, byArray2.length);
        FieldElement fieldElement = ellipticCurve.getField().newElement(byArray2);
        FieldElement fieldElement2 = ellipticCurve.getField().newElement(byArray3);
        return new AffineCoordinate(fieldElement, fieldElement2);
    }

    protected AffineCoordinate compressed(byte[] byArray, EllipticCurve ellipticCurve) throws ECCException {
        if (this.decompressor_ == null) {
            throw new ECCException("Cannot decode compressed point (point compression not enabled)");
        }
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        FieldElement fieldElement = ellipticCurve.getField().newElement(byArray2);
        int n = 0;
        if ((byArray[0] & 1) != 0) {
            n = 1;
        }
        return this.decompressor_.decompress(fieldElement, n, ellipticCurve);
    }

    public void setVerifyPoint(boolean bl) {
        this.verifyOnCurve_ = bl;
    }

    public boolean getVerifyPoint() {
        return this.verifyOnCurve_;
    }

    public int getSupportedCompressions() {
        return this.supportedCompressions_;
    }

    public byte[] encodePoint(AffineCoordinate affineCoordinate, int n) throws ECCException {
        if ((n & 1) != 0) {
            byte[] byArray = affineCoordinate.getX().toByteArray();
            byte[] byArray2 = affineCoordinate.getY().toByteArray();
            byte[] byArray3 = new byte[1 + byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, 1 + byArray.length, byArray2.length);
            byArray3[0] = 4;
            return byArray3;
        }
        if ((n & this.supportedCompressions_) != 0) {
            if (this.decompressor_ == null) {
                throw new ECCException("Cannot  compress point (point compression not enabled)");
            }
            return this.decompressor_.compress(affineCoordinate.getX(), affineCoordinate.getY());
        }
        throw new ECCException("Point compression not supported");
    }

    public AffineCoordinate decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws ECCException {
        AffineCoordinate affineCoordinate = null;
        if ((byArray[0] & 4) != 0) {
            affineCoordinate = this.uncompressed(byArray, ellipticCurve);
        } else if ((byArray[0] & 2) != 0) {
            affineCoordinate = this.compressed(byArray, ellipticCurve);
        } else {
            if (byArray[0] == 0) {
                return null;
            }
            throw new ECCException("Invalid encoded EC Point");
        }
        if (this.verifyOnCurve_ && !Utils.isOnCurve(ellipticCurve.newPoint(affineCoordinate))) {
            throw new ECCException("decoded point is not on the curve");
        }
        return affineCoordinate;
    }

    protected PointCoDecImpl() {
        PointCompressor pointCompressor = Utils.getPointCompression();
        if (pointCompressor != null) {
            this.decompressor_ = pointCompressor;
            this.supportedCompressions_ = 3;
        } else {
            this.supportedCompressions_ = 1;
        }
    }
}

