/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.util;

import iaik.ecc.com.fourthpass.a;
import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.util.CompressorImpl;
import iaik.security.ecc.util.PointCompressor;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class Utils {
    static /* synthetic */ Class class$iaik$security$ecc$util$Utils;
    private static CompressorImpl compressorImpl;
    private static Boolean useSpeedUps;
    private static String COMPRESSORIMPL_CLASS;
    private static String FASTPRIMECURVE_CLASS;

    static {
        FASTPRIMECURVE_CLASS = "iaik.security.ecc.math.ecgroup.FastPrimeCurve";
        COMPRESSORIMPL_CLASS = "iaik.security.ecc.util.CompressorImpl";
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void setSpeedUpsEnabled(boolean bl) {
        useSpeedUps = new Boolean(bl);
    }

    private static boolean isOnPrimeCurve(ECPoint eCPoint) {
        EllipticCurve ellipticCurve = eCPoint.getCurve();
        Coordinate coordinate = eCPoint.getCoordinates().toAffine();
        FieldElement fieldElement = coordinate.getX();
        FieldElement fieldElement2 = coordinate.getY();
        fieldElement2.square();
        FieldElement fieldElement3 = (FieldElement)fieldElement.clone();
        fieldElement.square().multiply(fieldElement3);
        fieldElement3.multiply(ellipticCurve.getA()).add(ellipticCurve.getB()).add(fieldElement);
        return fieldElement3.equals(fieldElement2);
    }

    private static boolean isOnBinaryCurve(ECPoint eCPoint) {
        EllipticCurve ellipticCurve = eCPoint.getCurve();
        Coordinate coordinate = eCPoint.getCoordinates().toAffine();
        FieldElement fieldElement = coordinate.getX();
        FieldElement fieldElement2 = coordinate.getY();
        FieldElement fieldElement3 = FieldElement.square(fieldElement2);
        fieldElement3.add(fieldElement2.multiply(fieldElement));
        FieldElement fieldElement4 = FieldElement.square(fieldElement);
        fieldElement.multiply(fieldElement4);
        fieldElement4.multiply(ellipticCurve.getA()).add(ellipticCurve.getB());
        fieldElement.add(fieldElement4);
        return fieldElement3.equals(fieldElement);
    }

    public static PointCompressor getPointCompression() {
        if (useSpeedUps == null) {
            try {
                Class<?> clazz;
                ClassLoader classLoader = (class$iaik$security$ecc$util$Utils == null ? (class$iaik$security$ecc$util$Utils = Utils.class$("iaik.security.ecc.util.Utils")) : class$iaik$security$ecc$util$Utils).getClassLoader();
                Class<?> clazz2 = clazz = classLoader != null ? classLoader.loadClass(COMPRESSORIMPL_CLASS) : a.a(COMPRESSORIMPL_CLASS);
                if (clazz != null) {
                    useSpeedUps = Boolean.TRUE;
                    compressorImpl = (CompressorImpl)clazz.newInstance();
                } else {
                    useSpeedUps = Boolean.FALSE;
                }
            }
            catch (Exception exception) {
                useSpeedUps = Boolean.FALSE;
            }
        }
        if (useSpeedUps.booleanValue() && compressorImpl == null) {
            compressorImpl = new CompressorImpl();
        }
        return compressorImpl;
    }

    public static boolean isSpeedUpEnabled() {
        block3: {
            if (useSpeedUps != null) break block3;
            try {
                Class<?> clazz;
                ClassLoader classLoader = (class$iaik$security$ecc$util$Utils == null ? (class$iaik$security$ecc$util$Utils = Utils.class$("iaik.security.ecc.util.Utils")) : class$iaik$security$ecc$util$Utils).getClassLoader();
                Class<?> clazz2 = clazz = classLoader != null ? classLoader.loadClass(FASTPRIMECURVE_CLASS) : a.a(FASTPRIMECURVE_CLASS);
                if (clazz != null) {
                    useSpeedUps = Boolean.TRUE;
                    break block3;
                }
                useSpeedUps = Boolean.FALSE;
            }
            catch (Exception exception) {
                useSpeedUps = Boolean.FALSE;
            }
        }
        return useSpeedUps;
    }

    public static boolean orderCheck(ECPoint eCPoint, BigInteger bigInteger) {
        ECPoint eCPoint2 = (ECPoint)eCPoint.clone();
        eCPoint2.multiply(bigInteger);
        return eCPoint2.isInfinity();
    }

    public static boolean isOnCurve(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return true;
        }
        if (eCPoint.getCurve().getField().getFieldId() == 1) {
            return Utils.isOnPrimeCurve((ECPoint)eCPoint.clone());
        }
        if (eCPoint.getCurve().getField().getFieldId() == 2) {
            return Utils.isOnBinaryCurve((ECPoint)eCPoint.clone());
        }
        return false;
    }

    public static Set toSet(Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < objectArray.length) {
            hashSet.add(objectArray[n]);
            ++n;
        }
        return hashSet;
    }

    public static boolean equalsBlock(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        return Utils.equalsBlock(nArray, 0, nArray2, 0, nArray.length);
    }

    public static boolean equalsBlock(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n + n4] != nArray2[n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }
}

