/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.posizione;

import finanze.IDTE.studi2002.generale.IConst;
import finanze.IDTE.studi2002.generale.MetodiUtili;
import finanze.IDTE.studi2002.posizione.GestoreFornituraAS;
import finanze.IDTE.studi2002.posizione.Multiposizione;
import finanze.IDTE.studi2002.posizione.StrutturaMultiposizione;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class FornituraAS {
    private Vector messaggio = null;
    private GestoreFornituraAS gf = null;
    private static String path = new File(" ").getAbsolutePath().trim();
    private boolean elabora;
    private boolean memorizza;
    public Vector messaggiErrore = null;
    private boolean calcolato = false;
    private boolean salvato = false;
    private boolean gericOut = false;
    private String newPath = null;
    private Vector informazioni = null;
    private String[] info = null;
    private Vector datiGlobali;
    private Riepilogo[] riepilogo = null;
    private Vector multiposizione = null;

    public FornituraAS(Vector multiposizione) {
        this.multiposizione = multiposizione;
        this.messaggio = new Vector();
        this.messaggiErrore = new Vector();
        this.initialize();
    }

    public Vector getAnomalie() {
        return this.messaggio;
    }

    public Vector getDatiGlobali() {
        return this.datiGlobali;
    }

    public Vector getInformazioni() {
        return this.informazioni;
    }

    public Vector getMessaggiErrore() {
        return this.messaggiErrore;
    }

    public Vector getMessaggio() {
        return this.messaggio;
    }

    public static String getPath() {
        return path.substring(0, path.lastIndexOf(System.getProperty("file.separator")) + 1);
    }

    private void impostaMessaggi() {
        StringTokenizer st = new StringTokenizer(this.messaggio.toString(), System.getProperty("line.separator"));
        this.messaggiErrore.addElement("E");
        String riga = "";
        while (st.hasMoreTokens()) {
            riga = st.nextToken();
            this.messaggiErrore.addElement(riga);
        }
    }

    private void initialize() {
        byte[] dati = MetodiUtili.stringToByteConverter(this.multiposizione);
        this.gf = new GestoreFornituraAS(dati);
        this.run();
        if (this.gf.getMessaggioErrore().size() > 0) {
            if (this.messaggio.isEmpty()) {
                this.messaggio = this.gf.getMessaggioErrore();
            } else {
                int i = 0;
                while (i < this.gf.getMessaggioErrore().size()) {
                    this.messaggio.addElement(this.gf.getMessaggioErrore().elementAt(i));
                    ++i;
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            File file = new File("d:\\download\\ProgressiviSDiversiDaM.txt");
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = br.readLine();
            Vector<String> v = new Vector<String>();
            while (s != null) {
                v.addElement(String.valueOf(s) + IConst.LINE_SEPARATOR);
                s = br.readLine();
            }
            new FornituraAS(v);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Il file non esiste!");
        }
        catch (IOException iOException) {
            System.out.println("Errore nella lettura del file!");
        }
    }

    public void run() {
        while (this.gf.hasMoreElements()) {
            StrutturaMultiposizione[] sm = (StrutturaMultiposizione[])this.gf.nextElement();
            if (this.gf.getMessaggioErrore().size() > 0) {
                this.impostaMessaggi();
                this.messaggio = this.gf.getMessaggioErrore();
                continue;
            }
            Multiposizione multiposizione = new Multiposizione();
            multiposizione.apri(sm);
            if (multiposizione.getMessaggioErrore().size() > 0) {
                this.messaggio = multiposizione.getMessaggioErrore();
                continue;
            }
            if (!multiposizione.controlloEsclusioni()) continue;
            this.messaggio = multiposizione.verificaCalcolabilita() ? new Vector() : multiposizione.getMessaggioErrore();
        }
    }

    public class Riepilogo {
        /* synthetic */ FornituraAS this$0;
        private String descrizione = "";
        private int valore = 0;

        public Riepilogo(FornituraAS this$0, String descrizione, int valore) {
            this.this$0 = this$0;
            this.valore = valore;
            this.descrizione = descrizione;
        }

        public String getDescrizione() {
            return this.descrizione;
        }

        public int getValore() {
            return this.valore;
        }
    }
}

