/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.util;

import it.sogei.rcp.interfaces.IAbsolutePath;
import it.sogei.rcp.util.RCPException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class AbsolutePath
implements IAbsolutePath {
    private String absolutePath = null;
    private IPath iPath;
    private String workspacePortablePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().addTrailingSeparator().toPortableString();

    private AbsolutePath() {
    }

    public AbsolutePath(String path) throws RCPException {
        path = path.replace('\\', '/');
        if (!this.checkPath(path)) {
            throw new RCPException("il path non \u00e8 del tipo indicato");
        }
        this.absolutePath = path;
        this.iPath = Path.fromPortableString((String)path);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getFileName() {
        if (this.iPath.getFileExtension() != null) {
            return this.iPath.lastSegment();
        }
        return null;
    }

    public String getFolderPath() {
        String filename = this.getFileName();
        String folderPath = filename != null ? this.absolutePath.substring(0, this.absolutePath.indexOf(filename)) : this.absolutePath;
        return this.addFinalSlash(folderPath);
    }

    private boolean checkPath(String path) {
        IPath iPath = Path.fromPortableString((String)path);
        if (!iPath.isAbsolute()) {
            return false;
        }
        return !iPath.isEmpty();
    }

    private String addFinalSlash(String path) {
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }
}

