/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Alert;
import sun.security.ssl.ContentType;
import sun.security.ssl.Plaintext;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.TransportContext;

interface SSLTransport {
    public String getPeerHost();

    public int getPeerPort();

    default public void shutdown() throws IOException {
    }

    public boolean useDelegatedTask();

    public static Plaintext decode(TransportContext transportContext, ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws IOException {
        Plaintext[] plaintextArray = null;
        try {
            plaintextArray = transportContext.inputRecord.decode(byteBufferArray, n, n2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            transportContext.outputRecord.encodeV2NoCipher();
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("may be talking to SSLv2", new Object[0]);
            }
            transportContext.fatal(Alert.UNEXPECTED_MESSAGE, unsupportedOperationException);
        }
        catch (AEADBadTagException aEADBadTagException) {
            transportContext.fatal(Alert.BAD_RECORD_MAC, aEADBadTagException);
        }
        catch (BadPaddingException badPaddingException) {
            Plaintext[] plaintextArray2 = transportContext.handshakeContext != null ? Alert.HANDSHAKE_FAILURE : Alert.BAD_RECORD_MAC;
            transportContext.fatal((Alert)plaintextArray2, badPaddingException);
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            transportContext.fatal(Alert.HANDSHAKE_FAILURE, sSLHandshakeException);
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            transportContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
        }
        if (plaintextArray == null || plaintextArray.length == 0) {
            return Plaintext.PLAINTEXT_NULL;
        }
        Plaintext plaintext = Plaintext.PLAINTEXT_NULL;
        for (Plaintext plaintext2 : plaintextArray) {
            if (plaintext2 != null && plaintext2.contentType != ContentType.APPLICATION_DATA.id) {
                transportContext.dispatch(plaintext2);
            }
            if (plaintext2 == null) {
                plaintext2 = Plaintext.PLAINTEXT_NULL;
            } else if (plaintext2.contentType == ContentType.APPLICATION_DATA.id) {
                if (!transportContext.isNegotiated) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,verbose")) {
                        SSLLogger.warning("unexpected application data before handshake completion", new Object[0]);
                    }
                    transportContext.fatal(Alert.UNEXPECTED_MESSAGE, "Receiving application data before handshake complete");
                }
                if (byteBufferArray2 != null && n4 > 0) {
                    ByteBuffer byteBuffer = plaintext2.fragment;
                    int n5 = byteBuffer.remaining();
                    int n6 = n3 + n4;
                    for (int i = n3; i < n6 && n5 > 0; ++i) {
                        int n7 = Math.min(byteBufferArray2[i].remaining(), n5);
                        byteBuffer.limit(byteBuffer.position() + n7);
                        byteBufferArray2[i].put(byteBuffer);
                        n5 -= n7;
                        if (byteBufferArray2[i].hasRemaining()) continue;
                        ++n3;
                    }
                    if (n5 > 0) {
                        transportContext.fatal(Alert.INTERNAL_ERROR, "no sufficient room in the destination buffers");
                    }
                }
            }
            plaintext = plaintext2;
        }
        return plaintext;
    }
}

