/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.unmarshaller;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.DatatypeConverterImpl;
import com.sun.xml.internal.bind.v2.runtime.output.Pcdata;
import com.sun.xml.internal.bind.v2.runtime.output.UTF8XmlOutput;
import com.sun.xml.internal.bind.v2.util.ByteArrayOutputStreamEx;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;

public final class Base64Data
extends Pcdata {
    private DataHandler dataHandler;
    private byte[] data;
    private int dataLen;
    @Nullable
    private String mimeType;

    public void set(byte[] byArray, int n, @Nullable String string) {
        this.data = byArray;
        this.dataLen = n;
        this.dataHandler = null;
        this.mimeType = string;
    }

    public void set(byte[] byArray, @Nullable String string) {
        this.set(byArray, byArray.length, string);
    }

    public void set(DataHandler dataHandler) {
        assert (dataHandler != null);
        this.dataHandler = dataHandler;
        this.data = null;
    }

    public DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = new DataHandler(new DataSource(){

                @Override
                public String getContentType() {
                    return Base64Data.this.getMimeType();
                }

                @Override
                public InputStream getInputStream() {
                    return new ByteArrayInputStream(Base64Data.this.data, 0, Base64Data.this.dataLen);
                }

                @Override
                public String getName() {
                    return null;
                }

                @Override
                public OutputStream getOutputStream() {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return this.dataHandler;
    }

    public byte[] getExact() {
        this.get();
        if (this.dataLen != this.data.length) {
            byte[] byArray = new byte[this.dataLen];
            System.arraycopy(this.data, 0, byArray, 0, this.dataLen);
            this.data = byArray;
        }
        return this.data;
    }

    public InputStream getInputStream() throws IOException {
        if (this.dataHandler != null) {
            return this.dataHandler.getInputStream();
        }
        return new ByteArrayInputStream(this.data, 0, this.dataLen);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public byte[] get() {
        if (this.data == null) {
            try {
                ByteArrayOutputStreamEx byteArrayOutputStreamEx = new ByteArrayOutputStreamEx(1024);
                InputStream inputStream = this.dataHandler.getDataSource().getInputStream();
                byteArrayOutputStreamEx.readFrom(inputStream);
                inputStream.close();
                this.data = byteArrayOutputStreamEx.getBuffer();
                this.dataLen = byteArrayOutputStreamEx.size();
            }
            catch (IOException iOException) {
                this.dataLen = 0;
            }
        }
        return this.data;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            return "application/octet-stream";
        }
        return this.mimeType;
    }

    @Override
    public int length() {
        this.get();
        return (this.dataLen + 2) / 3 * 4;
    }

    @Override
    public char charAt(int n) {
        int n2 = n % 4;
        int n3 = n / 4 * 3;
        switch (n2) {
            case 0: {
                return DatatypeConverterImpl.encode(this.data[n3] >> 2);
            }
            case 1: {
                byte by = n3 + 1 < this.dataLen ? this.data[n3 + 1] : (byte)0;
                return DatatypeConverterImpl.encode((this.data[n3] & 3) << 4 | by >> 4 & 0xF);
            }
            case 2: {
                if (n3 + 1 < this.dataLen) {
                    byte by = this.data[n3 + 1];
                    byte by2 = n3 + 2 < this.dataLen ? this.data[n3 + 2] : (byte)0;
                    return DatatypeConverterImpl.encode((by & 0xF) << 2 | by2 >> 6 & 3);
                }
                return '=';
            }
            case 3: {
                if (n3 + 2 < this.dataLen) {
                    return DatatypeConverterImpl.encode(this.data[n3 + 2] & 0x3F);
                }
                return '=';
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.get();
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(this.charAt(i));
        }
        return stringBuilder;
    }

    @Override
    public String toString() {
        this.get();
        return DatatypeConverterImpl._printBase64Binary(this.data, 0, this.dataLen);
    }

    @Override
    public void writeTo(char[] cArray, int n) {
        this.get();
        DatatypeConverterImpl._printBase64Binary(this.data, 0, this.dataLen, cArray, n);
    }

    @Override
    public void writeTo(UTF8XmlOutput uTF8XmlOutput) throws IOException {
        this.get();
        uTF8XmlOutput.text(this.data, this.dataLen);
    }
}

