/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.packaging.mime.Header;
import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.BMMimeMultipart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeMultipart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimePullMultipart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ParameterList;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.SharedInputStream;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.ASCIIUtility;
import com.sun.xml.internal.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPPartImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.internal.messaging.saaj.soap.impl.EnvelopeImpl;
import com.sun.xml.internal.messaging.saaj.util.ByteInputStream;
import com.sun.xml.internal.messaging.saaj.util.FastInfosetReflection;
import com.sun.xml.internal.messaging.saaj.util.FinalArrayList;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.stream.StreamSource;

public abstract class MessageImpl
extends SOAPMessage
implements SOAPConstants {
    public static final String CONTENT_ID = "Content-ID";
    public static final String CONTENT_LOCATION = "Content-Location";
    protected static final Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.sun.xml.internal.messaging.saaj.soap.LocalStrings");
    protected static final int PLAIN_XML_FLAG = 1;
    protected static final int MIME_MULTIPART_FLAG = 2;
    protected static final int SOAP1_1_FLAG = 4;
    protected static final int SOAP1_2_FLAG = 8;
    protected static final int MIME_MULTIPART_XOP_SOAP1_1_FLAG = 6;
    protected static final int MIME_MULTIPART_XOP_SOAP1_2_FLAG = 10;
    protected static final int XOP_FLAG = 13;
    protected static final int FI_ENCODED_FLAG = 16;
    protected MimeHeaders headers;
    protected ContentType contentType;
    protected SOAPPartImpl soapPartImpl;
    protected FinalArrayList attachments;
    protected boolean saved = false;
    protected byte[] messageBytes;
    protected int messageByteCount;
    protected HashMap properties = new HashMap();
    protected MimeMultipart multiPart = null;
    protected boolean attachmentsInitialized = false;
    protected boolean isFastInfoset = false;
    protected boolean acceptFastInfoset = false;
    protected MimeMultipart mmp = null;
    private boolean optimizeAttachmentProcessing = true;
    private InputStream inputStreamAfterSaveChanges = null;
    private static boolean switchOffBM = false;
    private static boolean switchOffLazyAttachment = false;
    private static boolean useMimePull = false;
    private boolean lazyAttachments = false;
    private static final Iterator nullIter;

    private static boolean isSoap1_1Type(String string, String string2) {
        return string.equalsIgnoreCase("text") && string2.equalsIgnoreCase("xml") || string.equalsIgnoreCase("text") && string2.equalsIgnoreCase("xml-soap") || string.equals("application") && string2.equals("fastinfoset");
    }

    private static boolean isEqualToSoap1_1Type(String string) {
        return string.startsWith("text/xml") || string.startsWith("application/fastinfoset");
    }

    private static boolean isSoap1_2Type(String string, String string2) {
        return string.equals("application") && (string2.equals("soap+xml") || string2.equals("soap+fastinfoset"));
    }

    private static boolean isEqualToSoap1_2Type(String string) {
        return string.startsWith("application/soap+xml") || string.startsWith("application/soap+fastinfoset");
    }

    protected MessageImpl() {
        this(false, false);
        this.attachmentsInitialized = true;
    }

    protected MessageImpl(boolean bl, boolean bl2) {
        this.isFastInfoset = bl;
        this.acceptFastInfoset = bl2;
        this.headers = new MimeHeaders();
        this.headers.setHeader("Accept", this.getExpectedAcceptHeader());
        this.contentType = new ContentType();
    }

    protected MessageImpl(SOAPMessage sOAPMessage) {
        if (!(sOAPMessage instanceof MessageImpl)) {
            // empty if block
        }
        MessageImpl messageImpl = (MessageImpl)sOAPMessage;
        this.headers = messageImpl.headers;
        this.soapPartImpl = messageImpl.soapPartImpl;
        this.attachments = messageImpl.attachments;
        this.saved = messageImpl.saved;
        this.messageBytes = messageImpl.messageBytes;
        this.messageByteCount = messageImpl.messageByteCount;
        this.properties = messageImpl.properties;
        this.contentType = messageImpl.contentType;
    }

    protected static boolean isSoap1_1Content(int n) {
        return (n & 4) != 0;
    }

    protected static boolean isSoap1_2Content(int n) {
        return (n & 8) != 0;
    }

    private static boolean isMimeMultipartXOPSoap1_2Package(ContentType contentType) {
        String string = contentType.getParameter("type");
        if (string == null) {
            return false;
        }
        if (!(string = string.toLowerCase()).startsWith("application/xop+xml")) {
            return false;
        }
        String string2 = contentType.getParameter("start-info");
        if (string2 == null) {
            return false;
        }
        string2 = string2.toLowerCase();
        return MessageImpl.isEqualToSoap1_2Type(string2);
    }

    private static boolean isMimeMultipartXOPSoap1_1Package(ContentType contentType) {
        String string = contentType.getParameter("type");
        if (string == null) {
            return false;
        }
        if (!(string = string.toLowerCase()).startsWith("application/xop+xml")) {
            return false;
        }
        String string2 = contentType.getParameter("start-info");
        if (string2 == null) {
            return false;
        }
        string2 = string2.toLowerCase();
        return MessageImpl.isEqualToSoap1_1Type(string2);
    }

    private static boolean isSOAPBodyXOPPackage(ContentType contentType) {
        String string = contentType.getPrimaryType();
        String string2 = contentType.getSubType();
        if (string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("xop+xml")) {
            String string3 = MessageImpl.getTypeParameter(contentType);
            return MessageImpl.isEqualToSoap1_2Type(string3) || MessageImpl.isEqualToSoap1_1Type(string3);
        }
        return false;
    }

    protected MessageImpl(MimeHeaders mimeHeaders, InputStream inputStream) throws SOAPExceptionImpl {
        this.contentType = MessageImpl.parseContentType(mimeHeaders);
        this.init(mimeHeaders, MessageImpl.identifyContentType(this.contentType), this.contentType, inputStream);
    }

    private static ContentType parseContentType(MimeHeaders mimeHeaders) throws SOAPExceptionImpl {
        if (mimeHeaders == null) {
            log.severe("SAAJ0550.soap.null.headers");
            throw new SOAPExceptionImpl("Cannot create message: Headers can't be null");
        }
        String string = MessageImpl.getContentType(mimeHeaders);
        if (string == null) {
            log.severe("SAAJ0532.soap.no.Content-Type");
            throw new SOAPExceptionImpl("Absent Content-Type");
        }
        try {
            return new ContentType(string);
        }
        catch (Throwable throwable) {
            log.severe("SAAJ0535.soap.cannot.internalize.message");
            throw new SOAPExceptionImpl("Unable to internalize message", throwable);
        }
    }

    protected MessageImpl(MimeHeaders mimeHeaders, ContentType contentType, int n, InputStream inputStream) throws SOAPExceptionImpl {
        this.init(mimeHeaders, n, contentType, inputStream);
    }

    private void init(MimeHeaders mimeHeaders, int n, final ContentType contentType, final InputStream inputStream) throws SOAPExceptionImpl {
        block27: {
            this.headers = mimeHeaders;
            try {
                Object object;
                Object object2;
                Object object3;
                if ((n & 0x10) > 0) {
                    this.acceptFastInfoset = true;
                    this.isFastInfoset = true;
                }
                if (!this.isFastInfoset && (object3 = mimeHeaders.getHeader("Accept")) != null) {
                    block4: for (int i = 0; i < ((String[])object3).length; ++i) {
                        object2 = new StringTokenizer(object3[i], ",");
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            object = ((StringTokenizer)object2).nextToken().trim();
                            if (!((String)object).equalsIgnoreCase("application/fastinfoset") && !((String)object).equalsIgnoreCase("application/soap+fastinfoset")) continue;
                            this.acceptFastInfoset = true;
                            continue block4;
                        }
                    }
                }
                if (!this.isCorrectSoapVersion(n)) {
                    log.log(Level.SEVERE, "SAAJ0533.soap.incorrect.Content-Type", new String[]{contentType.toString(), this.getExpectedContentType()});
                    throw new SOAPVersionMismatchException("Cannot create message: incorrect content-type for SOAP version. Got: " + contentType + " Expected: " + this.getExpectedContentType());
                }
                if ((n & 1) != 0) {
                    if (this.isFastInfoset) {
                        this.getSOAPPart().setContent(FastInfosetReflection.FastInfosetSource_new(inputStream));
                    } else {
                        this.initCharsetProperty(contentType);
                        this.getSOAPPart().setContent(new StreamSource(inputStream));
                    }
                    break block27;
                }
                if ((n & 2) != 0) {
                    Object object4;
                    Object object5;
                    object3 = new DataSource(){

                        @Override
                        public InputStream getInputStream() {
                            return inputStream;
                        }

                        @Override
                        public OutputStream getOutputStream() {
                            return null;
                        }

                        @Override
                        public String getContentType() {
                            return contentType.toString();
                        }

                        @Override
                        public String getName() {
                            return "";
                        }
                    };
                    this.multiPart = null;
                    this.multiPart = useMimePull ? new MimePullMultipart((DataSource)object3, contentType) : (switchOffBM ? new MimeMultipart((DataSource)object3, contentType) : new BMMimeMultipart((DataSource)object3, contentType));
                    String string = contentType.getParameter("start");
                    object2 = null;
                    object = null;
                    String string2 = null;
                    if (switchOffBM || switchOffLazyAttachment) {
                        if (string == null) {
                            object2 = this.multiPart.getBodyPart(0);
                            for (int i = 1; i < this.multiPart.getCount(); ++i) {
                                this.initializeAttachment(this.multiPart, i);
                            }
                        } else {
                            object2 = this.multiPart.getBodyPart(string);
                            for (int i = 0; i < this.multiPart.getCount(); ++i) {
                                string2 = this.multiPart.getBodyPart(i).getContentID();
                                if (string2.equals(string)) continue;
                                this.initializeAttachment(this.multiPart, i);
                            }
                        }
                    } else if (useMimePull) {
                        MimePullMultipart mimePullMultipart = (MimePullMultipart)this.multiPart;
                        object5 = mimePullMultipart.readAndReturnSOAPPart();
                        object2 = new MimeBodyPart((MIMEPart)object5);
                        object = ((MIMEPart)object5).readOnce();
                    } else {
                        BMMimeMultipart bMMimeMultipart = (BMMimeMultipart)this.multiPart;
                        object5 = bMMimeMultipart.initStream();
                        object4 = null;
                        if (object5 instanceof SharedInputStream) {
                            object4 = (SharedInputStream)object5;
                        }
                        String string3 = "--" + contentType.getParameter("boundary");
                        byte[] byArray = ASCIIUtility.getBytes(string3);
                        if (string == null) {
                            object2 = bMMimeMultipart.getNextPart((InputStream)object5, byArray, (SharedInputStream)object4);
                            bMMimeMultipart.removeBodyPart((MimeBodyPart)object2);
                        } else {
                            MimeBodyPart mimeBodyPart = null;
                            try {
                                while (!string.equals(string2)) {
                                    mimeBodyPart = bMMimeMultipart.getNextPart((InputStream)object5, byArray, (SharedInputStream)object4);
                                    string2 = mimeBodyPart.getContentID();
                                }
                                object2 = mimeBodyPart;
                                bMMimeMultipart.removeBodyPart(mimeBodyPart);
                            }
                            catch (Exception exception) {
                                throw new SOAPExceptionImpl(exception);
                            }
                        }
                    }
                    if (object == null && object2 != null) {
                        object = ((MimeBodyPart)object2).getInputStream();
                    }
                    ContentType contentType2 = new ContentType(((MimeBodyPart)object2).getContentType());
                    this.initCharsetProperty(contentType2);
                    object5 = contentType2.getBaseType().toLowerCase();
                    if (!(MessageImpl.isEqualToSoap1_1Type((String)object5) || MessageImpl.isEqualToSoap1_2Type((String)object5) || MessageImpl.isSOAPBodyXOPPackage(contentType2))) {
                        log.log(Level.SEVERE, "SAAJ0549.soap.part.invalid.Content-Type", new Object[]{object5});
                        throw new SOAPExceptionImpl("Bad Content-Type for SOAP Part : " + (String)object5);
                    }
                    object4 = this.getSOAPPart();
                    this.setMimeHeaders((SOAPPart)object4, (MimeBodyPart)object2);
                    ((SOAPPart)object4).setContent(this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new((InputStream)object) : new StreamSource((InputStream)object));
                    break block27;
                }
                log.severe("SAAJ0534.soap.unknown.Content-Type");
                throw new SOAPExceptionImpl("Unrecognized Content-Type");
            }
            catch (Throwable throwable) {
                log.severe("SAAJ0535.soap.cannot.internalize.message");
                throw new SOAPExceptionImpl("Unable to internalize message", throwable);
            }
        }
        this.needsSave();
    }

    public boolean isFastInfoset() {
        return this.isFastInfoset;
    }

    public boolean acceptFastInfoset() {
        return this.acceptFastInfoset;
    }

    public void setIsFastInfoset(boolean bl) {
        if (bl != this.isFastInfoset) {
            this.isFastInfoset = bl;
            if (this.isFastInfoset) {
                this.acceptFastInfoset = true;
            }
            this.saved = false;
        }
    }

    @Override
    public Object getProperty(String string) {
        return (String)this.properties.get(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.verify(string, object);
        this.properties.put(string, object);
    }

    private void verify(String string, Object object) {
        if (string.equalsIgnoreCase("javax.xml.soap.write-xml-declaration")) {
            if (!"true".equals(object) && !"false".equals(object)) {
                throw new RuntimeException(string + " must have value false or true");
            }
            try {
                EnvelopeImpl envelopeImpl = (EnvelopeImpl)this.getSOAPPart().getEnvelope();
                if ("true".equalsIgnoreCase((String)object)) {
                    envelopeImpl.setOmitXmlDecl("no");
                } else if ("false".equalsIgnoreCase((String)object)) {
                    envelopeImpl.setOmitXmlDecl("yes");
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0591.soap.exception.in.set.property", new Object[]{exception.getMessage(), "javax.xml.soap.write-xml-declaration"});
                throw new RuntimeException(exception);
            }
            return;
        }
        if (string.equalsIgnoreCase("javax.xml.soap.character-set-encoding")) {
            try {
                ((EnvelopeImpl)this.getSOAPPart().getEnvelope()).setCharsetEncoding((String)object);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0591.soap.exception.in.set.property", new Object[]{exception.getMessage(), "javax.xml.soap.character-set-encoding"});
                throw new RuntimeException(exception);
            }
        }
    }

    protected abstract boolean isCorrectSoapVersion(int var1);

    protected abstract String getExpectedContentType();

    protected abstract String getExpectedAcceptHeader();

    static int identifyContentType(ContentType contentType) throws SOAPExceptionImpl {
        String string = contentType.getPrimaryType().toLowerCase();
        String string2 = contentType.getSubType().toLowerCase();
        if (string.equals("multipart")) {
            if (string2.equals("related")) {
                String string3 = MessageImpl.getTypeParameter(contentType);
                if (MessageImpl.isEqualToSoap1_1Type(string3)) {
                    return (string3.equals("application/fastinfoset") ? 16 : 0) | 2 | 4;
                }
                if (MessageImpl.isEqualToSoap1_2Type(string3)) {
                    return (string3.equals("application/soap+fastinfoset") ? 16 : 0) | 2 | 8;
                }
                if (MessageImpl.isMimeMultipartXOPSoap1_1Package(contentType)) {
                    return 6;
                }
                if (MessageImpl.isMimeMultipartXOPSoap1_2Package(contentType)) {
                    return 10;
                }
                log.severe("SAAJ0536.soap.content-type.mustbe.multipart");
                throw new SOAPExceptionImpl("Content-Type needs to be Multipart/Related and with \"type=text/xml\" or \"type=application/soap+xml\"");
            }
            log.severe("SAAJ0537.soap.invalid.content-type");
            throw new SOAPExceptionImpl("Invalid Content-Type: " + string + '/' + string2);
        }
        if (MessageImpl.isSoap1_1Type(string, string2)) {
            return (string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("fastinfoset") ? 16 : 0) | 1 | 4;
        }
        if (MessageImpl.isSoap1_2Type(string, string2)) {
            return (string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("soap+fastinfoset") ? 16 : 0) | 1 | 8;
        }
        if (MessageImpl.isSOAPBodyXOPPackage(contentType)) {
            return 13;
        }
        log.severe("SAAJ0537.soap.invalid.content-type");
        throw new SOAPExceptionImpl("Invalid Content-Type:" + string + '/' + string2 + ". Is this an error message instead of a SOAP response?");
    }

    private static String getTypeParameter(ContentType contentType) {
        String string = contentType.getParameter("type");
        if (string != null) {
            return string.toLowerCase();
        }
        return "text/xml";
    }

    @Override
    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    static final String getContentType(MimeHeaders mimeHeaders) {
        String[] stringArray = mimeHeaders.getHeader("Content-Type");
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public String getContentType() {
        return MessageImpl.getContentType(this.headers);
    }

    public void setContentType(String string) {
        this.headers.setHeader("Content-Type", string);
        this.needsSave();
    }

    private ContentType contentType() {
        ContentType contentType = null;
        try {
            String string = this.getContentType();
            if (string == null) {
                return this.contentType;
            }
            contentType = new ContentType(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return contentType;
    }

    public String getBaseType() {
        return this.contentType().getBaseType();
    }

    public void setBaseType(String string) {
        ContentType contentType = this.contentType();
        contentType.setParameter("type", string);
        this.headers.setHeader("Content-Type", contentType.toString());
        this.needsSave();
    }

    public String getAction() {
        return this.contentType().getParameter("action");
    }

    public void setAction(String string) {
        ContentType contentType = this.contentType();
        contentType.setParameter("action", string);
        this.headers.setHeader("Content-Type", contentType.toString());
        this.needsSave();
    }

    public String getCharset() {
        return this.contentType().getParameter("charset");
    }

    public void setCharset(String string) {
        ContentType contentType = this.contentType();
        contentType.setParameter("charset", string);
        this.headers.setHeader("Content-Type", contentType.toString());
        this.needsSave();
    }

    private final void needsSave() {
        this.saved = false;
    }

    @Override
    public boolean saveRequired() {
        return !this.saved;
    }

    @Override
    public String getContentDescription() {
        String[] stringArray = this.headers.getHeader("Content-Description");
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    @Override
    public void setContentDescription(String string) {
        this.headers.setHeader("Content-Description", string);
        this.needsSave();
    }

    @Override
    public abstract SOAPPart getSOAPPart();

    @Override
    public void removeAllAttachments() {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments != null) {
            this.attachments.clear();
            this.needsSave();
        }
    }

    @Override
    public int countAttachments() {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments != null) {
            return this.attachments.size();
        }
        return 0;
    }

    @Override
    public void addAttachmentPart(AttachmentPart attachmentPart) {
        try {
            this.initializeAllAttachments();
            this.optimizeAttachmentProcessing = true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments == null) {
            this.attachments = new FinalArrayList();
        }
        this.attachments.add(attachmentPart);
        this.needsSave();
    }

    @Override
    public Iterator getAttachments() {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments == null) {
            return nullIter;
        }
        return this.attachments.iterator();
    }

    private void setFinalContentType(String string) {
        ContentType contentType = this.contentType();
        if (contentType == null) {
            contentType = new ContentType();
        }
        String[] stringArray = this.getExpectedContentType().split("/");
        contentType.setPrimaryType(stringArray[0]);
        contentType.setSubType(stringArray[1]);
        contentType.setParameter("charset", string);
        this.headers.setHeader("Content-Type", contentType.toString());
    }

    @Override
    public Iterator getAttachments(MimeHeaders mimeHeaders) {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments == null) {
            return nullIter;
        }
        return new MimeMatchingIterator(mimeHeaders);
    }

    @Override
    public void removeAttachments(MimeHeaders mimeHeaders) {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments == null) {
            return;
        }
        MimeMatchingIterator mimeMatchingIterator = new MimeMatchingIterator(mimeHeaders);
        while (mimeMatchingIterator.hasNext()) {
            int n = this.attachments.indexOf(mimeMatchingIterator.next());
            this.attachments.set(n, null);
        }
        FinalArrayList finalArrayList = new FinalArrayList();
        for (int i = 0; i < this.attachments.size(); ++i) {
            if (this.attachments.get(i) == null) continue;
            finalArrayList.add(this.attachments.get(i));
        }
        this.attachments = finalArrayList;
    }

    @Override
    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    @Override
    public AttachmentPart getAttachment(SOAPElement sOAPElement) throws SOAPException {
        String string;
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        String string2 = sOAPElement.getAttribute("href");
        if ("".equals(string2)) {
            Node node = this.getValueNodeStrict(sOAPElement);
            String string3 = null;
            if (node != null) {
                string3 = node.getValue();
            }
            if (string3 == null || "".equals(string3)) {
                return null;
            }
            string = string3;
        } else {
            string = string2;
        }
        return this.getAttachmentPart(string);
    }

    private Node getValueNodeStrict(SOAPElement sOAPElement) {
        Node node = (Node)sOAPElement.getFirstChild();
        if (node != null) {
            if (node.getNextSibling() == null && node.getNodeType() == 3) {
                return node;
            }
            return null;
        }
        return null;
    }

    private AttachmentPart getAttachmentPart(String string) throws SOAPException {
        Object object;
        block5: {
            try {
                Object object2;
                Object object3;
                if (string.startsWith("cid:")) {
                    string = '<' + string.substring("cid:".length()) + '>';
                    object3 = new MimeHeaders();
                    ((MimeHeaders)object3).addHeader(CONTENT_ID, string);
                    object2 = this.getAttachments((MimeHeaders)object3);
                    object = object2 == null ? null : (AttachmentPart)object2.next();
                } else {
                    object3 = new MimeHeaders();
                    ((MimeHeaders)object3).addHeader(CONTENT_LOCATION, string);
                    object2 = this.getAttachments((MimeHeaders)object3);
                    Object object4 = object = object2 == null ? null : (AttachmentPart)object2.next();
                }
                if (object != null) break block5;
                object3 = this.getAttachments();
                while (object3.hasNext()) {
                    int n;
                    object2 = (AttachmentPart)object3.next();
                    String string2 = ((AttachmentPart)object2).getContentId();
                    if (string2 == null || (n = string2.indexOf("=")) <= -1 || !(string2 = string2.substring(1, n)).equalsIgnoreCase(string)) continue;
                    object = object2;
                    break;
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0590.soap.unable.to.locate.attachment", new Object[]{string});
                throw new SOAPExceptionImpl(exception);
            }
        }
        return object;
    }

    private final InputStream getHeaderBytes() throws IOException {
        SOAPPartImpl sOAPPartImpl = (SOAPPartImpl)this.getSOAPPart();
        return sOAPPartImpl.getContentAsStream();
    }

    private String convertToSingleLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n' || c == '\t') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private MimeMultipart getMimeMessage() throws SOAPException {
        try {
            Object object;
            SOAPPartImpl sOAPPartImpl = (SOAPPartImpl)this.getSOAPPart();
            MimeBodyPart mimeBodyPart = sOAPPartImpl.getMimePart();
            ContentType contentType = new ContentType(this.getExpectedContentType());
            if (!this.isFastInfoset) {
                contentType.setParameter("charset", this.initCharset());
            }
            mimeBodyPart.setHeader("Content-Type", contentType.toString());
            MimeMultipart mimeMultipart = null;
            if (!(switchOffBM || switchOffLazyAttachment || this.multiPart == null || this.attachmentsInitialized)) {
                mimeMultipart = new BMMimeMultipart();
                mimeMultipart.addBodyPart(mimeBodyPart);
                if (this.attachments != null) {
                    object = this.attachments.iterator();
                    while (object.hasNext()) {
                        mimeMultipart.addBodyPart(((AttachmentPartImpl)object.next()).getMimePart());
                    }
                }
                object = ((BMMimeMultipart)this.multiPart).getInputStream();
                if (!((BMMimeMultipart)this.multiPart).lastBodyPartFound() && !((BMMimeMultipart)this.multiPart).isEndOfStream()) {
                    ((BMMimeMultipart)mimeMultipart).setInputStream((InputStream)object);
                    ((BMMimeMultipart)mimeMultipart).setBoundary(((BMMimeMultipart)this.multiPart).getBoundary());
                    ((BMMimeMultipart)mimeMultipart).setLazyAttachments(this.lazyAttachments);
                }
            } else {
                mimeMultipart = new MimeMultipart();
                mimeMultipart.addBodyPart(mimeBodyPart);
                object = this.getAttachments();
                while (object.hasNext()) {
                    mimeMultipart.addBodyPart(((AttachmentPartImpl)object.next()).getMimePart());
                }
            }
            object = mimeMultipart.getContentType();
            ParameterList parameterList = ((ContentType)object).getParameterList();
            parameterList.set("type", this.getExpectedContentType());
            parameterList.set("boundary", ((ContentType)object).getParameter("boundary"));
            ContentType contentType2 = new ContentType("multipart", "related", parameterList);
            this.headers.setHeader("Content-Type", this.convertToSingleLine(contentType2.toString()));
            return mimeMultipart;
        }
        catch (SOAPException sOAPException) {
            throw sOAPException;
        }
        catch (Throwable throwable) {
            log.severe("SAAJ0538.soap.cannot.convert.msg.to.multipart.obj");
            throw new SOAPExceptionImpl("Unable to convert SOAP message into a MimeMultipart object", throwable);
        }
    }

    private String initCharset() {
        String string = null;
        String[] stringArray = this.getMimeHeaders().getHeader("Content-Type");
        if (stringArray != null && stringArray[0] != null) {
            string = this.getCharsetString(stringArray[0]);
        }
        if (string == null) {
            string = (String)this.getProperty("javax.xml.soap.character-set-encoding");
        }
        if (string != null) {
            return string;
        }
        return "utf-8";
    }

    private String getCharsetString(String string) {
        try {
            int n = string.indexOf(";");
            if (n < 0) {
                return null;
            }
            ParameterList parameterList = new ParameterList(string.substring(n));
            return parameterList.get("charset");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void saveChanges() throws SOAPException {
        block9: {
            int n;
            String string = this.initCharset();
            int n2 = n = this.attachments == null ? 0 : this.attachments.size();
            if (!(n != 0 || switchOffBM || switchOffLazyAttachment || this.attachmentsInitialized || this.multiPart == null)) {
                n = 1;
            }
            try {
                if (n == 0 && !this.hasXOPContent()) {
                    InputStream inputStream;
                    try {
                        inputStream = this.getHeaderBytes();
                        this.optimizeAttachmentProcessing = false;
                        if (SOAPPartImpl.lazyContentLength) {
                            this.inputStreamAfterSaveChanges = inputStream;
                        }
                    }
                    catch (IOException iOException) {
                        log.severe("SAAJ0539.soap.cannot.get.header.stream");
                        throw new SOAPExceptionImpl("Unable to get header stream in saveChanges: ", iOException);
                    }
                    if (inputStream instanceof ByteInputStream) {
                        ByteInputStream byteInputStream = (ByteInputStream)inputStream;
                        this.messageBytes = byteInputStream.getBytes();
                        this.messageByteCount = byteInputStream.getCount();
                    }
                    this.setFinalContentType(string);
                    if (this.messageByteCount > 0) {
                        this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
                    }
                    break block9;
                }
                this.mmp = this.hasXOPContent() ? this.getXOPMessage() : this.getMimeMessage();
            }
            catch (Throwable throwable) {
                log.severe("SAAJ0540.soap.err.saving.multipart.msg");
                throw new SOAPExceptionImpl("Error during saving a multipart message", throwable);
            }
        }
        this.saved = true;
    }

    private MimeMultipart getXOPMessage() throws SOAPException {
        try {
            Object object;
            MimeMultipart mimeMultipart = new MimeMultipart();
            SOAPPartImpl sOAPPartImpl = (SOAPPartImpl)this.getSOAPPart();
            MimeBodyPart mimeBodyPart = sOAPPartImpl.getMimePart();
            ContentType contentType = new ContentType("application/xop+xml");
            contentType.setParameter("type", this.getExpectedContentType());
            String string = this.initCharset();
            contentType.setParameter("charset", string);
            mimeBodyPart.setHeader("Content-Type", contentType.toString());
            mimeMultipart.addBodyPart(mimeBodyPart);
            Object object2 = this.getAttachments();
            while (object2.hasNext()) {
                mimeMultipart.addBodyPart(((AttachmentPartImpl)object2.next()).getMimePart());
            }
            object2 = mimeMultipart.getContentType();
            ParameterList parameterList = ((ContentType)object2).getParameterList();
            parameterList.set("start-info", this.getExpectedContentType());
            parameterList.set("type", "application/xop+xml");
            if (this.isCorrectSoapVersion(8) && (object = this.getAction()) != null) {
                parameterList.set("action", (String)object);
            }
            parameterList.set("boundary", ((ContentType)object2).getParameter("boundary"));
            object = new ContentType("Multipart", "Related", parameterList);
            this.headers.setHeader("Content-Type", this.convertToSingleLine(((ContentType)object).toString()));
            return mimeMultipart;
        }
        catch (SOAPException sOAPException) {
            throw sOAPException;
        }
        catch (Throwable throwable) {
            log.severe("SAAJ0538.soap.cannot.convert.msg.to.multipart.obj");
            throw new SOAPExceptionImpl("Unable to convert SOAP message into a MimeMultipart object", throwable);
        }
    }

    private boolean hasXOPContent() throws ParseException {
        String string = this.getContentType();
        if (string == null) {
            return false;
        }
        ContentType contentType = new ContentType(string);
        return MessageImpl.isMimeMultipartXOPSoap1_1Package(contentType) || MessageImpl.isMimeMultipartXOPSoap1_2Package(contentType) || MessageImpl.isSOAPBodyXOPPackage(contentType);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        Object[] objectArray;
        if (this.saveRequired()) {
            this.optimizeAttachmentProcessing = true;
            this.saveChanges();
        }
        if (!this.optimizeAttachmentProcessing) {
            if (SOAPPartImpl.lazyContentLength && this.messageByteCount <= 0) {
                objectArray = new byte[1024];
                int n = 0;
                while ((n = this.inputStreamAfterSaveChanges.read((byte[])objectArray)) != -1) {
                    outputStream.write((byte[])objectArray, 0, n);
                    this.messageByteCount += n;
                }
                if (this.messageByteCount > 0) {
                    this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
                }
            } else {
                outputStream.write(this.messageBytes, 0, this.messageByteCount);
            }
        } else {
            try {
                if (this.hasXOPContent()) {
                    this.mmp.writeTo(outputStream);
                } else {
                    this.mmp.writeTo(outputStream);
                    if (!(switchOffBM || switchOffLazyAttachment || this.multiPart == null || this.attachmentsInitialized)) {
                        ((BMMimeMultipart)this.multiPart).setInputStream(((BMMimeMultipart)this.mmp).getInputStream());
                    }
                }
            }
            catch (Exception exception) {
                log.severe("SAAJ0540.soap.err.saving.multipart.msg");
                throw new SOAPExceptionImpl("Error during saving a multipart message", exception);
            }
        }
        if (this.isCorrectSoapVersion(4) && ((objectArray = (Object[])this.headers.getHeader("SOAPAction")) == null || objectArray.length == 0)) {
            this.headers.setHeader("SOAPAction", "\"\"");
        }
        this.messageBytes = null;
        this.needsSave();
    }

    @Override
    public SOAPBody getSOAPBody() throws SOAPException {
        SOAPBody sOAPBody = this.getSOAPPart().getEnvelope().getBody();
        return sOAPBody;
    }

    @Override
    public SOAPHeader getSOAPHeader() throws SOAPException {
        SOAPHeader sOAPHeader = this.getSOAPPart().getEnvelope().getHeader();
        return sOAPHeader;
    }

    private void initializeAllAttachments() throws MessagingException, SOAPException {
        if (switchOffBM || switchOffLazyAttachment) {
            return;
        }
        if (this.attachmentsInitialized || this.multiPart == null) {
            return;
        }
        if (this.attachments == null) {
            this.attachments = new FinalArrayList();
        }
        int n = this.multiPart.getCount();
        for (int i = 0; i < n; ++i) {
            this.initializeAttachment(this.multiPart.getBodyPart(i));
        }
        this.attachmentsInitialized = true;
        this.needsSave();
    }

    private void initializeAttachment(MimeBodyPart mimeBodyPart) throws SOAPException {
        AttachmentPartImpl attachmentPartImpl = new AttachmentPartImpl();
        DataHandler dataHandler = mimeBodyPart.getDataHandler();
        attachmentPartImpl.setDataHandler(dataHandler);
        AttachmentPartImpl.copyMimeHeaders(mimeBodyPart, attachmentPartImpl);
        this.attachments.add(attachmentPartImpl);
    }

    private void initializeAttachment(MimeMultipart mimeMultipart, int n) throws Exception {
        MimeBodyPart mimeBodyPart = mimeMultipart.getBodyPart(n);
        AttachmentPartImpl attachmentPartImpl = new AttachmentPartImpl();
        DataHandler dataHandler = mimeBodyPart.getDataHandler();
        attachmentPartImpl.setDataHandler(dataHandler);
        AttachmentPartImpl.copyMimeHeaders(mimeBodyPart, attachmentPartImpl);
        this.addAttachmentPart(attachmentPartImpl);
    }

    private void setMimeHeaders(SOAPPart sOAPPart, MimeBodyPart mimeBodyPart) throws Exception {
        sOAPPart.removeAllMimeHeaders();
        FinalArrayList finalArrayList = mimeBodyPart.getAllHeaders();
        int n = finalArrayList.size();
        for (int i = 0; i < n; ++i) {
            Header header = (Header)finalArrayList.get(i);
            sOAPPart.addMimeHeader(header.getName(), header.getValue());
        }
    }

    private void initCharsetProperty(ContentType contentType) {
        String string = contentType.getParameter("charset");
        if (string != null) {
            ((SOAPPartImpl)this.getSOAPPart()).setSourceCharsetEncoding(string);
            if (!string.equalsIgnoreCase("utf-8")) {
                this.setProperty("javax.xml.soap.character-set-encoding", string);
            }
        }
    }

    public void setLazyAttachments(boolean bl) {
        this.lazyAttachments = bl;
    }

    static {
        try {
            String string = System.getProperty("saaj.mime.optimization");
            if (string != null && string.equals("false")) {
                switchOffBM = true;
            }
            if ((string = System.getProperty("saaj.lazy.mime.optimization")) != null && string.equals("false")) {
                switchOffLazyAttachment = true;
            }
            useMimePull = Boolean.getBoolean("saaj.use.mimepull");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        nullIter = Collections.EMPTY_LIST.iterator();
    }

    private class MimeMatchingIterator
    implements Iterator {
        private Iterator iter;
        private MimeHeaders headers;
        private Object nextAttachment;

        public MimeMatchingIterator(MimeHeaders mimeHeaders) {
            this.headers = mimeHeaders;
            this.iter = MessageImpl.this.attachments.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.nextAttachment == null) {
                this.nextAttachment = this.nextMatch();
            }
            return this.nextAttachment != null;
        }

        public Object next() {
            if (this.nextAttachment != null) {
                Object object = this.nextAttachment;
                this.nextAttachment = null;
                return object;
            }
            if (this.hasNext()) {
                return this.nextAttachment;
            }
            return null;
        }

        Object nextMatch() {
            while (this.iter.hasNext()) {
                AttachmentPartImpl attachmentPartImpl = (AttachmentPartImpl)this.iter.next();
                if (!attachmentPartImpl.hasAllHeaders(this.headers)) continue;
                return attachmentPartImpl;
            }
            return null;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

