/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.config.Platform;
import java.util.Properties;

final class UpgradeStatus {
    protected static final String BEGIN_TIMESTAMP_PROP_SUFFIX = "BeginTimestamp";
    protected static final String ATTEMPT_COUNT_PROP_SUFFIX = "AttemptCount";
    private static final int MAX_UPGRADE_ATTEMPTS = 5;
    private static final long RECENT_LIMIT = 1800000L;
    private final String upgradeBeginPropName;
    private final String upgradeCountPropName;
    private long lastUpgradeBeginTimestamp;
    private int upgradeAttemptCount;

    private UpgradeStatus(String string, long l, String string2, int n) {
        this.upgradeBeginPropName = string;
        this.upgradeCountPropName = string2;
        this.lastUpgradeBeginTimestamp = l;
        this.upgradeAttemptCount = n;
    }

    static boolean beenInitialized(String string) {
        String[] stringArray = UpgradeStatus.getUpgraderStatusPropNames(string);
        Properties properties = Platform.get().getCacheUpgradeInfo(stringArray);
        return properties.size() > 0;
    }

    static void initialized(String string) {
        String string2 = string + BEGIN_TIMESTAMP_PROP_SUFFIX;
        String string3 = string + ATTEMPT_COUNT_PROP_SUFFIX;
        Properties properties = new Properties();
        properties.setProperty(string2, String.valueOf(0));
        properties.setProperty(string3, String.valueOf(0));
        Platform.get().storeCacheUpgradeInfo(properties);
    }

    static UpgradeStatus getUpgradeStatus(String string, long l, String string2, int n) {
        return new UpgradeStatus(string, l, string2, n);
    }

    static String[] getUpgraderStatusPropNames(String string) {
        String string2 = string + BEGIN_TIMESTAMP_PROP_SUFFIX;
        String string3 = string + ATTEMPT_COUNT_PROP_SUFFIX;
        return new String[]{string2, string3};
    }

    static UpgradeStatus getUpgradeStatus(String string) {
        long l = 0L;
        int n = 0;
        String string2 = string + BEGIN_TIMESTAMP_PROP_SUFFIX;
        String string3 = string + ATTEMPT_COUNT_PROP_SUFFIX;
        Properties properties = Platform.get().getCacheUpgradeInfo(new String[]{string2, string3});
        String string4 = properties.getProperty(string2);
        if (string4 != null) {
            l = Long.parseLong(string4);
        }
        if ((string4 = properties.getProperty(string3)) != null) {
            n = Integer.parseInt(string4);
        }
        UpgradeStatus upgradeStatus = new UpgradeStatus(string2, l, string3, n);
        return upgradeStatus;
    }

    boolean isCompleted() {
        return this.upgradeAttemptCount == Integer.MAX_VALUE;
    }

    void setCompleted() {
        this.upgradeAttemptCount = Integer.MAX_VALUE;
        this.save();
    }

    boolean incrementUpgradeAttempt(int n) {
        if (this.upgradeAttemptCount != n) {
            return false;
        }
        ++this.upgradeAttemptCount;
        this.save();
        return true;
    }

    private void save() {
        Properties properties = new Properties();
        properties.put(this.upgradeBeginPropName, String.valueOf(System.currentTimeMillis()));
        properties.put(this.upgradeCountPropName, String.valueOf(this.upgradeAttemptCount));
        Platform.get().storeCacheUpgradeInfo(properties);
    }

    boolean isDone() {
        return this.upgradeAttemptCount >= 5;
    }

    boolean wasStartedRecently() {
        return this.lastUpgradeBeginTimestamp > 0L && System.currentTimeMillis() - this.lastUpgradeBeginTimestamp < 1800000L;
    }

    int getUpgradeAttempts() {
        return this.upgradeAttemptCount;
    }
}

