/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.ConfigTrustManager;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.SyncFileAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import sun.net.www.protocol.https.Handler;

class ClientConfig
extends Config {
    private boolean _configOK = false;
    private Properties _systemProps;
    private Properties _internalProps;
    private Properties _lockedProps;
    protected Properties _changedProps;
    private boolean _userConfigStore;
    protected boolean _dirty;
    private File _userConfigFile;
    private SyncFileAccess _userConfigFileSyncAccess;
    private String _enterprizeConfig = null;
    private long _lastChanged;

    public ClientConfig() {
        PerfLogger.setTime("Start Client Config Constructor");
        this.init(null, null);
        PerfLogger.setTime("End Client Config Constructor");
    }

    public Object setProperty(String string, String string2) {
        if (this.isDiskNewer()) {
            this.refreshIfNeeded();
        }
        String string3 = super.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            if (this.containsKey(string) && !this.isInternalProp(string)) {
                this._dirty = true;
            }
            this.remove(string);
            this._changedProps.remove(string);
        } else if (!string2.equals(string3)) {
            if (!this.isInternalProp(string)) {
                this._dirty = true;
            }
            super.setProperty(string, string2);
            this._changedProps.setProperty(string, string2);
        }
        return string3;
    }

    public boolean init(String string, String string2) {
        String string3;
        String string4;
        Object object;
        Serializable serializable;
        PerfLogger.setTime("Start ClientConfig.init");
        boolean bl = true;
        this._systemProps = new Properties();
        this._internalProps = this.getInternalProps();
        this._changedProps = new Properties();
        this._userConfigStore = false;
        if (string == null) {
            this._userConfigFile = new File(ClientConfig.getUserHome() + File.separator + ClientConfig.getPropertiesFilename());
            this._userConfigStore = true;
        } else if (!string.equals("")) {
            this._userConfigFile = new File(string);
            if (!this._userConfigFile.exists()) {
                this._userConfigFile = null;
                Trace.println("Test user config file given: " + string + " is non existant", TraceLevel.BASIC);
            }
        } else {
            this._userConfigFile = null;
        }
        if (this._userConfigFile != null) {
            this._userConfigFileSyncAccess = new SyncFileAccess(this._userConfigFile);
        }
        PerfLogger.setTime("  - Start load system properties");
        if (string2 == null) {
            serializable = new File(ClientConfig.getSystemHome() + File.separator + "deployment.config");
            if (!((File)serializable).exists()) {
                serializable = new File(Environment.getDeploymentHomePath() + File.separator + "lib" + File.separator + "deployment.config");
            }
            if (!((File)serializable).exists()) {
                serializable = new File(Environment.getJavaHome() + File.separator + "lib" + File.separator + "deployment.config");
            }
            if (((File)serializable).exists() && (object = this.loadPropertiesFile(new Properties(), (File)serializable)) != null) {
                string4 = ((Properties)object).getProperty("deployment.system.config.mandatory");
                boolean bl2 = string4 != null && !string4.equalsIgnoreCase("false");
                this._enterprizeConfig = string3 = ((Properties)object).getProperty("deployment.system.config");
                if (string3 != null && !this.tryDownloading(string3, this._systemProps)) {
                    bl = !bl2;
                }
            }
        } else {
            bl = true;
            if (!string2.equals("")) {
                serializable = new File(string2);
                if (((File)serializable).exists()) {
                    this.loadPropertiesFile(this._systemProps, (File)serializable);
                } else {
                    Trace.println("Test system config file given: " + string2 + " is non existant", TraceLevel.BASIC);
                }
            }
        }
        PerfLogger.setTime("  - End load system properties");
        this.refreshProperties();
        PerfLogger.setTime("  - End refreshProperties");
        this.versionUpdateCheck();
        PerfLogger.setTime("  - end VersionUpdateCheck");
        serializable = System.getProperties();
        PerfLogger.setTime("  - end getting all system properties");
        object = this.propertyNames();
        while (object.hasMoreElements()) {
            string4 = (String)object.nextElement();
            String string5 = ClientConfig.getStringProperty(string4);
            if (string5 == null) continue;
            ((Properties)serializable).put(string4, string5);
        }
        System.setProperties((Properties)serializable);
        PerfLogger.setTime("  - end setting all system properties");
        this.setPolicyFiles();
        if (this._userConfigFile != null) {
            for (int i = 0; i < PROXY_KEYS.length; ++i) {
                String string6 = PROXY_KEYS[i];
                string3 = "active." + string6;
                this.setProperty(string3, this.getProperty(string6));
            }
        }
        PerfLogger.setTime("End Config.init");
        this._configOK = bl;
        return bl;
    }

    private void refreshProperties() {
        String string;
        String string2;
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        Properties properties3 = new Properties();
        Properties properties4 = new Properties();
        Properties properties5 = new Properties();
        this._lockedProps = new Properties();
        this.clear();
        this.putAll((Map<?, ?>)ClientConfig.getDefaults());
        if (this._userConfigFile == null) {
            properties.clear();
        } else if (this._userConfigFile.exists()) {
            PerfLogger.setTime("Start loadPropertiesFile");
            this.loadPropertiesFile(properties, this._userConfigFile);
            PerfLogger.setTime("End loadPropertiesFile");
            this._lastChanged = this._userConfigFile.lastModified();
        } else {
            this._lastChanged = System.currentTimeMillis();
        }
        Enumeration<Object> enumeration = this._systemProps.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = this._systemProps.getProperty(string2);
            if (string2.startsWith("deployment.javaws.jre.")) {
                properties3.setProperty(string2, string);
                continue;
            }
            if (string2.endsWith(".locked")) {
                int n = string2.length() - ".locked".length();
                String string3 = this._systemProps.getProperty(string2 = string2.substring(0, n));
                if (string3 == null) continue;
                this.lockProperty(string2, string3);
                continue;
            }
            if (!string2.startsWith("deployment.")) continue;
            this.setProperty(string2, string);
        }
        enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = properties.getProperty(string2);
            if (string2.startsWith("deployment.javaws.jre.")) {
                properties2.setProperty(string2, string);
                continue;
            }
            if (string2.startsWith("deployment.javapi.jre.")) {
                properties4.setProperty(string2, string);
                continue;
            }
            if (string2.startsWith("deployment.javapi.jdk.")) {
                properties5.setProperty(string2, string);
                continue;
            }
            if (!string2.startsWith("deployment.") && !string2.startsWith("javaplugin")) continue;
            this.setProperty(string2, string);
        }
        enumeration = this._lockedProps.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            this.setProperty(string2, this._lockedProps.getProperty(string2));
        }
        PerfLogger.setTime(" - Start JREInfo.initialize");
        JREInfo.initialize(properties3, properties2);
        PerfLogger.setTime(" - End JREInfo.initialize");
        JREInfo.importJpiEntries(properties4);
        PerfLogger.setTime(" - end importing JPI entries");
        this._dirty = false;
        this._changedProps.clear();
        this.getInternalPropValues();
    }

    public void getInternalPropValues() {
        if (ClientConfig.getOSName().equals("Windows")) {
            if (Platform.get().isPlatformWindowsVista() || !Platform.get().hasAdminPrivileges()) {
                this.lockProperty("deployment.browser.vm.iexplorer", new Boolean(true).toString());
            } else {
                this.unlockProperty("deployment.browser.vm.iexplorer");
            }
            String string = this.getProperty("deployment.browser.vm.mozilla");
            if (!Platform.get().hasAdminPrivileges()) {
                this.lockProperty("deployment.browser.vm.mozilla", string);
            } else {
                this.unlockProperty("deployment.browser.vm.mozilla");
            }
            Collection collection = Platform.get().getInstalledJfxRuntimes(true);
            if (collection.isEmpty()) {
                this.lockProperty("deployment.javafx.mode.enabled", this.getProperty("deployment.javafx.mode.enabled"));
            } else {
                this.unlockProperty("deployment.javafx.mode.enabled");
            }
        }
        if (this._userConfigFile != null) {
            this.getJavaPlugin();
            this.getJqs();
            this.getJavaFX();
        }
    }

    private void setPolicyFiles() {
        String string;
        String string2 = this.getProperty("deployment.system.security.policy");
        if (string2 != null) {
            string2 = ClientConfig.replaceVariables(string2).trim();
        }
        if ((string = this.getProperty("deployment.user.security.policy")) != null) {
            string = ClientConfig.replaceVariables(string).trim();
        }
        if (string2 != null || string != null) {
            int n = 1;
            String string3 = null;
            while ((string3 = Security.getProperty("policy.url." + n)) != null) {
                ++n;
            }
            if (string2 != null) {
                Security.setProperty("policy.url." + n, string2);
                ++n;
            }
            if (string != null) {
                Security.setProperty("policy.url." + n, string);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryDownloading(String string, Properties properties) {
        URLConnection uRLConnection = null;
        try {
            URL uRL = null;
            uRL = string.toLowerCase().startsWith("https:") ? new URL(null, string, new Handler()) : new URL(string);
            uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpsURLConnection) {
                ConfigTrustManager.resetHttpsFactory((HttpsURLConnection)uRLConnection);
            }
            InputStream inputStream = uRLConnection.getInputStream();
            properties.load(inputStream);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (uRLConnection != null && uRLConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)uRLConnection).disconnect();
            }
        }
    }

    public void refreshUnchangedProps() {
        Properties properties = this._changedProps;
        this.refreshProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    public boolean isDiskNewer() {
        return this._userConfigFile != null && this._userConfigFile.exists() && this._userConfigFile.lastModified() > this._lastChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfig() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Properties properties;
        if (!this._userConfigStore) {
            return;
        }
        if (this._dirty && this.isDiskNewer()) {
            properties = this._changedProps;
            this.refreshProperties();
            object4 = properties.keys();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                this.setProperty((String)object3, properties.getProperty((String)object3));
            }
        }
        properties = new Properties();
        object4 = new Properties();
        object3 = this.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (this.isPropertyLocked((String)object2) || this.isInternalProp((String)object2)) continue;
            String string = this.getProperty((String)object2);
            String string2 = this._systemProps.getProperty((String)object2);
            object = ClientConfig.getDefaults().getProperty((String)object2);
            if (string != null && (string2 == null || string.equals(string2)) && (string2 != null || string.equals(object))) continue;
            properties.setProperty((String)object2, string);
        }
        object2 = JREInfo.getAll();
        int n = 0;
        for (int i = 0; i < ((JREInfo[])object2).length; ++i) {
            if (object2[i].isSystemJRE() || Environment.isForcedJreRoot(object2[i].getPath())) continue;
            if (object2[i].getPlatform() != null) {
                ((Properties)object4).setProperty("deployment.javaws.jre." + n + ".platform", object2[i].getPlatform());
            }
            if (object2[i].getProduct() != null) {
                ((Properties)object4).setProperty("deployment.javaws.jre." + n + ".product", object2[i].getProduct());
            }
            if (object2[i].getLocation() != null) {
                ((Properties)object4).setProperty("deployment.javaws.jre." + n + ".location", object2[i].getLocation());
            }
            if (object2[i].getPath() != null) {
                ((Properties)object4).setProperty("deployment.javaws.jre." + n + ".path", object2[i].getPath());
            }
            if (object2[i].getVmArgs() != null) {
                ((Properties)object4).setProperty("deployment.javaws.jre." + n + ".args", object2[i].getVmArgs());
            }
            if (object2[i].getOSArch() != null) {
                ((Properties)object4).setProperty("deployment.javaws.jre." + n + ".osarch", object2[i].getOSArch());
            }
            if (object2[i].getOSName() != null) {
                ((Properties)object4).setProperty("deployment.javaws.jre." + n + ".osname", object2[i].getOSName());
            }
            ((Properties)object4).setProperty("deployment.javaws.jre." + n + ".enabled", ClientConfig.booleanToString(object2[i].isEnabled()));
            ((Properties)object4).setProperty("deployment.javaws.jre." + n + ".registered", ClientConfig.booleanToString(object2[i].isRegistered()));
            ++n;
        }
        this._userConfigFile.getParentFile().mkdirs();
        try {
            SyncFileAccess.FileOutputStreamLock fileOutputStreamLock = this._userConfigFileSyncAccess.openLockFileOutputStream(false, 2000, false);
            object = fileOutputStreamLock != null ? fileOutputStreamLock.getFileOutputStream() : new FileOutputStream(this._userConfigFile);
            try {
                if (object != null) {
                    try {
                        properties.store((OutputStream)object, ClientConfig.getPropertiesFilename());
                        ((Properties)object4).store((OutputStream)object, "Java Deployment jre's");
                    }
                    catch (IOException iOException) {
                        Trace.println("Exception: " + iOException, TraceLevel.BASIC);
                    }
                }
            }
            finally {
                if (object != null) {
                    ((OutputStream)object).flush();
                    try {
                        ((FileOutputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStreamLock != null) {
                    fileOutputStreamLock.release();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._dirty = false;
        this._changedProps.clear();
        this._lastChanged = this._userConfigFile.exists() ? this._userConfigFile.lastModified() : System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFile(Properties properties, File file) {
        SyncFileAccess.FObjLock fObjLock = null;
        FileInputStream fileInputStream = null;
        try {
            fObjLock = file.equals(this._userConfigFile) ? this._userConfigFileSyncAccess.openLockFileInputStream(1000, false) : null;
            fileInputStream = fObjLock != null ? ((SyncFileAccess.FileInputStreamLock)fObjLock).getFileInputStream() : new FileInputStream(file);
            properties.load(fileInputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.println("Cannot find prop file: " + file.getAbsolutePath(), TraceLevel.BASIC);
            Properties properties3 = null;
            return properties3;
        }
        catch (IOException iOException) {
            Trace.println("IO Execption: " + iOException, TraceLevel.BASIC);
            Properties properties4 = null;
            return properties4;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fObjLock != null) {
                fObjLock.release();
            }
        }
    }

    private Properties getInternalProps() {
        Properties properties = new Properties();
        properties.setProperty("java.quick.starter", "false");
        properties.setProperty("deployment.browser.vm.iexplorer", "true");
        properties.setProperty("deployment.browser.vm.mozilla", "true");
        properties.setProperty("deployment.javafx.mode.enabled", "true");
        properties.setProperty("deployment.jpi.mode.new", "true");
        return properties;
    }

    public boolean isInternalProp(String string) {
        return this._internalProps.containsKey(string) || string.startsWith("active.");
    }

    private void versionUpdateCheck() {
        String string = "6.0";
        if (this._userConfigStore) {
            string = this.getProperty("deployment.version");
        }
        if (string == null || string.compareTo("1.5.0") < 0) {
            String string2;
            Object object;
            Properties properties = this.translateMantisProperties(this);
            if (properties.getProperty("deployment.javaws.cachedir") == null && new File((String)(object = ClientConfig.getUserHome() + File.separator + "javaws" + File.separator + "cache")).exists()) {
                properties.setProperty("deployment.javaws.cachedir", (String)object);
            }
            object = null;
            File file = new File(ClientConfig.getUserHome());
            String string3 = file.getParent() + File.separator + ".deployment";
            String string4 = string3 + File.separator + "deployment.properties";
            File file2 = new File(string4);
            if (file2.exists() && ((Properties)(object = this.translateMantisProperties(this.loadPropertiesFile(new Properties(), file2)))).getProperty("deployment.javaws.cachedir") == null && new File(string2 = string3 + File.separator + "javaws" + File.separator + "cache").exists()) {
                ((Properties)object).setProperty("deployment.javaws.cachedir", string2);
            }
            if (object != null) {
                this.setProperties((Properties)object);
            }
            if (properties != null) {
                this.setProperties(properties);
            }
            this.setProperty("deployment.browser.path", Platform.get().getBrowserPath());
            string = "1.5.0";
        }
        if (string.compareTo("6.0") < 0) {
            this.setProperties(this.translateTigerProperties(this));
            this.setProperty("deployment.version", "6.0");
            ClientConfig.setBooleanProperty("deployment.javaws.cache.update", true);
            ClientConfig.setBooleanProperty("deployment.javapi.cache.update", true);
            ClientConfig.setBooleanProperty("deployment.capture.mime.types", true);
            this.storeIfNeeded();
        }
    }

    private void setProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    private Properties translateMantisProperties(Properties properties) {
        String string;
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = null;
            String string3 = properties.getProperty(string);
            if (string.startsWith("deployment.javaws.proxy")) {
                if (string.equals("deployment.javaws.proxy.httpport")) {
                    string2 = "deployment.proxy.http.port";
                } else if (string.equals("deployment.javaws.proxy.http")) {
                    string2 = "deployment.proxy.http.host";
                } else if (string.equals("deployment.javaws.proxy.httpproxyoverride")) {
                    string2 = "deployment.proxy.override.hosts";
                }
            } else if (string.startsWith("deployment.javaws.")) {
                if (string.equals("deployment.javaws.logFileName")) {
                    string2 = "deployment.javaws.traceFileName";
                } else if (string.equals("deployment.javaws.showConsole")) {
                    if (string3.equals("true")) {
                        string2 = "deployment.console.startup.mode";
                        string3 = "SHOW";
                    }
                } else if (string.equals("deployment.javaws.updateTimeout")) {
                    string2 = "deployment.javaws.update.timeout";
                } else if (string.equals("deployment.javaws.version")) {
                    string3 = null;
                }
            } else if (string.startsWith("javaplugin")) {
                properties2.setProperty(string, string3);
                if (string.equals("javaplugin.cache.disabled")) {
                    string2 = "deployment.cache.enabled";
                    string3 = string3.equals("true") ? "false" : "true";
                } else if (string.equals("javaplugin.cache.size")) {
                    string2 = "deployment.cache.max.size";
                } else if (string.equals("javaplugin.cache.compression")) {
                    string2 = "deployment.cache.jarcompression";
                } else if (string.equals("javaplugin.console")) {
                    string2 = "deployment.console.startup.mode";
                    string3 = string3.equals("show") ? "SHOW" : (string3.equals("hide") ? "HIDE" : "DISABLE");
                } else if (string.equals("javaplugin.exception")) {
                    string2 = "deployment.javapi.lifecycle.exception";
                }
            }
            if (string2 == null || string3 == null || string3.length() <= 0) continue;
            properties2.setProperty(string2, string3);
        }
        string = properties.getProperty("deployment.javaws.cache.dir");
        if (string != null) {
            properties2.setProperty("deployment.javaws.cachedir", string);
        }
        return properties2;
    }

    private Properties translateTigerProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("deployment.javaws.associations") && (string2.equals("NEW_ONLY") || string2.equals("REPLACE_ASK"))) {
                string2 = "ASK_USER";
            }
            properties2.setProperty(string, string2);
        }
        return properties2;
    }

    public boolean getJavaPlugin() {
        boolean bl = true;
        if (ClientConfig.getOSArch().equalsIgnoreCase("amd64")) {
            this.lockProperty("deployment.jpi.mode.new", new Boolean(bl).toString());
        } else {
            bl = Platform.get().getJavaPluginSettings();
            if (!Platform.get().canBecomeAdmin()) {
                this.lockProperty("deployment.jpi.mode.new", new Boolean(bl).toString());
            } else {
                this.unlockProperty("deployment.jpi.mode.new");
            }
        }
        this.setProperty("deployment.jpi.mode.new", new Boolean(bl).toString());
        return bl;
    }

    public boolean getJqs() {
        boolean bl = Platform.get().getJqsSettings();
        if (Platform.get().isPlatformWindowsVista()) {
            this.lockProperty("java.quick.starter", "false");
        } else {
            this.unlockProperty("java.quick.starter");
        }
        this.setProperty("java.quick.starter", new Boolean(bl).toString());
        return bl;
    }

    public void getJavaFX() {
        boolean bl = Platform.get().isJavaFXEnabled();
        this.setProperty("deployment.javafx.mode.enabled", new Boolean(bl).toString());
    }

    void lockProperty(String string, String string2) {
        if (this._lockedProps == null) {
            this._lockedProps = new Properties();
        }
        this._lockedProps.setProperty(string, string2);
    }

    void unlockProperty(String string) {
        if (this._lockedProps != null) {
            this._lockedProps.remove(string);
        }
    }

    public boolean isPropertyLocked(String string) {
        if (this._lockedProps == null) {
            return false;
        }
        return this._lockedProps.containsKey(string);
    }

    public void storeIfNeeded() {
        if (this._dirty) {
            this.storeConfig();
        }
    }

    public void refreshIfNeeded() {
        if (!this._dirty && this.isDiskNewer()) {
            this.refreshProperties();
        }
    }

    public void storeInstalledJREs(Vector vector) {
        this._dirty |= JREInfo.setInstalledJREList(vector);
        this.storeIfNeeded();
    }

    public String getEnterpriseString() {
        return this._enterprizeConfig;
    }

    public boolean isValid() {
        return this._configOK;
    }

    public boolean isConfigDirty() {
        return this._dirty;
    }

    public Properties getSystemProps() {
        return this._systemProps;
    }
}

