/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import iaik.xsect.com.fourthpass.a;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public abstract class TransformService
implements Transform {
    private String algorithm;
    private Provider provider;
    private String mechanismType;
    private static final String TYPE = "TransformService";

    public abstract Data transform(Data var1, XMLCryptoContext var2, OutputStream var3) throws TransformException;

    public abstract Data transform(Data var1, XMLCryptoContext var2) throws TransformException;

    public abstract void marshalParams(XMLStructure var1, XMLCryptoContext var2) throws MarshalException;

    public abstract boolean isFeatureSupported(String var1);

    public abstract void init(TransformParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract void init(XMLStructure var1, XMLCryptoContext var2) throws InvalidAlgorithmParameterException;

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract AlgorithmParameterSpec getParameterSpec();

    public final String getMechanismType() {
        return this.mechanismType;
    }

    public static TransformService getInstance(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException("Argument 'algorithm' must not be null.");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'mechanismType' must not be null.");
        }
        if (provider == null) {
            throw new NullPointerException("Argument 'provider' must not be null.");
        }
        try {
            return TransformService.findInstance(string, string2, provider);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchAlgorithmException("Cannot find algorithm '" + string + "' for mechanism type '" + string2 + "'.");
        }
    }

    public static TransformService getInstance(String string, String string2, String string3) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException("Argument 'algorithm' must not be null.");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'mechanismType' must not be null.");
        }
        if (string3 == null) {
            throw new NullPointerException("Argument 'provider' must not be null.");
        }
        Provider provider = Security.getProvider(string3);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider named " + string3);
        }
        try {
            return TransformService.findInstance(string, string2, provider);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchAlgorithmException("Cannot find algorithm '" + string + "' for mechanism type '" + string2 + "'.");
        }
    }

    public static TransformService getInstance(String string, String string2) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException("Argument 'algorithm' must not be null.");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'mechanismType' must not be null.");
        }
        try {
            return TransformService.findInstance(string, string2, null);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchAlgorithmException("Cannot find algorithm '" + string + "' for mechanism type '" + string2 + "'.");
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    private static TransformService findInstance(String string, String string2, Provider serializable) throws NoSuchAlgorithmException, XMLSignatureException {
        Object object;
        Object object2;
        Serializable serializable2;
        Provider[] providerArray;
        String string3 = null;
        if (serializable != null) {
            Provider[] providerArray2 = new Provider[1];
            providerArray = providerArray2;
            providerArray2[0] = serializable;
        } else {
            providerArray = Security.getProviders();
        }
        Provider[] providerArray3 = providerArray;
        int n = 0;
        while (n < providerArray3.length) {
            String string4;
            serializable2 = providerArray3[n];
            object2 = ((Properties)serializable2).getProperty("Alg.Alias.TransformService." + string);
            object = "TransformService." + (String)(object2 != null ? object2 : string);
            String string5 = ((Properties)serializable2).getProperty((String)object);
            if (string5 != null && ((string4 = ((Properties)serializable2).getProperty(String.valueOf(object) + " MechanismType")) == null || string4.equalsIgnoreCase(string2))) {
                string3 = string5;
                serializable = serializable2;
                break;
            }
            ++n;
        }
        if (string3 == null) {
            throw new NoSuchAlgorithmException("Cannot find " + string2 + " mechanism type.");
        }
        try {
            object2 = serializable.getClass().getClassLoader();
            serializable2 = object2 != null ? ((ClassLoader)object2).loadClass(string3) : a.a(string3);
            object = (TransformService)((Class)serializable2).newInstance();
            ((TransformService)object).mechanismType = string2;
            ((TransformService)object).provider = serializable;
            ((TransformService)object).algorithm = string;
            return object;
        }
        catch (ClassCastException classCastException) {
            throw new XMLSignatureException("Class '" + string3 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " is not a " + TYPE + ".", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XMLSignatureException("Class '" + string3 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be found.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new XMLSignatureException("Class '" + string3 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be instantiated.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XMLSignatureException("Class '" + string3 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be accessed.", illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw new XMLSignatureException("Class '" + string3 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be accessed.", securityException);
        }
    }

    protected TransformService() {
    }
}

