/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import javax.jnlp.ExtensionInstallerService;

public final class ExtensionInstallerServiceImpl
implements ExtensionInstallerService {
    private LocalApplicationProperties _lap;
    private Preloader _progress;
    private String _target;
    private String _installPath;
    private boolean _failedJREInstall = false;
    static ExtensionInstallerServiceImpl _sharedInstance = null;

    private ExtensionInstallerServiceImpl(String string, LocalApplicationProperties localApplicationProperties, Preloader preloader) {
        this._lap = localApplicationProperties;
        this._progress = preloader;
        this._installPath = string;
    }

    public static synchronized ExtensionInstallerServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static synchronized void initialize(String string, LocalApplicationProperties localApplicationProperties, Preloader preloader) {
        if (_sharedInstance == null) {
            _sharedInstance = new ExtensionInstallerServiceImpl(string, localApplicationProperties, preloader);
        }
    }

    public String getInstallPath() {
        return this._installPath;
    }

    public String getExtensionVersion() {
        return this._lap.getVersionId();
    }

    public URL getExtensionLocation() {
        return this._lap.getLocation();
    }

    public String getInstalledJRE(URL uRL, String string) {
        JREInfo jREInfo = LaunchSelection.selectJRE(uRL, string);
        return jREInfo != null ? jREInfo.getPath() : null;
    }

    public void setHeading(String string) {
        try {
            this._progress.handleEvent((PreloaderEvent)new ConfigEvent(2, string));
        }
        catch (CancelException cancelException) {
            throw new RuntimeException(cancelException);
        }
    }

    public void setStatus(String string) {
        try {
            this._progress.handleEvent((PreloaderEvent)new ConfigEvent(1, string));
        }
        catch (CancelException cancelException) {
            throw new RuntimeException(cancelException);
        }
    }

    public void updateProgress(int n) {
        try {
            DownloadEvent downloadEvent = new DownloadEvent(0, null, null, null, 100L, 100L, n);
            downloadEvent.sendExplicitEvent(true);
            this._progress.handleEvent((PreloaderEvent)downloadEvent);
        }
        catch (CancelException cancelException) {
            cancelException.printStackTrace();
            throw new RuntimeException(cancelException);
        }
    }

    public void hideProgressBar() {
        try {
            this._progress.handleEvent((PreloaderEvent)new ConfigEvent(5));
        }
        catch (CancelException cancelException) {
            throw new RuntimeException(cancelException);
        }
    }

    public void hideStatusWindow() {
        try {
            this._progress.handleEvent((PreloaderEvent)new ConfigEvent(6));
        }
        catch (CancelException cancelException) {
            throw new RuntimeException(cancelException);
        }
    }

    public void setJREInfo(String string, String string2) {
        int n = JNLPClassLoaderUtil.getInstance().getDefaultSecurityModel();
        if (n != 1 && n != 2) {
            throw new SecurityException("Unsigned extension installer attempting to call setJREInfo.");
        }
        Trace.println((String)("setJREInfo: " + string2), (TraceLevel)TraceLevel.EXTENSIONS);
        if (string2 != null && new File(string2).exists()) {
            JREInfo.removeJREsIn((String)string2);
            JREInfo.addJRE((JREInfo)new JREInfo(string, this.getExtensionVersion(), this.getExtensionLocation().toString(), string2, null, Config.getOSName(), Config.getOSArch(), true, false));
        } else {
            Trace.println((String)"jre install failed: jrePath invalid", (TraceLevel)TraceLevel.EXTENSIONS);
            this._failedJREInstall = true;
        }
    }

    public void setNativeLibraryInfo(String string) {
        Trace.println((String)("setNativeLibInfo: " + string), (TraceLevel)TraceLevel.EXTENSIONS);
        this._lap.setNativeLibDirectory(string);
    }

    public void installFailed() {
        Trace.println((String)"installFailed", (TraceLevel)TraceLevel.EXTENSIONS);
        try {
            Main.systemExit(1);
        }
        catch (ExitException exitException) {
            Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)exitException);
        }
    }

    public void installSucceeded(boolean bl) {
        if (this._failedJREInstall) {
            return;
        }
        Trace.println((String)"installSucceded", (TraceLevel)TraceLevel.EXTENSIONS);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Config.get().storeIfNeeded();
                return null;
            }
        });
        this._lap.setInstallDirectory(this._installPath);
        this._lap.setLastAccessed(new Date());
        if (bl) {
            this._lap.setRebootNeeded(true);
        } else {
            this._lap.setExtensionInstalled(true);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ExtensionInstallerServiceImpl.this._lap.store();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                LaunchErrorDialog.show(this._progress.getOwner(), (IOException)privilegedActionException.getException(), false);
            }
            Trace.ignoredException((Exception)privilegedActionException.getException());
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ExtensionInstallerServiceImpl.this._progress.handleEvent((PreloaderEvent)new InitEvent(3));
                    Main.systemExit(0);
                }
                catch (CancelException cancelException) {
                    throw new RuntimeException(cancelException);
                }
                catch (ExitException exitException) {
                    Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException);
                }
                return null;
            }
        });
    }
}

