/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.cache.AssociationDesc;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.jnlp.JNLPClassLoaderIf;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.IntegrationService;

public class IntegrationServiceImpl
implements IntegrationService {
    private JNLPClassLoaderIf jnlpClassLoader;
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public IntegrationServiceImpl(JNLPClassLoaderIf jNLPClassLoaderIf) {
        this.jnlpClassLoader = jNLPClassLoaderIf;
    }

    public boolean requestShortcut(boolean bl, boolean bl2, String string) {
        final boolean bl3 = bl || bl2;
        final LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        InformationDesc informationDesc = launchDesc.getInformation();
        informationDesc.setShortcut(new ShortcutDesc(true, false, bl, bl2, string));
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        Boolean bl4 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl = false;
                if (localInstallHandler.isLocalInstallSupported()) {
                    bl = localInstallHandler.performIntegration(null, launchDesc, localApplicationProperties, false, true, false);
                    try {
                        localApplicationProperties.store();
                    }
                    catch (Exception exception) {}
                } else {
                    bl = !bl3;
                }
                return bl;
            }
        });
        return bl4;
    }

    public boolean hasDesktopShortcut() {
        return this.hasShortcut(0);
    }

    public boolean hasMenuShortcut() {
        return this.hasShortcut(1);
    }

    private boolean hasShortcut(int n) {
        LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        boolean[] blArray = (boolean[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return localInstallHandler.whichShortcutsExist(localApplicationProperties);
            }
        });
        return blArray[n];
    }

    private LocalApplicationProperties getLocalApplicationProperties(final LaunchDesc launchDesc) {
        LocalApplicationProperties localApplicationProperties = (LocalApplicationProperties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL = launchDesc.getCanonicalHome();
                return Cache.getLocalApplicationProperties((URL)uRL);
            }
        });
        return localApplicationProperties;
    }

    public boolean removeShortcuts() {
        final LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl = localInstallHandler.uninstallShortcuts(launchDesc, localApplicationProperties);
                try {
                    localApplicationProperties.store();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl;
            }
        });
        return bl;
    }

    public boolean requestAssociation(String string, String[] stringArray) {
        this.validateAssociationArguments(string, stringArray);
        final LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        InformationDesc informationDesc = launchDesc.getInformation();
        AssociationDesc associationDesc = this.createAssociationDesc(string, stringArray);
        informationDesc.setAssociation(associationDesc);
        final LocalApplicationProperties localApplicationProperties = this.getLocalApplicationProperties(launchDesc);
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl = false;
                if (localInstallHandler.isAssociationSupported()) {
                    bl = localInstallHandler.performIntegration(null, launchDesc, localApplicationProperties, false, false, true);
                }
                return bl;
            }
        });
    }

    public boolean hasAssociation(String string, String[] stringArray) {
        this.validateAssociationArguments(string, stringArray);
        final Association association = this.createAssociation(string, stringArray);
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return localInstallHandler.hasAssociation(association);
            }
        });
    }

    public boolean removeAssociation(String string, String[] stringArray) {
        this.validateAssociationArguments(string, stringArray);
        final Association association = this.createAssociation(string, stringArray);
        final LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Boolean bl = Boolean.TRUE;
                if (localInstallHandler.isAssociationSupported()) {
                    try {
                        localInstallHandler.unregisterAssociationInternal(association);
                    }
                    catch (AssociationNotRegisteredException associationNotRegisteredException) {
                        bl = Boolean.FALSE;
                    }
                    catch (RegisterFailedException registerFailedException) {
                        bl = Boolean.FALSE;
                    }
                }
                return bl;
            }
        });
    }

    private void validateAssociationArguments(String string, String[] stringArray) {
        this.validateMimeType(string);
        this.validateExtensions(stringArray);
    }

    private void validateExtensions(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Null extensions array not allowed");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) {
                throw new IllegalArgumentException("Null extension not allowed");
            }
            if (!string.equals("")) continue;
            throw new IllegalArgumentException("Empty extension not allowed");
        }
    }

    private void validateMimeType(String string) {
        String string2;
        String string3;
        if (string == null) {
            throw new IllegalArgumentException("Null mimetype not allowed");
        }
        int n = string.indexOf(47);
        int n2 = string.indexOf(59);
        if (n < 0 && n2 < 0) {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
        if (n < 0 && n2 >= 0) {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
        if (n >= 0 && n2 < 0) {
            string3 = string.substring(0, n).trim().toLowerCase();
            string2 = string.substring(n + 1).trim().toLowerCase();
        } else if (n < n2) {
            string3 = string.substring(0, n).trim().toLowerCase();
            string2 = string.substring(n + 1, n2).trim().toLowerCase();
        } else {
            throw new IllegalArgumentException("Unable to find a sub type.");
        }
        if (!this.isValidToken(string3)) {
            throw new IllegalArgumentException("Primary type is invalid.");
        }
        if (!this.isValidToken(string2)) {
            throw new IllegalArgumentException("Sub type is invalid.");
        }
    }

    private boolean isValidToken(String string) {
        int n = string.length();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (IntegrationServiceImpl.isTokenChar(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private Association createAssociation(String string, String[] stringArray) {
        Association association = new Association();
        association.setMimeType(string);
        for (int i = 0; i < stringArray.length; ++i) {
            association.addFileExtension(stringArray[i]);
        }
        LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        association.setName(this.getAssociationDescription(launchDesc));
        return association;
    }

    private AssociationDesc createAssociationDesc(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= i - 1) continue;
            stringBuilder.append(' ');
        }
        LaunchDesc launchDesc = this.jnlpClassLoader.getLaunchDesc();
        AssociationDesc associationDesc = new AssociationDesc(stringBuilder.toString(), string, this.getAssociationDescription(launchDesc), null);
        return associationDesc;
    }

    private String getAssociationDescription(LaunchDesc launchDesc) {
        return launchDesc.getInformation().getTitle();
    }
}

