/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.pki.manager;

import cryptotools.CertificateUtils;
import it.sogei.rcp.pki.Activator;
import it.sogei.rcp.pki.exception.PkiException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import pkcs10.PKCS10CertificateRequestUtil;

public class PKIManager {
    private static final String KEY_USAGE_SIGN = "Firma";
    private static final String KEY_USAGE_CHIPER = "Cifra";
    private static final String VALIDITY_STATUS_VALID = "Valido";
    private static final String VALIDITY_STATUS_NOT_VALID_YET = "Non ancora valido";
    private static final String VALIDITY_STATUS_EXPIRED = "Scaduto";
    private static final String VALIDITY_STATUS_EXPIRING_SOON = "Sta per scadere";

    public PKIManager() {
        CertificateUtils.installBCProvider();
    }

    public static byte[] createKeyStoreAndPKCS10(String pathKeyStore, String passKeyStore, String dn) throws PkiException {
        byte[][] certificati;
        KeyPair[] kp = new KeyPair[1];
        try {
            certificati = new byte[1][3000];
            URL filePath = Activator.getDefault().getBundle().getResource("resource/CADogane.pem");
            InputStream fi = filePath.openStream();
            fi.read(certificati[0]);
            fi.close();
        }
        catch (Exception e) {
            throw new PkiException(e.getMessage(), e);
        }
        kp[0] = PKIManager.createKeyPair();
        byte[] pkcs10 = PKIManager.createPKCS10(dn, kp[0]);
        PKIManager.createKeyStoreAndDummyCertificate(pathKeyStore, kp, passKeyStore, certificati);
        return pkcs10;
    }

    public static KeyPair createKeyPair() throws PkiException {
        KeyPair kp = null;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(1024);
            kp = keyGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new PkiException(e.getMessage(), e);
        }
        return kp;
    }

    public static byte[] createPKCS10(String dn, KeyPair key) throws PkiException {
        X500Principal subjectName = new X500Principal(dn);
        PKCS10CertificationRequest certReq = null;
        try {
            certReq = new PKCS10CertificationRequest("SHA1withRSA", subjectName, key.getPublic(), null, key.getPrivate(), null);
        }
        catch (Exception e) {
            throw new PkiException(e.getMessage(), e);
        }
        return certReq.getEncoded();
    }

    public static void createKeyStoreAndDummyCertificate(String pathKeyStore, KeyPair[] key, String password, byte[][] listacertificati) throws PkiException {
        FileOutputStream fos = null;
        try {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(listacertificati[0]));
                KeyStore ks = KeyStore.getInstance("PKCS12");
                char[] psw = password.toCharArray();
                ks.load(null, psw);
                Certificate[] lcerts = new X509Certificate[]{cert};
                ks.setKeyEntry("SSL", key[0].getPrivate(), psw, lcerts);
                fos = new FileOutputStream(pathKeyStore);
                ks.store(fos, psw);
                fos.close();
            }
            catch (Exception e) {
                throw new PkiException(e.getMessage(), e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new PkiException(e.getMessage(), e);
                }
            }
        }
    }

    public static void importX509(String pathKeyStore, String password, byte[][] listacertificati) throws PkiException {
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                int i = 0;
                while (i < listacertificati.length) {
                    fis = new FileInputStream(pathKeyStore);
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(listacertificati[i]));
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    char[] psw = password.toCharArray();
                    ks.load(fis, psw);
                    Certificate[] lcerts = new X509Certificate[]{cert};
                    Key pk = ks.getKey("SSL", psw);
                    ks.deleteEntry("SSL");
                    ks.setKeyEntry("SSL", pk, psw, lcerts);
                    fos = new FileOutputStream(pathKeyStore);
                    ks.store(fos, psw);
                    fos.close();
                    ++i;
                }
            }
            catch (Exception e) {
                throw new PkiException(e.getMessage(), e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new PkiException(e.getMessage(), e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new PkiException(e.getMessage(), e);
                }
            }
        }
    }

    public static void importX509BC(String alias, String pathKeyStore, String password, byte[][] listacertificati) throws PkiException {
        CertificateUtils.installBCProvider();
        FileOutputStream fos = null;
        FileInputStream fis = null;
        Key pk = null;
        try {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                int i = 0;
                while (i < listacertificati.length) {
                    fis = new FileInputStream(pathKeyStore);
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(listacertificati[i]));
                    KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
                    char[] psw = password.toCharArray();
                    ks.load(fis, psw);
                    Certificate[] lcerts = new X509Certificate[]{cert};
                    fos = new FileOutputStream(pathKeyStore);
                    pk = ks.getKey(alias, psw);
                    ks.deleteEntry(alias);
                    ks.setKeyEntry(alias, pk, psw, lcerts);
                    ks.store(fos, psw);
                    fos.close();
                    ++i;
                }
            }
            catch (Exception e) {
                throw new PkiException(e.getMessage(), e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new PkiException(e.getMessage(), e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new PkiException(e.getMessage(), e);
                }
            }
        }
    }

    public static void importCert(String cert, String keystorePassword, String keystoreFile, String alias, String dir) throws PkiException {
        CertificateUtils.installBCProvider();
        PKCS10CertificateRequestUtil pkcs10CertificateRequest = new PKCS10CertificateRequestUtil();
        try {
            pkcs10CertificateRequest.importCertificate(cert, keystorePassword, keystoreFile, alias, dir);
        }
        catch (Exception e) {
            throw new PkiException(e.getMessage(), e);
        }
    }

    public static void importCert(byte[] cert, String keystorePassword, String keystoreFile, String alias, String dir) throws PkiException {
        CertificateUtils.installBCProvider();
        PKCS10CertificateRequestUtil pkcs10CertificateRequest = new PKCS10CertificateRequestUtil();
        try {
            pkcs10CertificateRequest.importCertificate(cert, keystorePassword, keystoreFile, alias, dir);
        }
        catch (Exception e) {
            throw new PkiException(e.getMessage(), e);
        }
    }

    public static LdapName getIssuerDN(X509Certificate certificate) throws InvalidNameException {
        LdapName issuerDN = new LdapName(certificate.getIssuerX500Principal().getName());
        return issuerDN;
    }

    public static LdapName getSubjectDN(X509Certificate certificate) throws InvalidNameException {
        LdapName issuerDN = new LdapName(certificate.getSubjectX500Principal().getName());
        return issuerDN;
    }

    public String getCACommonName(X509Certificate certificate) throws InvalidNameException {
        String cn = "";
        List<Rdn> rdns = PKIManager.getIssuerDN(certificate).getRdns();
        for (Rdn rdn : rdns) {
            if (!rdn.getType().equalsIgnoreCase("CN")) continue;
            cn = (String)rdn.getValue();
            break;
        }
        return cn;
    }

    public String getCACountry(X509Certificate certificate) throws InvalidNameException {
        String c = "";
        List<Rdn> rdns = PKIManager.getIssuerDN(certificate).getRdns();
        for (Rdn rdn : rdns) {
            if (!rdn.getType().equalsIgnoreCase("C")) continue;
            c = (String)rdn.getValue();
            break;
        }
        return c;
    }

    public String getCAOrganization(X509Certificate certificate) throws InvalidNameException {
        String o = "";
        List<Rdn> rdns = PKIManager.getIssuerDN(certificate).getRdns();
        for (Rdn rdn : rdns) {
            if (!rdn.getType().equalsIgnoreCase("O")) continue;
            o = (String)rdn.getValue();
            break;
        }
        return o;
    }

    public String getCAOrganizationUnit(X509Certificate certificate) throws InvalidNameException {
        String ou = "";
        List<Rdn> rdns = PKIManager.getIssuerDN(certificate).getRdns();
        for (Rdn rdn : rdns) {
            if (!rdn.getType().equalsIgnoreCase("OU")) continue;
            ou = (String)rdn.getValue();
            break;
        }
        return ou;
    }

    public String getCountry(X509Certificate certificate) throws InvalidNameException {
        String country = "";
        List<Rdn> rdns = PKIManager.getSubjectDN(certificate).getRdns();
        for (Rdn rdn : rdns) {
            if (!rdn.getType().equalsIgnoreCase("C")) continue;
            country = (String)rdn.getValue();
            break;
        }
        return country;
    }

    public String getOrganization(X509Certificate certificate) throws InvalidNameException {
        String o = "";
        List<Rdn> rdns = PKIManager.getSubjectDN(certificate).getRdns();
        for (Rdn rdn : rdns) {
            if (!rdn.getType().equalsIgnoreCase("O")) continue;
            o = (String)rdn.getValue();
            break;
        }
        return o;
    }

    public String getOrganizationUnit(X509Certificate certificate) throws InvalidNameException {
        String ou = "";
        List<Rdn> rdns = PKIManager.getSubjectDN(certificate).getRdns();
        for (Rdn rdn : rdns) {
            if (!rdn.getType().equalsIgnoreCase("OU")) continue;
            ou = (String)rdn.getValue();
            break;
        }
        return ou;
    }

    public String getVersion(X509Certificate certificate) {
        return String.valueOf(certificate.getVersion());
    }

    public BigInteger getSerialNumber(X509Certificate certificate) {
        return certificate.getSerialNumber();
    }

    public String getKeyUsage(X509Certificate certificate) {
        String descKeyUsage = "";
        boolean[] keyUsage = certificate.getKeyUsage();
        if (keyUsage != null) {
            if (keyUsage[1]) {
                descKeyUsage = KEY_USAGE_SIGN;
            }
            if (keyUsage[2] || keyUsage[3]) {
                descKeyUsage = descKeyUsage.equals("") ? KEY_USAGE_CHIPER : String.valueOf(descKeyUsage) + ", Firma";
            }
        }
        return descKeyUsage;
    }

    public Date getEndValidity(X509Certificate certificate) {
        return certificate.getNotAfter();
    }

    public Date getStartValidity(X509Certificate certificate) {
        return certificate.getNotBefore();
    }

    public String getValidityStatus(X509Certificate certificate) {
        String status = "";
        try {
            certificate.checkValidity();
            status = VALIDITY_STATUS_VALID;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            status = VALIDITY_STATUS_EXPIRED;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            status = VALIDITY_STATUS_NOT_VALID_YET;
        }
        return status;
    }

    public static List<X509Certificate> getCertificateList(String path, String password) throws Exception {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        CertificateUtils.installBCProvider();
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        String certFirma = path;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(certFirma);
                keystore.load(fis, password.toCharArray());
                fis.close();
            }
            catch (Exception exception) {
                String msg = "Errore nell'apertura del keystore " + certFirma;
                throw new Exception(msg);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new PkiException(e.getMessage(), e);
                }
            }
        }
        Enumeration<String> e = keystore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            X509Certificate cert = (X509Certificate)keystore.getCertificate(alias);
            if (cert == null) continue;
            list.add(cert);
        }
        return list;
    }
}

