/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2006;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TelemInputStream
extends FilterInputStream {
    private byte[] buf;
    private int count;
    private int pos;

    public TelemInputStream(InputStream in) {
        this(in, 102400);
    }

    public TelemInputStream(InputStream in, int bufferSize) {
        super(in);
        this.buf = new byte[bufferSize];
    }

    public synchronized int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.buf.length) {
                return this.in.read(b, off, len);
            }
            this.pos = 0;
            int n = this.in.read(this.buf);
            this.count = n <= 0 ? 0 : n;
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        boolean readingRequired = avail < len;
        int cnt = readingRequired ? avail : len;
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        if (readingRequired) {
            cnt += this.read(b, avail, len - avail);
        }
        return cnt;
    }
}

