/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.digest;

import iaik.xml.crypto.XSecProvider;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public abstract class ProxyMessageDigest
extends MessageDigestSpi {
    protected MessageDigest digest_;

    protected abstract String getMessageDigestName();

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest_.update(byArray, n, n2);
    }

    protected void engineUpdate(byte by) {
        this.digest_.update(by);
    }

    protected void engineReset() {
        this.digest_.reset();
    }

    protected int engineGetDigestLength() {
        return this.digest_.getDigestLength();
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        return this.digest_.digest(byArray, n, n2);
    }

    protected byte[] engineDigest() {
        return this.digest_.digest();
    }

    protected ProxyMessageDigest() throws NoSuchProviderException, NoSuchAlgorithmException {
        String string = this.getMessageDigestName();
        String string2 = XSecProvider.getDelegationProvider("MessageDigest." + string);
        if (string2 != null) {
            try {
                this.digest_ = MessageDigest.getInstance(string, string2);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException("MessageDigest." + string + " delegation provider '" + string2 + "' not registered.");
            }
        } else {
            this.digest_ = MessageDigest.getInstance(string);
        }
    }
}

