/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.database.handler;

import it.sogei.utilities.log4j.LogUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.derby.tools.ij;
import org.eclipse.core.runtime.Platform;

public class DerbyHandler {
    public String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    public String protocol = "jdbc:derby:";
    public String pathdb = String.valueOf(System.getProperty("user.dir")) + "/databases/";
    public static Connection conn;
    private String pluginId;

    public DerbyHandler(String pluginId) {
        try {
            this.pluginId = pluginId;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogUtil.log((Object)this, (int)4, (String)"Errore nell'instanziazione del driver embedded Derby.", (Throwable)ex);
        }
    }

    public void createDB(String dbname) throws Exception {
        Properties props = new Properties();
        props.put("user", "rcp");
        props.put("password", "rcp");
        try {
            conn = DriverManager.getConnection(String.valueOf(this.protocol) + this.pathdb + dbname + ";create=true", props);
            LogUtil.log((Object)this, (int)2, (String)("Creazione del database " + this.pathdb + dbname + " avvenuta con successo."));
        }
        catch (SQLException e) {
            e.printStackTrace();
            LogUtil.log((Object)this, (int)4, (String)("Errore nella creazione del database " + dbname), (Throwable)e);
            throw e;
        }
    }

    public Connection getDBConnection(String dbname) throws Exception {
        Properties props = new Properties();
        props.put("user", "rcp");
        props.put("password", "rcp");
        try {
            conn = DriverManager.getConnection(String.valueOf(this.protocol) + this.pathdb + dbname, props);
            LogUtil.log((Object)this, (int)2, (String)("Apertura del database " + this.pathdb + dbname + " avvenuta con successo."));
        }
        catch (SQLException e) {
            e.printStackTrace();
            LogUtil.log((Object)this, (int)4, (String)("Errore nell'apertura del database " + dbname), (Throwable)e);
            throw e;
        }
        return conn;
    }

    public void startDB() throws Exception {
        Class.forName(this.driver).newInstance();
    }

    public void stopDB(String dbname) {
        try {
            conn = DriverManager.getConnection(String.valueOf(this.protocol) + ";shutdown=true");
            LogUtil.log((Object)this, (int)2, (String)"Chiusura del database avvenuta con successo.");
        }
        catch (SQLException sQLException) {
            LogUtil.log((Object)this, (int)2, (String)"Chiusura del database avvenuta con successo.");
        }
    }

    public void execFileScript(String script) throws Exception {
        try {
            int res;
            InputStream fis = Platform.getBundle((String)this.pluginId).getResource(script).openStream();
            StringBuffer sb = new StringBuffer();
            byte[] letti = new byte[1024];
            while ((res = fis.read(letti)) != -1) {
                String buffer = new String(letti);
                sb.append(buffer.substring(0, res));
            }
            fis.close();
            String command = sb.toString();
            StringTokenizer st = new StringTokenizer(command, ";");
            String sqlCommand = null;
            while (st.hasMoreElements()) {
                try {
                    sqlCommand = (String)st.nextElement();
                    Statement s = conn.createStatement();
                    LogUtil.log((Object)this, (int)2, (String)("Creato lo statment <" + sqlCommand + ">"));
                    s.execute(sqlCommand);
                    s.close();
                }
                catch (SQLException sqlex) {
                    if (sqlCommand.toUpperCase().contains("DROP")) continue;
                    throw sqlex;
                }
            }
            conn.commit();
            LogUtil.log((Object)this, (int)2, (String)("Esecuzione script " + script + " avvenuta con successo."));
        }
        catch (Exception e) {
            LogUtil.log((Object)this, (int)4, (String)("Errore nell'esecuzione dello script " + script), (Throwable)e);
            throw e;
        }
    }

    public void execIJFileScript(String script) throws Exception {
        try {
            String[] arg = new String[]{script};
            ij.main((String[])arg);
            LogUtil.log((Object)this, (int)2, (String)("Esecuzione script " + script + " avvenuta con successo."));
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.log((Object)this, (int)4, (String)("Errore nell'esecuzione dello script " + script), (Throwable)e);
            throw e;
        }
    }

    public void queryTable() throws Exception {
        try {
            Statement s = conn.createStatement();
            LogUtil.log((Object)this, (int)2, (String)"Creato lo statment.");
            ResultSet rs = s.executeQuery("select * from OBJSTORE");
            LogUtil.log((Object)this, (int)2, (String)"Query Table");
            int i = 1;
            while (rs.next()) {
                String key = rs.getString(1);
                String id = rs.getString(2);
                LogUtil.log((Object)this, (int)2, (String)("Riga " + i + " key=" + key + " id=" + id));
                ++i;
            }
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            LogUtil.log((Object)this, (int)4, (String)"Errore nella query della tabella OBJSTORE.", (Throwable)e);
            throw e;
        }
    }
}

