/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import sun.security.ssl.CertificateMessage;
import sun.security.ssl.CertificateRequest;
import sun.security.ssl.CertificateStatus;
import sun.security.ssl.CertificateVerify;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ClientHello;
import sun.security.ssl.ClientKeyExchange;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.EncryptedExtensions;
import sun.security.ssl.Finished;
import sun.security.ssl.HandshakeAbsence;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.HelloRequest;
import sun.security.ssl.KeyUpdate;
import sun.security.ssl.NewSessionTicket;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.ServerHello;
import sun.security.ssl.ServerHelloDone;
import sun.security.ssl.ServerKeyExchange;

enum SSLHandshake implements SSLConsumer,
HandshakeProducer
{
    HELLO_REQUEST(0, "hello_request", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(HelloRequest.handshakeConsumer, ProtocolVersion.PROTOCOLS_TO_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(HelloRequest.handshakeProducer, ProtocolVersion.PROTOCOLS_TO_12)}),
    CLIENT_HELLO(1, "client_hello", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(ClientHello.handshakeConsumer, ProtocolVersion.PROTOCOLS_TO_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(ClientHello.handshakeProducer, ProtocolVersion.PROTOCOLS_TO_13)}),
    SERVER_HELLO(2, "server_hello", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(ServerHello.handshakeConsumer, ProtocolVersion.PROTOCOLS_TO_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(ServerHello.t12HandshakeProducer, ProtocolVersion.PROTOCOLS_TO_12), new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(ServerHello.t13HandshakeProducer, ProtocolVersion.PROTOCOLS_OF_13)}),
    HELLO_RETRY_REQUEST(2, "hello_retry_request", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(ServerHello.handshakeConsumer, ProtocolVersion.PROTOCOLS_TO_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(ServerHello.hrrHandshakeProducer, ProtocolVersion.PROTOCOLS_OF_13)}),
    HELLO_VERIFY_REQUEST(3, "hello_verify_request"),
    NEW_SESSION_TICKET(4, "new_session_ticket", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(NewSessionTicket.handshakeConsumer, ProtocolVersion.PROTOCOLS_OF_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(NewSessionTicket.handshakeProducer, ProtocolVersion.PROTOCOLS_OF_13)}),
    END_OF_EARLY_DATA(5, "end_of_early_data"),
    ENCRYPTED_EXTENSIONS(8, "encrypted_extensions", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(EncryptedExtensions.handshakeConsumer, ProtocolVersion.PROTOCOLS_OF_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(EncryptedExtensions.handshakeProducer, ProtocolVersion.PROTOCOLS_OF_13)}),
    CERTIFICATE(11, "certificate", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateMessage.t12HandshakeConsumer, ProtocolVersion.PROTOCOLS_TO_12), new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateMessage.t13HandshakeConsumer, ProtocolVersion.PROTOCOLS_OF_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateMessage.t12HandshakeProducer, ProtocolVersion.PROTOCOLS_TO_12), new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateMessage.t13HandshakeProducer, ProtocolVersion.PROTOCOLS_OF_13)}),
    SERVER_KEY_EXCHANGE(12, "server_key_exchange", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(ServerKeyExchange.handshakeConsumer, ProtocolVersion.PROTOCOLS_TO_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(ServerKeyExchange.handshakeProducer, ProtocolVersion.PROTOCOLS_TO_12)}),
    CERTIFICATE_REQUEST(13, "certificate_request", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateRequest.t10HandshakeConsumer, ProtocolVersion.PROTOCOLS_TO_11), new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateRequest.t12HandshakeConsumer, ProtocolVersion.PROTOCOLS_OF_12), new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateRequest.t13HandshakeConsumer, ProtocolVersion.PROTOCOLS_OF_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateRequest.t10HandshakeProducer, ProtocolVersion.PROTOCOLS_TO_11), new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateRequest.t12HandshakeProducer, ProtocolVersion.PROTOCOLS_OF_12), new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateRequest.t13HandshakeProducer, ProtocolVersion.PROTOCOLS_OF_13)}),
    SERVER_HELLO_DONE(14, "server_hello_done", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(ServerHelloDone.handshakeConsumer, ProtocolVersion.PROTOCOLS_TO_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(ServerHelloDone.handshakeProducer, ProtocolVersion.PROTOCOLS_TO_12)}),
    CERTIFICATE_VERIFY(15, "certificate_verify", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateVerify.s30HandshakeConsumer, ProtocolVersion.PROTOCOLS_OF_30), new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateVerify.t10HandshakeConsumer, ProtocolVersion.PROTOCOLS_10_11), new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateVerify.t12HandshakeConsumer, ProtocolVersion.PROTOCOLS_OF_12), new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateVerify.t13HandshakeConsumer, ProtocolVersion.PROTOCOLS_OF_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateVerify.s30HandshakeProducer, ProtocolVersion.PROTOCOLS_OF_30), new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateVerify.t10HandshakeProducer, ProtocolVersion.PROTOCOLS_10_11), new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateVerify.t12HandshakeProducer, ProtocolVersion.PROTOCOLS_OF_12), new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateVerify.t13HandshakeProducer, ProtocolVersion.PROTOCOLS_OF_13)}),
    CLIENT_KEY_EXCHANGE(16, "client_key_exchange", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(ClientKeyExchange.handshakeConsumer, ProtocolVersion.PROTOCOLS_TO_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(ClientKeyExchange.handshakeProducer, ProtocolVersion.PROTOCOLS_TO_12)}),
    FINISHED(20, "finished", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(Finished.t12HandshakeConsumer, ProtocolVersion.PROTOCOLS_TO_12), new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(Finished.t13HandshakeConsumer, ProtocolVersion.PROTOCOLS_OF_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(Finished.t12HandshakeProducer, ProtocolVersion.PROTOCOLS_TO_12), new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(Finished.t13HandshakeProducer, ProtocolVersion.PROTOCOLS_OF_13)}),
    CERTIFICATE_URL(21, "certificate_url"),
    CERTIFICATE_STATUS(22, "certificate_status", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(CertificateStatus.handshakeConsumer, ProtocolVersion.PROTOCOLS_TO_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(CertificateStatus.handshakeProducer, ProtocolVersion.PROTOCOLS_TO_12)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeAbsence, ProtocolVersion[]>(CertificateStatus.handshakeAbsence, ProtocolVersion.PROTOCOLS_TO_12)}),
    SUPPLEMENTAL_DATA(23, "supplemental_data"),
    KEY_UPDATE(24, "key_update", new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<SSLConsumer, ProtocolVersion[]>(KeyUpdate.handshakeConsumer, ProtocolVersion.PROTOCOLS_OF_13)}, new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<HandshakeProducer, ProtocolVersion[]>(KeyUpdate.handshakeProducer, ProtocolVersion.PROTOCOLS_OF_13)}),
    MESSAGE_HASH(-2, "message_hash"),
    NOT_APPLICABLE(-1, "not_applicable");

    final byte id;
    final String name;
    final Map.Entry<SSLConsumer, ProtocolVersion[]>[] handshakeConsumers;
    final Map.Entry<HandshakeProducer, ProtocolVersion[]>[] handshakeProducers;
    final Map.Entry<HandshakeAbsence, ProtocolVersion[]>[] handshakeAbsences;

    private SSLHandshake(byte by, String string2) {
        this(by, string2, new Map.Entry[0], new Map.Entry[0], new Map.Entry[0]);
    }

    private SSLHandshake(byte by, String string2, Map.Entry<SSLConsumer, ProtocolVersion[]>[] entryArray, Map.Entry<HandshakeProducer, ProtocolVersion[]>[] entryArray2) {
        this(by, string2, entryArray, entryArray2, new Map.Entry[0]);
    }

    private SSLHandshake(byte by, String string2, Map.Entry<SSLConsumer, ProtocolVersion[]>[] entryArray, Map.Entry<HandshakeProducer, ProtocolVersion[]>[] entryArray2, Map.Entry<HandshakeAbsence, ProtocolVersion[]>[] entryArray3) {
        this.id = by;
        this.name = string2;
        this.handshakeConsumers = entryArray;
        this.handshakeProducers = entryArray2;
        this.handshakeAbsences = entryArray3;
    }

    @Override
    public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
        SSLConsumer sSLConsumer = this.getHandshakeConsumer(connectionContext);
        if (sSLConsumer == null) {
            throw new UnsupportedOperationException("Unsupported handshake consumer: " + this.name);
        }
        sSLConsumer.consume(connectionContext, byteBuffer);
    }

    private SSLConsumer getHandshakeConsumer(ConnectionContext connectionContext) {
        if (this.handshakeConsumers.length == 0) {
            return null;
        }
        HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
        ProtocolVersion protocolVersion = handshakeContext.negotiatedProtocol == null || handshakeContext.negotiatedProtocol == ProtocolVersion.NONE ? (handshakeContext.conContext.isNegotiated && handshakeContext.conContext.protocolVersion != ProtocolVersion.NONE ? handshakeContext.conContext.protocolVersion : handshakeContext.maximumActiveProtocol) : handshakeContext.negotiatedProtocol;
        for (Map.Entry<SSLConsumer, ProtocolVersion[]> entry : this.handshakeConsumers) {
            for (ProtocolVersion protocolVersion2 : entry.getValue()) {
                if (protocolVersion != protocolVersion2) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @Override
    public byte[] produce(ConnectionContext connectionContext, HandshakeMessage handshakeMessage) throws IOException {
        HandshakeProducer handshakeProducer = this.getHandshakeProducer(connectionContext);
        if (handshakeProducer != null) {
            return handshakeProducer.produce(connectionContext, handshakeMessage);
        }
        throw new UnsupportedOperationException("Unsupported handshake producer: " + this.name);
    }

    private HandshakeProducer getHandshakeProducer(ConnectionContext connectionContext) {
        if (this.handshakeConsumers.length == 0) {
            return null;
        }
        HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
        ProtocolVersion protocolVersion = handshakeContext.negotiatedProtocol == null || handshakeContext.negotiatedProtocol == ProtocolVersion.NONE ? (handshakeContext.conContext.isNegotiated && handshakeContext.conContext.protocolVersion != ProtocolVersion.NONE ? handshakeContext.conContext.protocolVersion : handshakeContext.maximumActiveProtocol) : handshakeContext.negotiatedProtocol;
        for (Map.Entry<HandshakeProducer, ProtocolVersion[]> entry : this.handshakeProducers) {
            for (ProtocolVersion protocolVersion2 : entry.getValue()) {
                if (protocolVersion != protocolVersion2) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    static String nameOf(byte by) {
        for (SSLHandshake sSLHandshake : SSLHandshake.values()) {
            if (sSLHandshake.id != by) continue;
            return sSLHandshake.name;
        }
        return "UNKNOWN-HANDSHAKE-MESSAGE(" + by + ")";
    }

    static boolean isKnown(byte by) {
        for (SSLHandshake sSLHandshake : SSLHandshake.values()) {
            if (sSLHandshake.id != by || by == SSLHandshake.NOT_APPLICABLE.id) continue;
            return true;
        }
        return false;
    }

    static final void kickstart(HandshakeContext handshakeContext) throws IOException {
        if (handshakeContext instanceof ClientHandshakeContext) {
            if (handshakeContext.conContext.isNegotiated && handshakeContext.conContext.protocolVersion.useTLS13PlusSpec()) {
                KeyUpdate.kickstartProducer.produce(handshakeContext);
            } else {
                ClientHello.kickstartProducer.produce(handshakeContext);
            }
        } else if (handshakeContext.conContext.protocolVersion.useTLS13PlusSpec()) {
            KeyUpdate.kickstartProducer.produce(handshakeContext);
        } else {
            HelloRequest.kickstartProducer.produce(handshakeContext);
        }
    }

    static abstract class HandshakeMessage {
        final HandshakeContext handshakeContext;

        HandshakeMessage(HandshakeContext handshakeContext) {
            this.handshakeContext = handshakeContext;
        }

        abstract SSLHandshake handshakeType();

        abstract int messageLength();

        abstract void send(HandshakeOutStream var1) throws IOException;

        void write(HandshakeOutStream handshakeOutStream) throws IOException {
            int n = this.messageLength();
            if (n >= 0x1000000) {
                throw new SSLException("Handshake message is overflow, type = " + this.handshakeType() + ", len = " + n);
            }
            handshakeOutStream.write(this.handshakeType().id);
            handshakeOutStream.putInt24(n);
            this.send(handshakeOutStream);
            handshakeOutStream.complete();
        }
    }
}

