/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2003;

import finanze.IDTE.generale2003.BaseTelem;
import finanze.IDTE.generale2003.Campo;
import finanze.IDTE.generale2003.Diagnostici;
import finanze.IDTE.generale2003.Dichiarazione;
import finanze.IDTE.generale2003.Globali;
import finanze.IDTE.generale2003.Util;
import finanze.IDTE.generale2003.Vincoli;
import finanze.IDTE.resources.Controlli;
import finanze.IDTE.resources.ControlliCampo;
import finanze.IDTE.resources.RecordParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Modello {
    protected RecordParser recordA;
    protected RecordParser recordB;
    protected RecordParser recordZ;
    protected Dichiarazione dich = new Dichiarazione();
    protected Globali varGlob = new Globali();
    protected Globali maxQuadri = new Globali();
    protected String TIPO_MODELLO;
    protected String ANNO;
    protected boolean flagConferma = false;
    public boolean flagFornitoreUfficio = false;

    public double AD(int n) {
        try {
            return Util.valoreDouble(this.recordA.prendiValore(n).trim());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public int AI(int n) {
        try {
            return Integer.parseInt(this.recordA.prendiValore(n).trim());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long AL(int n) {
        try {
            return Long.parseLong(this.recordA.prendiValore(n).trim());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String AS(int n) {
        return this.recordA.prendiValore(n);
    }

    public boolean B(String string, String string2) {
        return Util.isInside(Long.parseLong(this.getDichiarazione().prendiValoreCampo(string)), string2);
    }

    public double BD(int n) {
        try {
            return Util.valoreDouble(this.recordB.prendiValore(n).trim());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public int BI(int n) {
        try {
            return Integer.parseInt(this.recordB.prendiValore(n).trim());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long BL(int n) {
        try {
            return Long.parseLong(this.recordB.prendiValore(n).trim());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String BS(int n) {
        return this.recordB.prendiValore(n);
    }

    private int casoANPR(String string, Campo campo) {
        String string2;
        String string3 = string2 = string.substring(0, 8);
        if (string2.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string3 = String.valueOf(string2.substring(0, 2)) + "0" + string2.substring(3, string2.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string3) == 1 || this.getControlli().getFormato(string3) == 4) {
            String string4 = campo.getValore().trim();
            campo.setValore(string4);
            this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
            if (BaseTelem.currentSystem != 0) {
                this.getDichiarazione().addElementSort(campo);
            }
        }
        return n;
    }

    private int casoCB(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string4) == 300) {
            String string5 = campo.getValore().trim();
            if (string5.equals("1") || string5.equals("0")) {
                if (string5.equals("1")) {
                    campo.setValore(string5.trim());
                    this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                    if (BaseTelem.currentSystem != 0) {
                        this.getDichiarazione().addElementSort(campo);
                    }
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoCBx(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        int n2 = this.getControlli().getFormato(string4);
        int n3 = n2 % 100;
        if (n2 / 100 == 3 && 1 <= n3 && n3 <= 16) {
            String string5 = campo.getValore().trim();
            if (string5.length() == n3) {
                boolean bl = false;
                int n4 = 0;
                int n5 = 0;
                while (!bl && n4 < n3) {
                    if (string5.charAt(n4) != '1' && string5.charAt(n4) != '0') {
                        bl = true;
                    }
                    if (string5.charAt(n4) == '0') {
                        ++n5;
                    }
                    ++n4;
                }
                if (!bl) {
                    if (n4 != n5) {
                        campo.setValore(string5.trim());
                        this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(campo);
                        }
                    }
                } else {
                    n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoCFPI(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string4) == 2 || this.getControlli().getFormato(string4) == 3) {
            String string5 = campo.getValore().trim();
            if (string5.length() == 16) {
                campo.setValore(string5);
                this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                if (BaseTelem.currentSystem != 0) {
                    this.getDichiarazione().addElementSort(campo);
                }
            } else if (string5.length() == 11) {
                campo.setValore(string5);
                this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                if (BaseTelem.currentSystem != 0) {
                    this.getDichiarazione().addElementSort(campo);
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoDA(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string4) == 5) {
            String string5 = campo.getValore().trim();
            if (Util.numerico(string5) && string5.indexOf(46) == -1 && string5.indexOf(44) == -1) {
                if (string5.length() == 4) {
                    if (Long.parseLong(string5) != 0L) {
                        campo.setValore(string5);
                        this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(campo);
                        }
                    }
                } else {
                    n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1011", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoDN(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string4) == 11) {
            String string5 = campo.getValore().trim();
            if (Util.numerico(string5) && string5.indexOf(46) == -1 && string5.indexOf(44) == -1 && string5.length() <= 8) {
                campo.setValore(Util.formNum(8, Long.parseLong(string5)));
                this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                if (BaseTelem.currentSystem != 0) {
                    this.getDichiarazione().addElementSort(campo);
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoDT(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string4) == 200) {
            String string5 = campo.getValore().trim();
            if (Util.numerico(string5) && string5.indexOf(46) == -1 && string5.indexOf(44) == -1 && string5.length() <= 8) {
                campo.setValore(Util.formNum(8, Long.parseLong(string5)));
                this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                if (BaseTelem.currentSystem != 0) {
                    this.getDichiarazione().addElementSort(campo);
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoDx(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        int n2 = this.getControlli().getFormato(string4);
        int n3 = n2 % 100;
        if (n2 / 100 == 2 && 1 <= n3 && n3 <= 16) {
            String string5 = campo.getValore().trim();
            if (Util.numerico(string5) && string5.indexOf(46) == -1 && string5.indexOf(44) == -1) {
                if (string5.length() <= n3) {
                    if (Long.parseLong(string5) != 0L) {
                        campo.setValore(Util.formNum(n3, Long.parseLong(string5)));
                        this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(campo);
                        }
                    }
                } else {
                    n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1011", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoNP(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string4) == 10) {
            String string5 = campo.getValore().trim();
            if (Util.numerico(string5) && string5.indexOf(46) == -1 && string5.indexOf(44) == -1) {
                if (Long.parseLong(string5) >= 0L) {
                    if (Long.parseLong(string5) != 0L) {
                        campo.setValore(string5);
                        this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(campo);
                        }
                    }
                } else {
                    n = Diagnostici.DIA(n, 16, this.BS(2), "1078", string, campo.getValore(), "", 0.0, string2);
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1011", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoNU(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string4) == 100) {
            String string5 = campo.getValore().trim();
            if (Util.numerico(string5) && string5.indexOf(46) == -1 && string5.indexOf(44) == -1) {
                if (Long.parseLong(string5) != 0L) {
                    campo.setValore(string5);
                    this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                    if (BaseTelem.currentSystem != 0) {
                        this.getDichiarazione().addElementSort(campo);
                    }
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1011", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoNx(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        int n2 = this.getControlli().getFormato(string4);
        int n3 = n2 % 100;
        if (n2 / 100 == 1 && 1 <= n3 && n3 <= 16) {
            String string5 = campo.getValore().trim();
            if (Util.numerico(string5) && string5.indexOf(46) == -1 && string5.indexOf(44) == -1) {
                if (string5.length() <= n3) {
                    if (Long.parseLong(string5) != 0L) {
                        campo.setValore(Util.formNum(n3, Long.parseLong(string5)));
                        this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                        if (BaseTelem.currentSystem != 0) {
                            this.getDichiarazione().addElementSort(campo);
                        }
                    }
                } else {
                    n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1011", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoPC(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string4) == 6) {
            String string5 = campo.getValore().trim();
            if (Util.numerico(string5) && string5.indexOf(46) == -1) {
                String string6 = string5.replace(',', '.');
                if (Util.valoreDouble(string6) <= 100.0 && Util.valoreDouble(string6) >= 0.0) {
                    campo.setValore(string5);
                    this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                    if (BaseTelem.currentSystem != 0) {
                        this.getDichiarazione().addElementSort(campo);
                    }
                } else {
                    n = Diagnostici.DIA(n, 16, this.BS(2), "1012", string, campo.getValore(), "", 0.0, string2);
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    private int casoQU(String string, Campo campo, String string2) {
        String string3;
        String string4 = string3 = string.substring(0, 8);
        if (string3.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
            string4 = String.valueOf(string3.substring(0, 2)) + "0" + string3.substring(3, string3.length());
        }
        int n = 0;
        if (this.getControlli().getFormato(string4) == 7) {
            String string5 = campo.getValore().trim();
            if (Util.numerico(string5) && string5.indexOf(46) == -1) {
                if (Double.valueOf(Util.replaceString(string5, ",", ".")) != 0.0) {
                    campo.setValore(string5);
                    this.maxQuadri.aggiornaModulo(campo.getQuadro(), Util.valoreInt(campo.getNumModello()));
                    if (BaseTelem.currentSystem != 0) {
                        this.getDichiarazione().addElementSort(campo);
                    }
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string, campo.getValore(), "", 0.0, string2);
            }
        }
        return n;
    }

    public int controllaFissaA() {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.recordA.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n3 = this.getRecordAcontrolli().getFormatoAt(n2);
            this.getRecordAcontrolli().getVincoliAt(n2);
            String string2 = "XXA" + Util.formNum(2, n2 + 1);
            if (!(n3 != 100 && n3 != 200 || Util.numerico(string) && string.indexOf(46) == -1 && string.indexOf(44) == -1 && string.indexOf(32) == -1)) {
                n = Diagnostici.DIA(n, 4, "AAAAAAAAAAAAAAAA", "1011", string2, string, "");
                string = "0";
                if (n3 == 200) {
                    string = "00000000";
                }
                this.recordA.impostaValore(string, n2 + 1);
            }
            ++n2;
        }
        return n;
    }

    public int controllaFissaB() {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.recordB.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n3 = this.getRecordBcontrolli().getFormatoAt(n2);
            this.getRecordBcontrolli().getVincoliAt(n2);
            String string2 = "";
            string2 = n2 > 98 && n2 <= 198 ? "XXX" + Util.formNum(2, n2 - 100 + 1) : (n2 > 198 ? "XXY" + Util.formNum(2, n2 - 200 + 1) : "XXB" + Util.formNum(2, n2 + 1));
            if (n3 == 8) {
                this.recordB.impostaValore("", n2 + 1);
            }
            if (n3 == 9) {
                this.recordB.impostaValore("0", n2 + 1);
            }
            if (n3 == 100 || n3 == 200) {
                if (string.trim().length() == 0) {
                    string = Util.formNum(string.length(), "0");
                    this.recordB.impostaValore(string, n2 + 1);
                }
                if (!Util.isNumericoAssoluto(string)) {
                    n = Diagnostici.DIA(n, 16, this.BS(2), "1011", string2, string, "");
                    string = "0";
                    if (n3 == 200) {
                        string = "00000000";
                    }
                    this.recordB.impostaValore(string, n2 + 1);
                }
            }
            if (n3 == 199) {
                if (string.trim().length() == 0) {
                    string = "0000000000000";
                    this.getRecordB().impostaValore(string, n2 + 1);
                }
                if (!Util.numerico(string) || string.indexOf(46) != -1 || string.indexOf(44) != -1) {
                    n = Diagnostici.DIA(n, 16, this.BS(2), "1011", string2, string, "");
                    string = "0000000000000";
                    this.getRecordB().impostaValore(string, n2 + 1);
                }
            }
            if (n3 == 2 && string.trim().length() != 16 && string.trim().length() != 11 && string.trim().length() != 0) {
                this.recordB.impostaValore("", n2 + 1);
                n = Diagnostici.DIA(n, 16, this.BS(2), "1030", string2, string, "");
            }
            ++n2;
        }
        return n;
    }

    public int controllaFissaZ() {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.recordZ.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n3 = this.getRecordZcontrolli().getFormatoAt(n2);
            String string2 = "XXZ" + Util.formNum(2, n2 + 1);
            if (!(n3 != 100 && n3 != 200 || Util.numerico(string) && string.indexOf(46) == -1 && string.indexOf(44) == -1 && string.indexOf(32) == -1)) {
                n = Diagnostici.DIA(n, 4, "ZZZZZZZZZZZZZZZZ", "1011", string2, string, "");
                string = "0";
                if (n3 == 200) {
                    string = "00000000";
                }
                this.recordZ.impostaValore(string, n2 + 1);
            }
            ++n2;
        }
        return n;
    }

    public void controlliFormaliAssistenza(String string) {
        Enumeration enumeration = this.getDichiarazione().elements();
        while (enumeration.hasMoreElements()) {
            Campo campo = (Campo)enumeration.nextElement();
            if (!string.equals(campo.getQuadro())) continue;
            this.casoANPR(campo.getCodice(), campo);
            this.casoCB(campo.getCodice(), campo, "");
            this.casoCBx(campo.getCodice(), campo, "");
            this.casoCFPI(campo.getCodice(), campo, "");
            this.casoDA(campo.getCodice(), campo, "");
            this.casoDN(campo.getCodice(), campo, "");
            this.casoDT(campo.getCodice(), campo, "");
            this.casoDx(campo.getCodice(), campo, "");
            this.casoNP(campo.getCodice(), campo, "");
            this.casoNU(campo.getCodice(), campo, "");
            this.casoNx(campo.getCodice(), campo, "");
            this.casoPC(campo.getCodice(), campo, "");
            this.casoQU(campo.getCodice(), campo, "");
        }
    }

    public void controlliFormaliAssistenza(String string, Campo campo) {
        this.casoANPR(string, campo);
        this.casoCB(string, campo, "");
        this.casoCBx(string, campo, "");
        this.casoCFPI(string, campo, "");
        this.casoDA(string, campo, "");
        this.casoDN(string, campo, "");
        this.casoDT(string, campo, "");
        this.casoDx(string, campo, "");
        this.casoNP(campo.getCodice(), campo, "");
        this.casoNU(string, campo, "");
        this.casoNx(string, campo, "");
        this.casoPC(string, campo, "");
        this.casoQU(string, campo, "");
    }

    public void controlliFormaliAssistenza(String string, String string2) {
        Enumeration enumeration = this.getDichiarazione().elements();
        while (enumeration.hasMoreElements()) {
            Campo campo = (Campo)enumeration.nextElement();
            if (!string.equals(campo.getQuadro()) || !string2.equals(campo.getNumModello())) continue;
            this.casoANPR(campo.getCodice(), campo);
            this.casoCB(campo.getCodice(), campo, "");
            this.casoCBx(campo.getCodice(), campo, "");
            this.casoCFPI(campo.getCodice(), campo, "");
            this.casoDA(campo.getCodice(), campo, "");
            this.casoDN(campo.getCodice(), campo, "");
            this.casoDT(campo.getCodice(), campo, "");
            this.casoDx(campo.getCodice(), campo, "");
            this.casoNP(campo.getCodice(), campo, "");
            this.casoNU(campo.getCodice(), campo, "");
            this.casoNx(campo.getCodice(), campo, "");
            this.casoPC(campo.getCodice(), campo, "");
            this.casoQU(campo.getCodice(), campo, "");
        }
    }

    public double D(String string) {
        return Util.valoreDouble(this.getDichiarazione().prendiValoreCampo(string));
    }

    public String getCodiceFornitura() {
        return String.valueOf(this.TIPO_MODELLO) + this.ANNO;
    }

    public Controlli getControlli() {
        return BaseTelem.getInstance().getControlli(this.TIPO_MODELLO);
    }

    public Dichiarazione getDichiarazione() {
        if (this.dich == null) {
            try {
                this.dich = new Dichiarazione();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating dichiarazione property.");
            }
        }
        return this.dich;
    }

    public boolean getFlagConferma() {
        return this.flagConferma;
    }

    public String getModName() {
        return String.valueOf(this.TIPO_MODELLO) + this.ANNO;
    }

    public Controlli getRecordAcontrolli() {
        return BaseTelem.getInstance().getRecordAcontrolli();
    }

    public RecordParser getRecordB() {
        return this.recordB;
    }

    public Controlli getRecordBcontrolli() {
        return BaseTelem.getInstance().getRecordBcontrolli();
    }

    public Controlli getRecordZcontrolli() {
        return BaseTelem.getInstance().getRecordZcontrolli();
    }

    public Globali getVarGlob() {
        return this.varGlob;
    }

    public int I(String string) {
        return Integer.parseInt(this.getDichiarazione().prendiValoreCampo(string));
    }

    public boolean isFornitoreInternet() {
        boolean bl;
        int n = this.AI(4);
        boolean bl2 = bl = n == 9 && this.AS(5).trim().equals(this.BS(2).trim());
        return n == 1 || n == 2 || n == 6 || n == 13 || bl;
    }

    public long L(String string) {
        return Long.parseLong(this.getDichiarazione().prendiValoreCampo(string));
    }

    public void liquidaAssistenza(String string, String string2) {
    }

    public int preliquida() {
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = 0;
        String string4 = "";
        int n2 = 0;
        Vincoli vincoli = new Vincoli();
        Enumeration enumeration = this.getDichiarazione().elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object object;
            Campo campo = (Campo)enumeration.nextElement();
            string = String.valueOf(campo.getQuadro()) + campo.getRiga() + campo.getColonna();
            string2 = String.valueOf(string) + campo.getNumModello();
            int n3 = this.getControlli().getFormato(string);
            string3 = this.getControlli().getVincoli(string);
            n = this.getControlli().getRcVincoli(string);
            bl = false;
            String string5 = String.valueOf(campo.getQuadro()) + campo.getRiga() + "001";
            String string6 = "";
            if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.getControlli().getFormato(string5) == 2) {
                string6 = this.getDichiarazione().prendiValoreCampo(String.valueOf(string5) + campo.getNumModello());
            }
            if ((n3 == 4 || n3 == 2 || n3 == 200 || n3 == 5 || n3 == 204 || n3 == 206) && n == 0) {
                n = 16;
            }
            if (string3.indexOf("E(") >= 0) {
                n = this.flagConferma ? 12 : 16;
            }
            if (string3.indexOf("R(") >= 0 && n == 0) {
                n = 16;
            }
            if (!string3.equals("")) {
                object = vincoli.separaIstruzioni(string3);
                Vector vector = vincoli.interprete(string2, campo.getValore(), n3, (Vector)object, this.getDichiarazione());
                if (vector.size() != 0) {
                    this.scriviListaDiagnostici(this.BS(2), string2, vector, n, string6);
                    n2 = Util.aggRc(n2, n);
                    bl = true;
                }
                object = null;
                vector = null;
            }
            if (n3 == 1 && !string3.equals("")) {
                if (campo.getValore().equals("-")) {
                    string4 = Util.formNum(2, 1 + Util.valoreInt(campo.getColonna()));
                    string2 = String.valueOf(campo.getQuadro()) + campo.getRiga() + string4 + campo.getNumModello();
                    this.getDichiarazione().scriviValoreCampo(string2, Integer.toString(Util.valoreInt(this.getDichiarazione().prendiValoreCampo(string2)) * -1));
                }
            } else if (n3 == 2) {
                if (!Util.controlloCF(campo.getValore())) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1013", string2, campo.getValore(), "", 0.0, string6);
                }
            } else if (n3 == 3) {
                if (!Util.controlloPI(campo.getValore())) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1013", string2, campo.getValore(), "", 0.0, string6);
                }
            } else if (n3 == 11) {
                if (!Util.controlloData(campo.getValore())) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string2, campo.getValore(), "", 0.0, string6);
                }
            } else if (n3 == 200) {
                object = campo.getValore();
                if (!Util.controlloData((String)object)) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string2, campo.getValore(), "", 0.0, string6);
                }
                if (Util.isData2maggioreData1(Util.getDataCorrente(), (String)object)) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1077", string2, campo.getValore(), "", 0.0, string6);
                }
            } else if (n3 == 5) {
                if (!Util.controlloData("0101" + campo.getValore())) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string2, campo.getValore(), "", 0.0, string6);
                }
            } else if (n3 == 204) {
                if (!Util.controlloData(String.valueOf(campo.getValore()) + "2000")) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string2, campo.getValore(), "", 0.0, string6);
                }
            } else if (n3 == 206) {
                int n4 = Integer.parseInt(campo.getValore().substring(0, 2));
                int n5 = Integer.parseInt(campo.getValore().substring(2, 4));
                if (n4 <= 0 || n4 > 12 || n5 != 19 && n5 != 20) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string2, campo.getValore(), "", 0.0, string6);
                }
            } else if (n3 == 4 && !Util.esisteProvincia(campo.getValore())) {
                bl = true;
                n2 = Diagnostici.DIA(n2, n, this.BS(2), "1012", string2, campo.getValore(), "", 0.0, string6);
            }
            if (!bl || !this.TIPO_MODELLO.equals("730") || n != 12) continue;
            this.varGlob.scriviImporto(campo.getQuadro(), 12.0);
        }
        n2 = this.preliquidaCampi0(n2);
        return n2;
    }

    public int preliquida(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n = 0;
        String string6 = "";
        int n2 = 0;
        Vincoli vincoli = new Vincoli();
        Enumeration enumeration = this.getDichiarazione().elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object object;
            Campo campo = (Campo)enumeration.nextElement();
            if (!string.equals(campo.getQuadro()) || !string2.equals(campo.getNumModello())) continue;
            string3 = String.valueOf(campo.getQuadro()) + campo.getRiga() + campo.getColonna();
            string4 = String.valueOf(string3) + campo.getNumModello();
            int n3 = this.getControlli().getFormato(string3);
            string5 = this.getControlli().getVincoli(string3);
            n = this.getControlli().getRcVincoli(string3);
            bl = false;
            String string7 = String.valueOf(campo.getQuadro()) + campo.getRiga() + "001";
            String string8 = "";
            if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.getControlli().getFormato(string7) == 2) {
                string8 = this.getDichiarazione().prendiValoreCampo(String.valueOf(string7) + campo.getNumModello());
            }
            if ((n3 == 4 || n3 == 2 || n3 == 200 || n3 == 5 || n3 == 204 || n3 == 206) && n == 0) {
                n = 16;
            }
            if (string5.indexOf("E(") >= 0) {
                n = this.flagConferma ? 12 : 16;
            }
            if (string5.indexOf("R(") >= 0 && n == 0) {
                n = 16;
            }
            if (!string5.equals("")) {
                object = vincoli.separaIstruzioni(string5);
                Vector vector = vincoli.interprete(string4, campo.getValore(), n3, (Vector)object, this.getDichiarazione());
                if (vector.size() != 0) {
                    this.scriviListaDiagnostici(this.BS(2), string4, vector, n, string8);
                    n2 = Util.aggRc(n2, n);
                    bl = true;
                }
                object = null;
                vector = null;
            }
            if (n3 == 1 && !string5.equals("")) {
                if (campo.getValore().equals("-")) {
                    string6 = Util.formNum(2, 1 + Util.valoreInt(campo.getColonna()));
                    string4 = String.valueOf(campo.getQuadro()) + campo.getRiga() + string6 + campo.getNumModello();
                    this.getDichiarazione().scriviValoreCampo(string4, Integer.toString(Util.valoreInt(this.getDichiarazione().prendiValoreCampo(string4)) * -1));
                }
            } else if (n3 == 2) {
                if (!Util.controlloCF(campo.getValore())) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1013", string4, campo.getValore(), "", 0.0, string8);
                }
            } else if (n3 == 3) {
                if (!Util.controlloPI(campo.getValore())) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1013", string4, campo.getValore(), "", 0.0, string8);
                }
            } else if (n3 == 11) {
                if (!Util.controlloData(campo.getValore())) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string4, campo.getValore(), "", 0.0, string8);
                }
            } else if (n3 == 200) {
                object = campo.getValore();
                if (!Util.controlloData((String)object)) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string4, campo.getValore(), "", 0.0, string8);
                }
                if (Util.isData2maggioreData1(Util.getDataCorrente(), (String)object)) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1077", string4, campo.getValore(), "", 0.0, string8);
                }
            } else if (n3 == 5) {
                if (!Util.controlloData("0101" + campo.getValore())) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string4, campo.getValore(), "", 0.0, string8);
                }
            } else if (n3 == 204) {
                if (!Util.controlloData(String.valueOf(campo.getValore()) + "2000")) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string4, campo.getValore(), "", 0.0, string8);
                }
            } else if (n3 == 206) {
                int n4 = Integer.parseInt(campo.getValore().substring(0, 2));
                int n5 = Integer.parseInt(campo.getValore().substring(2, 4));
                if (n4 <= 0 || n4 > 12 || n5 != 19 && n5 != 20) {
                    bl = true;
                    n2 = Diagnostici.DIA(n2, n, this.BS(2), "1015", string4, campo.getValore(), "", 0.0, string8);
                }
            } else if (n3 == 4 && !Util.esisteProvincia(campo.getValore())) {
                bl = true;
                n2 = Diagnostici.DIA(n2, n, this.BS(2), "1012", string4, campo.getValore(), "", 0.0, string8);
            }
            if (!bl || !this.TIPO_MODELLO.equals("730") || n != 12) continue;
            this.varGlob.scriviImporto(campo.getQuadro(), 12.0);
        }
        n2 = this.preliquidaCampi0(n2);
        return n2;
    }

    private int preliquidaCampi0(int n) {
        Enumeration enumeration = this.getControlli().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ControlliCampo controlliCampo = this.getControlli().getCampo(string);
            String string2 = controlliCampo.vincoli;
            if (string2.indexOf("R(") >= 0 || string2.indexOf("<(") >= 0 || string2.indexOf(">(") >= 0 || string2.trim().length() == 0) continue;
            Vector vector = this.getDichiarazione().ricavaModuliDaQuadro(string.substring(0, 2));
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                if (this.getDichiarazione().esisteCampo(String.valueOf(string) + string3)) continue;
                int n2 = controlliCampo.rcVincoli;
                String string4 = "";
                String string5 = String.valueOf(string.substring(0, 5)) + "001";
                Vincoli vincoli = new Vincoli();
                if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.getControlli().getFormato(string5) == 2) {
                    string4 = this.getDichiarazione().prendiValoreCampo(String.valueOf(string5) + string3);
                }
                if (controlliCampo.formato == 200 || controlliCampo.formato == 204 || controlliCampo.formato == 206) {
                    n2 = 16;
                }
                if (controlliCampo.vincoli.indexOf("E(") >= 0) {
                    n2 = this.flagConferma ? 12 : 16;
                }
                Vector vector2 = vincoli.separaIstruzioni(controlliCampo.vincoli);
                Vector vector3 = vincoli.interprete(String.valueOf(string) + string3, "0", controlliCampo.formato, vector2, this.getDichiarazione());
                if (vector3.size() != 0) {
                    this.scriviListaDiagnostici(this.BS(2), String.valueOf(string) + string3, vector3, n2, string4);
                    n = Util.aggRc(n, n2);
                }
                vector2 = null;
                vector3 = null;
            }
        }
        return n;
    }

    public int preliquidaFissaA() {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.recordA.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n3 = this.getRecordAcontrolli().getFormatoAt(n2);
            String string2 = this.getRecordAcontrolli().getVincoliAt(n2);
            int n4 = this.getRecordAcontrolli().getRcVincoliAt(n2);
            String string3 = "XXA" + Util.formNum(2, n2 + 1);
            if (n3 == 100 && !string2.equals("") && !Util.isInside(Long.parseLong(string), string2.substring(2, string2.length() - 1))) {
                n = Diagnostici.DIA(n, n4 > 4 ? n4 : 4, "AAAAAAAAAAAAAAAA", "1012", string3, string, "");
            }
            if (n3 == 1 && !string2.equals("") && !Util.isInside(string, string2.substring(2, string2.length() - 1))) {
                n = Diagnostici.DIA(n, n4 > 4 ? n4 : 4, "AAAAAAAAAAAAAAAA", "1012", string3, string, "");
            }
            if (n3 == 2 && !string.trim().equals("") && !Util.controlloCF(string)) {
                n = Diagnostici.DIA(n, n4 > 4 ? n4 : 4, "AAAAAAAAAAAAAAAA", "1013", string3, string, "");
            }
            if (n3 == 3 && !string.trim().equals("") && !Util.controlloPI(string)) {
                n = Diagnostici.DIA(n, n4 > 4 ? n4 : 4, "AAAAAAAAAAAAAAAA", "1013", string3, string, "");
            }
            if (n3 == 200 && !string.equals("00000000") && !Util.controlloData(string)) {
                n = Diagnostici.DIA(n, n4 > 4 ? n4 : 4, "AAAAAAAAAAAAAAAA", "1015", string3, string, "");
            }
            if (n3 == 4 && !string.trim().equals("") && !Util.esisteProvincia(string)) {
                n = Diagnostici.DIA(n, n4 > 4 ? n4 : 4, "AAAAAAAAAAAAAAAA", "1012", string3, string, "");
            }
            ++n2;
        }
        return n;
    }

    public int preliquidaFissaB() {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.recordB.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n3 = this.getRecordBcontrolli().getFormatoAt(n2);
            String string2 = this.getRecordBcontrolli().getVincoliAt(n2);
            int n4 = this.getRecordBcontrolli().getRcVincoliAt(n2);
            if (!string.equals("") && !string.equals("0") || BaseTelem.currentSystem != 0) {
                String string3 = "";
                bl = false;
                if (n3 == 2 || n3 == 3 || n3 == 100 || n3 == 200 || n3 == 204 || n3 == 206) {
                    n4 = 16;
                }
                if (string2.indexOf("E(") >= 0) {
                    n4 = this.flagConferma ? 8 : 14;
                }
                if (string2.indexOf("R(") >= 0 && n4 == 0) {
                    n4 = 16;
                }
                string3 = n2 > 98 && n2 <= 198 ? "XXX" + Util.formNum(2, n2 - 100 + 1) : (n2 > 198 ? "XXY" + Util.formNum(2, n2 - 200 + 1) : "XXB" + Util.formNum(2, n2 + 1));
                if (!(n3 != 100 && n3 != 200 || string2.equals("") || Util.isInside(Long.parseLong(string), string2.substring(2, string2.length() - 1)))) {
                    bl = true;
                    n = Diagnostici.DIA(n, n4, this.BS(2), "1012", string3, string, "");
                }
                if (n3 == 1 && !string2.equals("") && !Util.isInside(string, string2.substring(2, string2.length() - 1))) {
                    bl = true;
                    n = Diagnostici.DIA(n, n4, this.BS(2), "1012", string3, string, "");
                }
                if (n3 == 2 && !string.trim().equals("") && !Util.controlloCF(string)) {
                    bl = true;
                    n = Diagnostici.DIA(n, n4, this.BS(2), "1013", string3, string, "");
                }
                if (n3 == 3 && !string.trim().equals("") && !Util.controlloPI(string)) {
                    bl = true;
                    n = Diagnostici.DIA(n, n4, this.BS(2), "1013", string3, string, "");
                }
                if (n3 == 200 && !string.equals("00000000") && !Util.controlloData(string)) {
                    bl = true;
                    n = Diagnostici.DIA(n, n4, this.BS(2), "1015", string3, string, "");
                }
                if (n3 == 4 && !string.trim().equals("") && !Util.esisteProvincia(string)) {
                    bl = true;
                    n = Diagnostici.DIA(n, n4, this.BS(2), "1012", string3, string, "");
                }
                if (bl && this.TIPO_MODELLO.equals("730") && n4 == 12) {
                    this.varGlob.scriviImporto("B" + Util.formNum(2, n2), 12.0);
                }
            }
            ++n2;
        }
        return n;
    }

    public void riempiControlli() throws FileNotFoundException, IOException {
        BaseTelem.getInstance().riempiControlli(this.TIPO_MODELLO, this.ANNO);
    }

    public void riempiControlli(int n) throws FileNotFoundException, IOException {
        BaseTelem.getInstance().riempiControlli(n, this.TIPO_MODELLO, this.ANNO);
    }

    public int riempiDichiarazione(String string, int n) {
        new String();
        Campo campo = new Campo();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = n;
        while (n4 < 1900 && n3 < 75) {
            campo.setQuadro(string.substring(n4, n4 + 2));
            campo.setRiga(string.substring(n4 + 2, n4 + 5));
            campo.setColonna(string.substring(n4 + 5, n4 + 8));
            campo.setNumModello(string.substring(17, 25));
            campo.setValore(string.substring(n4 + 8, n4 + 24));
            String string2 = String.valueOf(campo.getQuadro()) + campo.getRiga() + campo.getColonna();
            String string3 = String.valueOf(string2) + campo.getNumModello();
            String string4 = string2;
            if (string2.charAt(2) == 'D' && this.TIPO_MODELLO.equals("730")) {
                string4 = String.valueOf(string2.substring(0, 2)) + "0" + string2.substring(3, string2.length());
            }
            int n5 = this.getControlli().getFormato(string4);
            String string5 = String.valueOf(campo.getQuadro()) + campo.getRiga() + "001";
            if (this.TIPO_MODELLO.equals("77S")) {
                if (campo.getQuadro().equals("AU")) {
                    string5 = "AU001001";
                }
                if (campo.getQuadro().equals("DA") || campo.getQuadro().equals("DB") || campo.getQuadro().equals("DC") || campo.getQuadro().equals("DD")) {
                    string5 = "DA001001";
                }
            }
            String string6 = "";
            if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.getControlli().getFormato(string5) == 2) {
                string6 = this.getDichiarazione().prendiValoreCampo(String.valueOf(string5) + campo.getNumModello());
            }
            if (string2.trim().length() == 0 && campo.getValore().trim().length() == 0) {
                bl = true;
            } else {
                if (bl) {
                    n2 = Diagnostici.DIA(n2, 4, this.BS(2), "1021", "", "", "", 0.0, string6);
                    bl = false;
                }
                if (this.getDichiarazione().esisteCampo(string3)) {
                    if (campo.getValore().charAt(0) == '+' && n5 == 1) {
                        String string7 = String.valueOf(this.getDichiarazione().prendiValoreCampo(string3)) + campo.getValore().substring(1, campo.getValore().length());
                        this.getDichiarazione().scriviValoreCampo(string3, string7);
                    } else {
                        n2 = Diagnostici.DIA(n2, 16, this.BS(2), "1022", "", string3, "", 0.0, string6);
                    }
                } else if (n5 == -1 || campo.getRiga().equals("XXX")) {
                    n2 = Diagnostici.DIA(n2, 16, this.BS(2), "1024", "", string3, "", 0.0, string6);
                } else if (!Util.numerico(campo.getNumModello()) || campo.getNumModello().equals("00000000") || campo.getNumModello().equals("00")) {
                    n2 = Diagnostici.DIA(n2, 16, this.BS(2), "1024", "", string3, "", 0.0, string6);
                } else if (campo.getValore().equals("                ")) {
                    n2 = Diagnostici.DIA(n2, 4, this.BS(2), "1023", string3, "", "", 0.0, string6);
                } else if (Util.detectLowValueChars(campo.getValore())) {
                    n2 = Diagnostici.DIA(n2, 16, this.BS(2), "1094", string3, campo.getValore(), "", 0.0, string6);
                } else {
                    n2 = Util.aggRc(n2, this.casoANPR(string3, campo));
                    n2 = Util.aggRc(n2, this.casoCB(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoCBx(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoCFPI(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoDT(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoDN(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoDA(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoDx(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoNU(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoNP(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoPC(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoQU(string3, campo, string6));
                    n2 = Util.aggRc(n2, this.casoNx(string3, campo, string6));
                }
            }
            campo = new Campo();
            ++n3;
            n4 += 24;
        }
        return n2;
    }

    public void riempiRecordA() throws FileNotFoundException, IOException {
        this.recordA.load(String.valueOf(this.TIPO_MODELLO) + this.ANNO + "_reca" + ".res");
    }

    public void riempiRecordB() throws FileNotFoundException, IOException {
        this.recordB.load(String.valueOf(this.TIPO_MODELLO) + this.ANNO + "_recb" + ".res");
    }

    public void riempiRecordZ() throws FileNotFoundException, IOException {
        this.recordZ.load(String.valueOf(this.TIPO_MODELLO) + this.ANNO + "_recz" + ".res");
    }

    public String S(String string) {
        return this.getDichiarazione().prendiValoreCampo(string);
    }

    private void scriviListaDiagnostici(String string, String string2, Vector vector, int n, String string3) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            String string5 = string4.substring(0, 4);
            String string6 = string4.substring(4, 20);
            String string7 = string4.substring(20, 36);
            double d = 0.0;
            if (string4.substring(36, 52).trim().length() != 0) {
                d = Util.valoreDouble(string4.substring(36, 52));
            }
            Diagnostici.DIA(0, n, string, string5, string2, string6, string7, d, string3);
            if (BaseTelem.currentSystem != 3) continue;
            this.getDichiarazione().eliminaCampo(new Campo(string2, null));
        }
    }

    public void setDichiarazione(Dichiarazione dichiarazione) {
        this.dich = dichiarazione;
    }

    public void setFlagConferma(boolean bl) {
        this.flagConferma = bl;
    }

    public void setMaxQuadri(Globali globali) {
        this.maxQuadri = globali;
    }

    public void setRecordA(RecordParser recordParser) {
        this.recordA = recordParser;
    }

    public void setRecordB(RecordParser recordParser) {
        this.recordB = recordParser;
    }

    public void setRecordZ(RecordParser recordParser) {
        this.recordZ = recordParser;
    }

    public void setVarGlob(Globali globali) {
        this.varGlob = globali;
    }

    public double ZD(int n) {
        return Util.valoreDouble(this.recordZ.prendiValore(n));
    }

    public int ZI(int n) {
        return Integer.parseInt(this.recordZ.prendiValore(n));
    }

    public String ZS(int n) {
        return this.recordZ.prendiValore(n);
    }
}

