/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.controlli;

import finanze.IDTE.studi2002.campi.ComboBoxModel;
import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.controlli.ControlloQuadroMultiplo;
import finanze.IDTE.studi2002.generale.MetodiUtili;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ControlloUnitaOperativa
extends ControlloQuadroMultiplo {
    protected ControlloUnitaOperativa(String spec_line, Hashtable componentiModel, String nomeQuadro) {
        super(spec_line, componentiModel, nomeQuadro);
    }

    private double calcolaPercentuale(GericoModel model, GericoModel[] models) {
        double somma = 0.0;
        int i = 0;
        while (i < models.length) {
            somma += new Double(models[i].getValue()).doubleValue();
            ++i;
        }
        return new Double(model.getValue()) / somma * 100.0;
    }

    protected void creaMessaggioErrore() {
        this.messaggio = "-- Se nell'unita' operativa non sono presenti posizioni con ricavi al di sopra del 20%, non e' possibile inserire dati relativi alle posizioni!";
    }

    private Hashtable dividiPerPunto() {
        int numeroQuadriMultipli = this.getNumeroQuadriMultipli();
        Hashtable<Double, Vector> hm = new Hashtable<Double, Vector>();
        int i = 0;
        while (i < numeroQuadriMultipli) {
            Vector v;
            Double progressivo = new Double(this.getGericoModel(i, 1).getValue());
            if (hm.containsKey(progressivo)) {
                v = (Vector)hm.get(progressivo);
                v.addElement(this.getModels(i));
            } else {
                v = new Vector();
                v.addElement(this.getModels(i));
                hm.put(progressivo, v);
            }
            ++i;
        }
        return hm;
    }

    private GericoModel[] getModels(int indiceQuadro) {
        GericoModel[] array = new GericoModel[3];
        int i = 0;
        while (i < 3) {
            array[i] = this.getGericoModel(indiceQuadro, i + 1);
            ++i;
        }
        return array;
    }

    private GericoModel[] getModelsRicavi(Vector v) {
        GericoModel[] models = new GericoModel[v.size()];
        int i = 0;
        while (i < v.size()) {
            GericoModel[] array = (GericoModel[])v.elementAt(i);
            models[i] = array[2];
            ++i;
        }
        return models;
    }

    protected void impostaErrore() {
        this.gravitaErrore = "scarto_confermabile";
        this.errore = String.valueOf(this.codErrore);
    }

    public boolean verifica() {
        this.esito = true;
        ComboBoxModel cbm = (ComboBoxModel)this.listaModel.lastElement();
        if (cbm.getValue().equals("2")) {
            return this.esito;
        }
        Hashtable punti = this.dividiPerPunto();
        Enumeration chiavi = punti.keys();
        while (chiavi.hasMoreElements()) {
            Vector v = (Vector)punti.get(chiavi.nextElement());
            if (v.size() == 1 && !MetodiUtili.isCodiceStudio(((GericoModel[])v.elementAt(0))[1].getValue())) {
                this.esito = false;
                break;
            }
            this.esito = false;
            int i = 0;
            while (i < v.size()) {
                double percentuale;
                GericoModel[] array = (GericoModel[])v.elementAt(i);
                String codiceStudio = array[1].getValue();
                if (MetodiUtili.isCodiceStudio(codiceStudio) && (percentuale = this.calcolaPercentuale(array[2], this.getModelsRicavi(v))) > 20.0) {
                    this.esito = true;
                    break;
                }
                ++i;
            }
            if (!this.esito) break;
        }
        if (!this.esito) {
            this.impostaErrore();
            this.creaMessaggioErrore();
        }
        return this.esito;
    }
}

